/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.importexport;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.AccessDeniedException;
import javax.jcr.ImportUUIDBehavior;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.jackrabbit.util.ISO9075;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRMultipleValueUtils;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.services.importexport.AttributeProcessor;
import org.jahia.services.importexport.BaseDocumentViewHandler;
import org.jahia.services.importexport.LegacyImportHandler;
import org.jahia.services.importexport.NoCloseZipInputStream;
import org.jahia.services.importexport.ReferencesHelper;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.Patterns;
import org.jahia.utils.zip.ZipEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class DocumentViewImportHandler
extends BaseDocumentViewHandler
implements ImportUUIDBehavior {
    private static Logger logger = LoggerFactory.getLogger(DocumentViewImportHandler.class);
    public static final int IMPORT_UUID_COLLISION_MOVE_EXISTING = 4;
    public static final int ROOT_BEHAVIOUR_IGNORE = 0;
    public static final int ROOT_BEHAVIOUR_REPLACE = 1;
    public static final int ROOT_BEHAVIOUR_RENAME = 2;
    private int rootBehavior = 1;
    private int maxBatch = SettingsBean.getInstance().getImportMaxBatch();
    private int batchCount = 0;
    private Locator documentLocator;
    private Resource archive;
    private NoCloseZipInputStream zis;
    private ZipEntry nextEntry;
    private List<String> fileList = new ArrayList<String>();
    private String baseFilesPath = "/content";
    private Stack<JCRNodeWrapper> nodes = new Stack();
    private JCRSiteNode site;
    private List<String> dependencies;
    private Map<String, String> uuidMapping;
    private Map<String, String> pathMapping;
    private Map<String, List<String>> references = new HashMap<String, List<String>>();
    private Map<Pattern, String> replacements = Collections.emptyMap();
    private List<AttributeProcessor> attributeProcessors = Collections.emptyList();
    private Set<String> propertiesToSkip = Collections.emptySet();
    private String currentFilePath = null;
    private String ignorePath = null;
    private int error = 0;
    private boolean resolveReferenceAtEnd = true;
    private int uuidBehavior = 0;
    private Map<String, String> placeHoldersMap = new HashMap<String, String>();
    private boolean replaceMultipleValues = false;
    private boolean importUserGeneratedContent = false;
    private int ugcLevel = 0;
    private boolean enforceUuid = false;
    private List<String> noSubNodesImport = Arrays.asList("jnt:importDropBox", "jnt:referencesKeeper");
    private List<String> noUpdateTypes = Arrays.asList("jnt:virtualsitesFolder", "jnt:usersFolder", "jnt:groupsFolder", "jnt:user");
    private List<String> uuids = new ArrayList<String>();
    private boolean expandImportedFilesOnDisk = SettingsBean.getInstance().isExpandImportedFilesOnDisk();
    private String expandImportedFilesOnDiskPath = SettingsBean.getInstance().getExpandImportedFilesOnDiskPath();
    private Set<String> missingDependencies = new HashSet<String>();

    public DocumentViewImportHandler(JCRSessionWrapper session, String rootPath) throws IOException {
        this(session, rootPath, null, null);
    }

    public DocumentViewImportHandler(JCRSessionWrapper session, String rootPath, Resource archive, List<String> fileList) throws IOException {
        super(session);
        JCRNodeWrapper node = null;
        try {
            this.uuidMapping = session.getUuidMapping();
            this.pathMapping = session.getPathMapping();
            node = rootPath == null ? session.getRootNode() : session.getNode(rootPath);
            if (node.isNodeType("jnt:user")) {
                this.placeHoldersMap.put("$user", "u:" + node.getPath().substring(node.getPath().lastIndexOf("/") + 1));
            }
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage() + this.getLocation(), (Throwable)e);
            throw new IOException();
        }
        this.nodes.add(node);
        this.archive = archive;
        this.fileList = fileList;
        this.setPropertiesToSkip((Set)SpringContextSingleton.getBean("DocumentViewImportHandler.propertiesToSkip"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        String newName;
        if (this.error > 0) {
            ++this.error;
            return;
        }
        ++this.batchCount;
        if (this.batchCount > this.maxBatch) {
            try {
                ReferencesHelper.resolveCrossReferences(this.session, this.references, false);
                this.session.save(13);
                this.batchCount = 0;
            }
            catch (ConstraintViolationException e) {
                this.batchCount = this.maxBatch - 1;
            }
            catch (RepositoryException e) {
                throw new SAXException("Cannot save batch", (Exception)((Object)e));
            }
        }
        if (this.ugcLevel > 0 || "live".equals(atts.getValue("j:originWS"))) {
            if (this.importUserGeneratedContent) {
                ++this.ugcLevel;
            } else {
                ++this.error;
                return;
            }
        }
        String decodedLocalName = ISO9075.decode((String)localName);
        for (Map.Entry<Pattern, String> entry : this.replacements.entrySet()) {
            decodedLocalName = entry.getKey().matcher(decodedLocalName).replaceAll(entry.getValue());
        }
        String decodedQName = qName.replace(localName, decodedLocalName);
        if (this.rootBehavior == 2 && this.pathes.size() <= 1 && !this.pathMapping.containsKey((String)this.pathes.peek() + "/" + decodedQName) && !decodedQName.equals(newName = JCRContentUtils.findAvailableNodeName(this.nodes.peek(), decodedQName))) {
            this.pathMapping.put(this.nodes.peek().getPath() + "/" + decodedQName + "/", this.nodes.peek().getPath() + "/" + newName + "/");
            decodedQName = newName;
        }
        if (this.rootBehavior == 0 && this.pathes.size() <= 1) {
            this.session.getPathMapping().put("/" + decodedQName + "/", this.nodes.peek().getPath().equals("/") ? "/" : this.nodes.peek().getPath() + "/");
            this.pathes.push("");
            return;
        }
        this.pathes.push((String)this.pathes.peek() + "/" + decodedQName);
        try {
            Matcher m;
            if (this.ignorePath != null) {
                this.nodes.push(null);
                return;
            }
            String path = this.nodes.peek().getPath().equals("/") ? "/" + decodedQName : this.nodes.peek().getPath() + "/" + decodedQName;
            if (((String)this.pathes.peek()).startsWith("/users/") && "jnt:user".equals(atts.getValue("jcr:primaryType")) && (m = Pattern.compile("/users/([^/]+)").matcher((CharSequence)this.pathes.peek())).matches()) {
                path = ServicesRegistry.getInstance().getJahiaUserManagerService().getUserSplittingRule().getPathForUsername(m.group(1));
            }
            String pt = atts.getValue("jcr:primaryType");
            if (this.pathMapping.containsKey(path + "/")) {
                path = StringUtils.substringBeforeLast((String)this.pathMapping.get(path + "/"), (String)"/");
                decodedQName = StringUtils.substringAfter((String)path, (String)"/");
            }
            if (this.noSubNodesImport.contains(pt)) {
                this.ignorePath = path;
            }
            JCRNodeWrapper child = null;
            boolean isValid = true;
            try {
                child = this.session.getNode(path);
                if (child.hasPermission("jcr:versionManagement") && child.isVersioned() && !child.isCheckedOut()) {
                    this.session.checkout(child);
                }
            }
            catch (PathNotFoundException e) {
                isValid = false;
            }
            if (!this.importUserGeneratedContent || this.ugcLevel > 0) {
                String originalUuid = atts.getValue("jcr:uuid");
                String uuid = originalUuid;
                if (uuid != null && this.uuidMapping.containsKey(uuid)) {
                    uuid = this.uuidMapping.get(uuid);
                } else if (this.enforceUuid) {
                    uuid = null;
                }
                if (isValid && this.enforceUuid && uuid != null && !child.getIdentifier().equals(uuid)) {
                    child.remove();
                    isValid = false;
                }
                if (!isValid || child.getDefinition().allowsSameNameSiblings()) {
                    isValid = false;
                    if (!this.nodes.peek().hasPermission("jcr:addChildNodes")) throw new AccessDeniedException("Missing jcr:addChildNodes permission for user " + this.session.getUser().getUsername());
                    if ("jnt:acl".equals(pt) && !this.nodes.peek().isNodeType("jmix:accessControlled")) {
                        this.nodes.peek().addMixin("jmix:accessControlled");
                    }
                    Calendar created = null;
                    String createdBy = null;
                    Calendar lastModified = null;
                    String lastModifiedBy = null;
                    if (!StringUtils.isEmpty((String)atts.getValue("jcr:created"))) {
                        created = ISO8601.parse((String)atts.getValue("jcr:created"));
                    }
                    if (!StringUtils.isEmpty((String)atts.getValue("jcr:lastModified"))) {
                        lastModified = ISO8601.parse((String)atts.getValue("jcr:lastModified"));
                    }
                    if (!StringUtils.isEmpty((String)atts.getValue("jcr:createdBy"))) {
                        createdBy = atts.getValue("jcr:createdBy");
                    }
                    if (!StringUtils.isEmpty((String)atts.getValue("jcr:lastModifiedBy"))) {
                        lastModifiedBy = atts.getValue("jcr:lastModifiedBy");
                    }
                    if (!StringUtils.isEmpty((String)uuid)) {
                        switch (this.uuidBehavior) {
                            case 3: {
                                JCRNodeWrapper node;
                                try {
                                    node = this.session.getNodeByUUID(uuid);
                                    if (!node.isNodeType("mix:shareable")) {
                                        throw new ItemExistsException(uuid);
                                    }
                                }
                                catch (ItemNotFoundException e) {
                                    // empty catch block
                                }
                            }
                            case 1: {
                                JCRNodeWrapper node;
                                try {
                                    node = this.session.getNodeByUUID(uuid);
                                    if (this.nodes.peek().getPath().startsWith(node.getPath())) {
                                        String msg = "cannot remove ancestor node";
                                        logger.debug(msg);
                                        throw new ConstraintViolationException(msg);
                                    }
                                    node.remove();
                                }
                                catch (ItemNotFoundException e) {}
                                break;
                            }
                            case 2: {
                                throw new UnsupportedOperationException();
                            }
                            case 0: {
                                uuid = null;
                                break;
                            }
                            case 4: {
                                JCRNodeWrapper node;
                                try {
                                    node = this.session.getNodeByUUID(uuid);
                                    if (this.nodes.peek().getPath().startsWith(node.getPath())) {
                                        String msg = "cannot move ancestor node";
                                        logger.debug(msg);
                                        throw new ConstraintViolationException(msg);
                                    }
                                    if (!node.getPath().equals(path)) {
                                        this.session.move(node.getPath(), path);
                                        node = this.session.getNodeByUUID(uuid);
                                    }
                                    child = node;
                                    isValid = true;
                                    break;
                                }
                                catch (ItemNotFoundException e) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    if (!isValid) {
                        this.session.checkout(this.nodes.peek());
                        try {
                            this.checkDependencies(path, pt, atts);
                            child = this.nodes.peek().addNode(decodedQName, pt, uuid, created, createdBy, lastModified, lastModifiedBy);
                        }
                        catch (ConstraintViolationException e) {
                            if (this.pathes.size() > 2 || !this.nodes.peek().getName().equals(decodedQName) || !this.nodes.peek().getPrimaryNodeTypeName().equals(pt)) throw e;
                            this.session.getPathMapping().put("/" + decodedQName, this.nodes.peek().getPath().equals("/") ? "" : this.nodes.peek().getPath());
                            return;
                        }
                    }
                    this.addMixins(child, atts);
                    this.uploadFile(atts, decodedQName, path, child);
                    this.setAttributes(child, atts);
                    this.uuids.add(child.getIdentifier());
                    if (child.isFile() && this.currentFilePath == null) {
                        this.currentFilePath = child.getPath();
                    }
                } else {
                    if (child.hasPermission("jcr:modifyProperties") && child.isCheckedOut() && !this.noUpdateTypes.contains(child.getPrimaryNodeType().getName()) && atts.getValue("jcr:primaryType") != null) {
                        this.addMixins(child, atts);
                        this.setAttributes(child, atts);
                        this.uploadFile(atts, decodedQName, path, child);
                    }
                    this.uuids.add(child.getIdentifier());
                }
                if (originalUuid != null) {
                    this.uuidMapping.put(originalUuid, child.getIdentifier());
                }
                if (this.nodes.peek().getPrimaryNodeType().hasOrderableChildNodes() && this.nodes.peek().hasPermission("jcr:write")) {
                    this.nodes.peek().orderBefore(decodedQName, null);
                }
            }
            if (child == null) {
                ++this.error;
                return;
            } else {
                this.nodes.push(child);
            }
            return;
        }
        catch (NoSuchNodeTypeException e) {
            if (logger.isDebugEnabled()) {
                logger.warn("Cannot import " + (String)this.pathes.pop(), (Throwable)e);
            } else {
                logger.warn("Cannot import \"{}\" due to missing node type definition \"{}\"", this.pathes.pop(), (Object)e.getMessage());
            }
            ++this.error;
            return;
        }
        catch (AccessDeniedException e) {
            if (logger.isDebugEnabled()) {
                logger.warn("Cannot import " + (String)this.pathes.pop() + this.getLocation(), (Throwable)e);
            } else {
                logger.warn("Cannot import \"{}\" due to \"{}\"", this.pathes.pop(), (Object)e.getMessage());
            }
            ++this.error;
            return;
        }
        catch (RepositoryException re) {
            logger.error("Cannot import " + (String)this.pathes.pop() + this.getLocation(), (Throwable)re);
            ++this.error;
            return;
        }
        catch (Exception re) {
            throw new SAXException(re);
        }
    }

    private void uploadFile(Attributes atts, String decodedQName, String path, JCRNodeWrapper child) throws IOException, RepositoryException {
        if (!this.expandImportedFilesOnDisk) {
            boolean contentFound = this.findContent();
            if (contentFound) {
                this.uploadFile(atts, decodedQName, path, child, this.zis);
                this.zis.close();
            }
        } else {
            String contentInExpandedPath = this.findContentInExpandedPath();
            if (contentInExpandedPath != null) {
                FileInputStream is = FileUtils.openInputStream((File)new File(this.expandImportedFilesOnDiskPath + contentInExpandedPath));
                this.uploadFile(atts, decodedQName, path, child, is);
                ((InputStream)is).close();
            }
        }
    }

    private void uploadFile(Attributes atts, String decodedQName, String path, JCRNodeWrapper child, InputStream is) throws RepositoryException {
        if (child.isFile()) {
            String mime = atts.getValue("jcr:mimeType");
            if (mime == null && logger.isWarnEnabled()) {
                mime = JCRContentUtils.getMimeType(decodedQName);
                if (mime != null) {
                    logger.warn("Legacy or invalid import detected for node " + path + ", mime type cannot be resolved from file node, it should come from jcr:content node. Resolved mime type using servlet context instead=" + mime + ".");
                } else {
                    logger.warn("Legacy or invalid import detected for node " + path + ", mime type cannot be resolved from file node, it should come from jcr:content node. Tried resolving mime type using servlet context but it isn't registered!");
                }
            }
            child.getFileContent().uploadFile(is, mime);
        } else {
            child.setProperty("jcr:data", this.session.getValueFactory().createBinary(is));
            child.setProperty("jcr:mimeType", atts.getValue("jcr:mimeType"));
            child.setProperty("jcr:lastModified", Calendar.getInstance());
        }
    }

    private void checkDependencies(String path, String pt, Attributes atts) throws RepositoryException {
        if (path.startsWith("/modules/")) {
            ArrayList<ExtendedNodeType> nodeTypes = new ArrayList<ExtendedNodeType>();
            nodeTypes.add(NodeTypeRegistry.getInstance().getNodeType(pt));
            if (atts.getValue("jcr:mixinTypes") != null) {
                for (String mixin : atts.getValue("jcr:mixinTypes").split(" ")) {
                    nodeTypes.add(NodeTypeRegistry.getInstance().getNodeType(mixin));
                }
            }
            JCRSiteNode currentSite = this.nodes.peek().getResolveSite();
            if (this.site == null || !currentSite.getIdentifier().equals(this.site.getIdentifier())) {
                this.dependencies = null;
                this.site = currentSite;
                if (this.site.hasProperty("j:resolvedDependencies")) {
                    this.dependencies = new ArrayList<String>();
                    this.dependencies.add(this.site.getName());
                    for (int i = 0; i < this.dependencies.size(); ++i) {
                        JahiaTemplatesPackage aPackage = ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackageById(this.dependencies.get(i));
                        if (aPackage == null) continue;
                        for (JahiaTemplatesPackage depend : aPackage.getDependencies()) {
                            if (this.dependencies.contains(depend.getId())) continue;
                            this.dependencies.add(depend.getId());
                        }
                    }
                }
            }
            for (ExtendedNodeType type : nodeTypes) {
                if (type.getTemplatePackage() == null || this.dependencies == null || this.dependencies.contains(type.getTemplatePackage().getId())) continue;
                String fileName = type.getTemplatePackage().getId();
                logger.debug("Missing dependency : " + path + " (" + type.getName() + ") requires " + fileName + this.getLocation());
                if (this.missingDependencies.contains(fileName)) continue;
                this.missingDependencies.add(fileName);
            }
        }
    }

    private void addMixins(JCRNodeWrapper child, Attributes atts) throws RepositoryException {
        ExtendedNodeType[] existingMixinNodeTypes = child.getMixinNodeTypes();
        String m = atts.getValue("jcr:mixinTypes");
        if (m != null) {
            LinkedHashSet<String> addedMixins = new LinkedHashSet<String>(Arrays.asList(StringUtils.split((String)m, (String)" ,")));
            for (ExtendedNodeType existingMixin : existingMixinNodeTypes) {
                String existingMixinName = existingMixin.getName();
                if (addedMixins.contains(existingMixinName)) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug("Removing mixin {} from node {}", (Object)existingMixinName, (Object)child.getPath());
                }
                child.removeMixin(existingMixinName);
            }
            for (String addedMixin : addedMixins) {
                try {
                    child.addMixin(addedMixin);
                }
                catch (NoSuchNodeTypeException e) {
                    logger.warn("Cannot add node type " + e.getMessage());
                }
            }
        }
    }

    private void setAttributes(JCRNodeWrapper child, Attributes atts) throws RepositoryException {
        String lang = null;
        if (child.getPrimaryNodeTypeName().equals("jnt:translation")) {
            lang = atts.getValue("jcr:language");
            child.setProperty("jcr:language", lang);
        }
        for (int i = 0; i < atts.getLength(); ++i) {
            if (atts.getURI(i).equals("http://www.w3.org/2000/xmlns/")) continue;
            String attrName = ISO9075.decode((String)atts.getQName(i));
            String attrValue = atts.getValue(i);
            boolean processed = false;
            for (AttributeProcessor attributeProcessor : this.attributeProcessors) {
                if (!attributeProcessor.process(child, attrName, attrValue)) continue;
                processed = true;
                break;
            }
            if (processed) continue;
            for (String string : this.placeHoldersMap.keySet()) {
                if (!attrValue.contains(string)) continue;
                attrValue = attrValue.replace(string, this.placeHoldersMap.get(string));
            }
            if (this.propertiesToSkip.contains(attrName)) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Skipping property {}", (Object)attrName);
                continue;
            }
            for (Map.Entry entry : this.replacements.entrySet()) {
                attrValue = ((Pattern)entry.getKey()).matcher(attrValue).replaceAll((String)entry.getValue());
            }
            if (attrName.equals("j:privileges") && child.isNodeType("jnt:ace")) {
                attrName = "j:roles";
                attrValue = this.mapAclAttributes(child, attrValue);
            }
            if ((attrName.equals("jcr:title") || attrName.equals("jcr:description")) && !child.isNodeType("mix:title")) {
                child.addMixin("mix:title");
            } else if (attrName.equals("j:defaultCategory") && !child.isNodeType("jmix:categorized")) {
                child.addMixin("jmix:categorized");
            }
            ExtendedPropertyDefinition propDef = child.getApplicablePropertyDefinition(attrName);
            if (propDef == null) {
                logger.error("Couldn't find definition for property " + attrName + " in " + child.getPrimaryNodeTypeName() + this.getLocation());
                continue;
            }
            if (propDef.getRequiredType() == 0) {
                logger.error("Couldn't resolve property type for property " + attrName + " in " + child.getPrimaryNodeTypeName() + this.getLocation());
                continue;
            }
            if (propDef.getRequiredType() == 9 || propDef.getRequiredType() == 10) {
                String[] stringArray;
                String[] stringArray2;
                if (attrValue.length() <= 0) continue;
                if (propDef.isMultiple()) {
                    stringArray2 = Patterns.SPACE.split(attrValue);
                } else {
                    String[] stringArray3 = new String[1];
                    stringArray2 = stringArray3;
                    stringArray3[0] = attrValue;
                }
                for (String value : stringArray = stringArray2) {
                    if (StringUtils.isEmpty((String)(value = JCRMultipleValueUtils.decode(value)))) continue;
                    if (value.startsWith("$currentSite")) {
                        value = this.nodes.peek().getResolveSite().getPath() + value.substring(12);
                    } else if (value.startsWith("#")) {
                        value = value.substring(1);
                        String rootPath = ((JCRNodeWrapper)this.nodes.firstElement()).getPath();
                        if (!rootPath.equals("/")) {
                            value = rootPath + value;
                        }
                    }
                    if (attrName.equals("j:defaultCategory") && value.startsWith("/root")) {
                        value = JCRContentUtils.getSystemSitePath() + "/categories" + StringUtils.substringAfter((String)value, (String)"/root");
                    }
                    if (!this.references.containsKey(value)) {
                        this.references.put(value, new ArrayList());
                    }
                    this.references.get(value).add(child.getIdentifier() + "/" + attrName);
                }
                continue;
            }
            if (propDef.isMultiple()) {
                ArrayList<Value> values;
                String[] stringArray = "".equals(attrValue) ? new String[]{} : Patterns.SPACE.split(attrValue);
                ArrayList<Value> oldvalues = new ArrayList<Value>();
                if (child.getRealNode().hasProperty(attrName)) {
                    Value[] oldValues;
                    for (Value oldValue : oldValues = child.getRealNode().getProperty(attrName).getValues()) {
                        oldvalues.add(oldValue);
                    }
                }
                if (this.replaceMultipleValues) {
                    values = new ArrayList<Value>();
                    for (int j = 0; j < stringArray.length; ++j) {
                        values.add(child.getRealNode().getSession().getValueFactory().createValue(JCRMultipleValueUtils.decode(stringArray[j]), propDef.getRequiredType()));
                    }
                    if (values.equals(oldvalues)) continue;
                    child.getRealNode().setProperty(attrName, values.toArray(new Value[values.size()]));
                    continue;
                }
                values = new ArrayList(oldvalues);
                for (int j = 0; j < stringArray.length; ++j) {
                    Value value = child.getRealNode().getSession().getValueFactory().createValue(JCRMultipleValueUtils.decode(stringArray[j]), propDef.getRequiredType());
                    if (oldvalues.contains(value)) continue;
                    values.add(value);
                }
                try {
                    if (values.equals(oldvalues)) continue;
                    child.getRealNode().setProperty(attrName, values.toArray(new Value[values.size()]));
                }
                catch (RepositoryException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                continue;
            }
            if (child.getRealNode().hasProperty(attrName) && child.getRealNode().getProperty(attrName).getString().equals(attrValue)) continue;
            child.getRealNode().setProperty(attrName, attrValue, propDef.getRequiredType());
        }
    }

    private boolean findContent() throws IOException {
        String path;
        if (this.archive == null) {
            return false;
        }
        if (this.zis == null) {
            this.zis = new NoCloseZipInputStream(new BufferedInputStream(this.archive.getInputStream()));
            this.nextEntry = this.zis.getNextEntry();
        }
        if ((path = (String)this.pathes.peek()).endsWith("/jcr:content")) {
            String[] p = Patterns.SLASH.split(path);
            path = path.replace("/jcr:content", "/" + p[p.length - 2]);
        } else {
            path = JCRContentUtils.replaceColon(path);
        }
        int fileIndex = this.fileList.indexOf(this.baseFilesPath + path);
        if (fileIndex == -1 && path.startsWith("/content")) {
            path = path.substring("/content".length());
            fileIndex = this.fileList.indexOf(this.baseFilesPath + path);
        }
        if (fileIndex != -1) {
            if (this.fileList.indexOf("/" + this.nextEntry.getName().replace('\\', '/')) > fileIndex) {
                this.zis.reallyClose();
                this.zis = new NoCloseZipInputStream(new BufferedInputStream(this.archive.getInputStream()));
            }
            do {
                this.nextEntry = this.zis.getNextEntry();
            } while (!("/" + this.nextEntry.getName().replace('\\', '/')).equals(this.baseFilesPath + path));
            return true;
        }
        return false;
    }

    private String findContentInExpandedPath() throws IOException {
        if (this.archive == null) {
            return null;
        }
        String path = (String)this.pathes.peek();
        if (path.endsWith("/jcr:content")) {
            String[] p = Patterns.SLASH.split(path);
            path = path.replace("/jcr:content", "/" + p[p.length - 2]);
        } else {
            path = JCRContentUtils.replaceColon(path);
        }
        int fileIndex = this.fileList.indexOf(this.baseFilesPath + path);
        if (fileIndex == -1 && path.startsWith("/content")) {
            path = path.substring("/content".length());
            fileIndex = this.fileList.indexOf(this.baseFilesPath + path);
        }
        if (fileIndex != -1) {
            return this.baseFilesPath + path;
        }
        return null;
    }

    private String mapAclAttributes(JCRNodeWrapper node, String aclValue) {
        HashSet<String> roles = new HashSet<String>();
        if (aclValue.contains("jcr:read")) {
            if (CollectionUtils.isEmpty(LegacyImportHandler.CUSTOM_FILES_READ_ROLES)) {
                roles.addAll(LegacyImportHandler.READ_ROLES);
            } else {
                roles.addAll(LegacyImportHandler.CUSTOM_FILES_READ_ROLES);
            }
        }
        if (aclValue.contains("jcr:write")) {
            if (CollectionUtils.isEmpty(LegacyImportHandler.CUSTOM_FILES_WRITE_ROLES)) {
                roles.addAll(LegacyImportHandler.WRITE_ROLES);
            } else {
                roles.addAll(LegacyImportHandler.CUSTOM_FILES_WRITE_ROLES);
            }
        }
        StringBuilder s = new StringBuilder();
        for (String role : roles) {
            s.append(role).append(" ");
        }
        return s.toString().trim();
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.error > 0) {
            --this.error;
            return;
        }
        if (this.ugcLevel > 0) {
            --this.ugcLevel;
        }
        JCRNodeWrapper w = this.nodes.pop();
        this.pathes.pop();
        if (w != null && this.ignorePath != null && w.getPath().equals(this.ignorePath)) {
            this.ignorePath = null;
        }
        if (w != null && this.currentFilePath != null && w.getPath().equals(this.currentFilePath)) {
            this.currentFilePath = null;
        }
        if (w != null && w.isFile()) {
            try {
                if (!w.hasNode("jcr:content") || !w.getNode("jcr:content").hasProperty("jcr:data")) {
                    logger.warn("Cannot find the file content for the node " + w.getPath() + ". Skipping importing it.");
                    JCRNodeIteratorWrapper iterator = w.getNodes();
                    while (iterator.hasNext()) {
                        Node node = iterator.nextNode();
                        this.uuids.remove(node.getIdentifier());
                    }
                    this.uuids.remove(w.getIdentifier());
                    w.remove();
                }
            }
            catch (RepositoryException e) {
                throw new SAXException((Exception)((Object)e));
            }
        }
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.zis != null) {
            try {
                this.zis.reallyClose();
            }
            catch (IOException re) {
                throw new SAXException(re);
            }
            this.zis = null;
        }
        try {
            if (this.resolveReferenceAtEnd) {
                ReferencesHelper.resolveCrossReferences(this.session, this.references, false);
            }
        }
        catch (RepositoryException e) {
            throw new SAXException((Exception)((Object)e));
        }
    }

    public void setReferences(Map<String, List<String>> references) {
        this.references = references;
    }

    public void setRootBehavior(int rootBehavior) {
        this.rootBehavior = rootBehavior;
    }

    public void setUuidBehavior(int uuidBehavior) {
        this.uuidBehavior = uuidBehavior;
    }

    public void setResolveReferenceAtEnd(boolean resolveReferenceAtEnd) {
        this.resolveReferenceAtEnd = resolveReferenceAtEnd;
    }

    public void setPlaceHoldersMap(Map<String, String> placeHoldersMap) {
        this.placeHoldersMap = placeHoldersMap;
    }

    public List<String> getNoUpdateTypes() {
        return this.noUpdateTypes;
    }

    public void setNoUpdateTypes(List<String> noUpdateTypes) {
        this.noUpdateTypes = noUpdateTypes;
    }

    public boolean isImportUserGeneratedContent() {
        return this.importUserGeneratedContent;
    }

    public void setImportUserGeneratedContent(boolean importUserGeneratedContent) {
        this.importUserGeneratedContent = importUserGeneratedContent;
    }

    public boolean isReplaceMultipleValues() {
        return this.replaceMultipleValues;
    }

    public void setReplaceMultipleValues(boolean replaceMultipleValues) {
        this.replaceMultipleValues = replaceMultipleValues;
    }

    public boolean isEnforceUuid() {
        return this.enforceUuid;
    }

    public void setEnforceUuid(boolean enforceUuid) {
        this.enforceUuid = enforceUuid;
    }

    public void setReplacements(Map<String, String> replacements) {
        if (replacements == null || replacements.isEmpty()) {
            this.replacements = Collections.emptyMap();
        } else {
            this.replacements = new HashMap<Pattern, String>(replacements.size());
            for (Map.Entry<String, String> repl : replacements.entrySet()) {
                this.replacements.put(Pattern.compile(repl.getKey()), repl.getValue());
            }
        }
    }

    public void setAttributeProcessors(List<AttributeProcessor> attributeProcessors) {
        this.attributeProcessors = attributeProcessors;
    }

    public Set<String> getPropertiesToSkip() {
        return this.propertiesToSkip;
    }

    public void setPropertiesToSkip(Set<String> propertiesToSkip) {
        this.propertiesToSkip = propertiesToSkip == null || propertiesToSkip.isEmpty() ? Collections.emptySet() : propertiesToSkip;
    }

    public List<String> getUuids() {
        return this.uuids;
    }

    public String getBaseFilesPath() {
        return this.baseFilesPath;
    }

    public void setBaseFilesPath(String baseFilesPath) {
        this.baseFilesPath = baseFilesPath;
    }

    public String getLocation() {
        if (this.documentLocator != null) {
            return " (line " + this.documentLocator.getLineNumber() + ", column " + this.documentLocator.getColumnNumber() + ")";
        }
        return "";
    }

    public Set<String> getMissingDependencies() {
        return this.missingDependencies;
    }

    @Override
    public void setDocumentLocator(Locator documentLocator) {
        this.documentLocator = documentLocator;
    }
}

