/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.importexport;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.tika.io.IOUtils;
import org.jahia.ajax.gwt.client.service.GWTJahiaServiceException;
import org.jahia.ajax.gwt.content.server.GWTFileManagerUploadServlet;
import org.jahia.exceptions.JahiaException;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.decorator.JCRFileNode;
import org.jahia.services.importexport.ImportExportBaseService;
import org.jahia.services.scheduler.BackgroundJob;
import org.jahia.services.sites.JahiaSite;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class ImportJob
extends BackgroundJob {
    private static final Logger logger = LoggerFactory.getLogger(ImportJob.class);
    public static final String TARGET = "target";
    public static final String CONTENT_TYPE = "contentType";
    public static final String PUBLISH_ALL_AT_END = "publishAllAtEnd";
    public static final String URI = "uri";
    public static final String FILE_KEY = "fileKey";
    public static final String DESTINATION_PARENT_PATH = "destParentPath";
    public static final String FILENAME = "filename";
    public static final String DELETE_FILE = "delete";
    public static final String ORIGINATING_JAHIA_RELEASE = "originatingJahiaRelease";
    public static final String COPY_TO_JCR = "copyToJCR";
    public static final String REPLACE_CONTENT = "replaceContent";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeJahiaJob(JobExecutionContext jobExecutionContext) throws Exception {
        JobDetail jobDetail = jobExecutionContext.getJobDetail();
        JobDataMap jobDataMap = jobDetail.getJobDataMap();
        JahiaSite site = ServicesRegistry.getInstance().getJahiaSitesService().getSiteByKey((String)jobDataMap.get((Object)"sitekey"));
        String uri = (String)jobDataMap.get((Object)URI);
        if (uri != null) {
            JCRSessionWrapper session = ServicesRegistry.getInstance().getJCRStoreService().getSessionFactory().getCurrentUserSession();
            JCRFileNode f = (JCRFileNode)session.getNode(uri);
            String destinationParentPath = (String)jobDataMap.get((Object)DESTINATION_PARENT_PATH);
            if (destinationParentPath == null) {
                if (f != null) {
                    File file = JCRContentUtils.downloadFileContent(f, File.createTempFile("import", ".zip"));
                    try {
                        ServicesRegistry.getInstance().getImportExportService().importSiteZip((Resource)(file == null ? null : new FileSystemResource(file)), site, (Map<Object, Object>)jobDataMap);
                        f.remove();
                        session.save();
                    }
                    finally {
                        if (file != null) {
                            file.delete();
                        }
                    }
                }
            } else if (f != null) {
                String filename = (String)jobDataMap.get((Object)FILENAME);
                File file = JCRContentUtils.downloadFileContent(f, File.createTempFile("import", "." + FilenameUtils.getExtension((String)filename)));
                if (jobDataMap.containsKey((Object)REPLACE_CONTENT)) {
                    ImportJob.importContent(destinationParentPath, jobDataMap.getBoolean(REPLACE_CONTENT), file, f.getFileContent().getContentType());
                } else {
                    ImportJob.importContent(destinationParentPath, false, file, f.getFileContent().getContentType());
                }
                FileUtils.deleteQuietly((File)file);
                f.remove();
                session.save();
            }
        } else {
            String destinationParentPath = (String)jobDataMap.get((Object)DESTINATION_PARENT_PATH);
            String fileKey = (String)jobDataMap.get((Object)FILE_KEY);
            if (jobDataMap.containsKey((Object)REPLACE_CONTENT)) {
                ImportJob.importContent(destinationParentPath, fileKey, jobDataMap.getBoolean(REPLACE_CONTENT));
            } else {
                ImportJob.importContent(destinationParentPath, fileKey, false);
            }
        }
    }

    public static void importContent(String parentPath, String fileKey, boolean replaceContent) throws Exception {
        GWTFileManagerUploadServlet.Item item = GWTFileManagerUploadServlet.getItem(fileKey);
        String contentType = ImportExportBaseService.detectImportContentType(item);
        try {
            if (replaceContent) {
                parentPath = StringUtils.substringBeforeLast((String)parentPath, (String)"/");
            }
            ImportJob.importContent(parentPath, replaceContent, item.getFile(), contentType);
        }
        catch (Exception e) {
            logger.error("Error when importing", (Throwable)e);
            throw new GWTJahiaServiceException("Error when importing", (Throwable)e);
        }
        finally {
            item.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void importContent(String parentPath, boolean replaceContent, File file, String contentType) throws IOException, RepositoryException, JahiaException {
        ImportExportBaseService importExport = ServicesRegistry.getInstance().getImportExportService();
        if ("application/zip".equals(contentType)) {
            importExport.importZip(parentPath, (Resource)new FileSystemResource(file), replaceContent ? 1 : 1);
        } else if ("application/xml".equals(contentType) || "text/xml".equals(contentType)) {
            FileInputStream is = new FileInputStream(file);
            try {
                importExport.importXML(parentPath, is, replaceContent ? 1 : 1);
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
    }
}

