/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.importexport.validation;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.importexport.validation.ValidationResult;

public class MissingNodetypesValidationResult
implements ValidationResult,
Serializable {
    private static final long serialVersionUID = -5817064601349300396L;
    private Map<String, Set<String>> missingMixins = new TreeMap<String, Set<String>>();
    private Map<String, Set<String>> missingNodetypes = new TreeMap<String, Set<String>>();

    public MissingNodetypesValidationResult(Map<String, Set<String>> missingNodetypes, Map<String, Set<String>> missingMixins) {
        this.missingNodetypes = missingNodetypes;
        this.missingMixins = missingMixins;
    }

    protected MissingNodetypesValidationResult(MissingNodetypesValidationResult result1, MissingNodetypesValidationResult result2) {
        this.missingNodetypes.putAll(result1.getMissingNodetypes());
        this.missingMixins.putAll(result1.getMissingMixins());
        for (Map.Entry<String, Set<String>> item : result2.getMissingNodetypes().entrySet()) {
            if (this.missingNodetypes.containsKey(item.getKey())) {
                this.missingNodetypes.get(item.getKey()).addAll((Collection<String>)item.getValue());
                continue;
            }
            this.missingNodetypes.put(item.getKey(), item.getValue());
        }
        for (Map.Entry<String, Set<String>> item : result2.getMissingMixins().entrySet()) {
            if (this.missingMixins.containsKey(item.getKey())) {
                this.missingMixins.get(item.getKey()).addAll((Collection<String>)item.getValue());
                continue;
            }
            this.missingMixins.put(item.getKey(), item.getValue());
        }
    }

    public Map<String, Set<String>> getMissingMixins() {
        return this.missingMixins;
    }

    public Map<String, Set<String>> getMissingNodetypes() {
        return this.missingNodetypes;
    }

    @Override
    public boolean isSuccessful() {
        return this.missingNodetypes.isEmpty() && this.missingMixins.isEmpty();
    }

    @Override
    public ValidationResult merge(ValidationResult toBeMergedWith) {
        return toBeMergedWith == null || toBeMergedWith.isSuccessful() || !(toBeMergedWith instanceof MissingNodetypesValidationResult) ? this : new MissingNodetypesValidationResult(this, (MissingNodetypesValidationResult)toBeMergedWith);
    }

    public void setMissingMixins(Map<String, Set<String>> missingMixins) {
        this.missingMixins = missingMixins;
    }

    public void setMissingNodetypes(Map<String, Set<String>> missingNodetypes) {
        this.missingNodetypes = missingNodetypes;
    }

    public String toString() {
        StringBuilder out = new StringBuilder(128);
        out.append("[").append(StringUtils.substringAfterLast((String)this.getClass().getName(), (String)".")).append("=").append(this.isSuccessful() ? "successful" : "failure");
        if (!this.isSuccessful()) {
            out.append(", missingNodetypes=").append(this.missingNodetypes);
            out.append(", missingMixins=").append(this.missingMixins);
        }
        out.append("]");
        return out.toString();
    }
}

