/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.importexport.validation;

import java.util.HashSet;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.util.ISO9075;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.importexport.validation.ImportValidator;
import org.jahia.services.importexport.validation.MissingPortletsValidationResult;
import org.jahia.services.importexport.validation.ValidationResult;
import org.xml.sax.Attributes;

public class MissingPortletsValidator
implements ImportValidator {
    private Set<String> missingPortlets = new HashSet<String>();
    private Set<String> unresolvedInstances = new HashSet<String>();
    private Set<String> unresolvedDefinitions = new HashSet<String>();
    private Set<String> importedPortletInstancePaths = new HashSet<String>();
    private Set<String> importedPortletDefinitionPaths = new HashSet<String>();
    private String currentSitePath = null;

    @Override
    public ValidationResult getResult() {
        if (this.unresolvedDefinitions.size() > 0) {
            for (String unresolvedDefinition : this.unresolvedDefinitions) {
                if (this.importedPortletDefinitionPaths.contains(unresolvedDefinition)) continue;
                this.missingPortlets.add(unresolvedDefinition);
            }
        }
        if (this.unresolvedInstances.size() > 0) {
            for (String unresolvedInstance : this.unresolvedInstances) {
                if (this.importedPortletInstancePaths.contains(unresolvedInstance)) continue;
                this.missingPortlets.add(unresolvedInstance);
            }
        }
        return new MissingPortletsValidationResult(this.missingPortlets);
    }

    public String resolveRefPath(String rootPath, String currentSitePath, String refPath) {
        if (refPath == null) {
            return null;
        }
        if ("#/".equals(refPath)) {
            return rootPath;
        }
        if (refPath.startsWith("#/")) {
            return rootPath + refPath.substring(2);
        }
        if (refPath.startsWith("$currentSite")) {
            return currentSitePath + refPath;
        }
        return refPath;
    }

    @Override
    public void validate(String decodedLocalName, String decodedQName, String currentPath, Attributes atts) {
        if (this.appServiceNotAvailable()) {
            return;
        }
        String rootPath = "/";
        String pt = atts.getValue("jcr:primaryType");
        if (pt != null) {
            String nodeRef;
            if ("jnt:virtualsite".equals(pt)) {
                this.currentSitePath = currentPath;
                if (this.currentSitePath.startsWith("/content")) {
                    this.currentSitePath = this.currentSitePath.substring("/content".length());
                }
            } else if ("jnt:portletDefinition".equals(pt)) {
                if (currentPath.startsWith("/content/portletdefinitions/")) {
                    currentPath = currentPath.substring("/content".length());
                }
                this.importedPortletDefinitionPaths.add(currentPath);
                String context = atts.getValue("j:context");
                try {
                    ServicesRegistry.getInstance().getApplicationsManagerService().getApplicationByContext(context);
                }
                catch (Exception e) {
                    this.missingPortlets.add(currentPath);
                }
            } else if ("jnt:portlet".equals(pt)) {
                if (currentPath.startsWith("/content/sites/")) {
                    currentPath = currentPath.substring("/content".length());
                }
                this.importedPortletInstancePaths.add(currentPath);
                final String applicationRef = this.resolveRefPath(rootPath, this.currentSitePath, atts.getValue("j:applicationRef"));
                String application = atts.getValue("j:application");
                if (applicationRef == null) {
                    this.missingPortlets.add("Missing ref for portlet" + application);
                    return;
                }
                try {
                    JCRTemplate.getInstance().doExecuteWithSystemSession(new JCRCallback<Object>(){

                        @Override
                        public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                            session.getNode(applicationRef);
                            return null;
                        }
                    });
                }
                catch (RepositoryException e) {
                    this.unresolvedDefinitions.add(applicationRef);
                }
            } else if ("jnt:portletReference".equals(pt) && !this.importedPortletInstancePaths.contains(nodeRef = ISO9075.decode((String)StringUtils.defaultString((String)this.resolveRefPath(rootPath, this.currentSitePath, atts.getValue("j:node")))))) {
                try {
                    JCRTemplate.getInstance().doExecuteWithSystemSession(new JCRCallback<Object>(){

                        @Override
                        public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                            session.getNode(nodeRef);
                            return null;
                        }
                    });
                }
                catch (RepositoryException e) {
                    this.unresolvedInstances.add(nodeRef);
                }
            }
        }
    }

    private boolean appServiceNotAvailable() {
        if (ServicesRegistry.getInstance() == null) {
            return true;
        }
        return ServicesRegistry.getInstance().getApplicationsManagerService() == null;
    }
}

