/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.importexport.validation;

import java.io.Serializable;

public interface ValidationResult {
    public boolean isSuccessful();

    public ValidationResult merge(ValidationResult var1);

    public static class FailedValidationResult
    implements ValidationResult,
    Serializable {
        private final Exception exception;

        public FailedValidationResult(Exception exception) {
            this.exception = exception;
        }

        @Override
        public boolean isSuccessful() {
            return false;
        }

        @Override
        public ValidationResult merge(ValidationResult toBeMergedWith) {
            return toBeMergedWith;
        }

        public String toString() {
            String localizedMessage = this.exception.getLocalizedMessage();
            Throwable cause = this.exception.getCause();
            return "Validation failed because of a " + this.exception.getClass().getSimpleName() + (localizedMessage == null ? " " : " with message '" + localizedMessage + "'") + (cause == null ? "" : " caused by '" + cause.getLocalizedMessage() + "'");
        }
    }
}

