/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.logging;

import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import org.jahia.services.content.DefaultEventListener;
import org.jahia.services.content.JCREventIterator;
import org.jahia.services.logging.MetricsLoggingService;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsLoggingJCReventListener
extends DefaultEventListener {
    private static transient Logger logger = LoggerFactory.getLogger(MetricsLoggingJCReventListener.class);
    private MetricsLoggingService loggingService;
    private List<String> nodeTypesList = null;

    public void setLoggingService(MetricsLoggingService loggingService) {
        this.loggingService = loggingService;
    }

    public void setNodeTypesList(List<String> nodeTypes) {
        if (nodeTypes != null && nodeTypes.size() > 0) {
            this.nodeTypesList = nodeTypes;
        }
    }

    @Override
    public int getEventTypes() {
        return this.loggingService.isEnabled() ? 63 : 0;
    }

    @Override
    public String[] getNodeTypes() {
        return this.nodeTypesList == null ? null : this.nodeTypesList.toArray(new String[this.nodeTypesList.size()]);
    }

    public void onEvent(EventIterator events) {
        if (events instanceof JCREventIterator && ((JCREventIterator)events).getOperationType() == 13) {
            return;
        }
        while (events.hasNext()) {
            try {
                Event event = events.nextEvent();
                switch (event.getType()) {
                    case 1: {
                        this.loggingService.logContentEvent(event.getUserID(), "", "", event.getIdentifier(), event.getPath(), "", "nodeCreated", new JSONObject(event.getInfo()).toString());
                        break;
                    }
                    case 32: {
                        this.loggingService.logContentEvent(event.getUserID(), "", "", event.getIdentifier(), event.getPath(), "", "nodeMoved", new JSONObject(event.getInfo()).toString());
                        break;
                    }
                    case 2: {
                        this.loggingService.logContentEvent(event.getUserID(), "", "", event.getIdentifier(), event.getPath(), "", "nodeDeleted", new JSONObject(event.getInfo()).toString());
                        break;
                    }
                    case 4: {
                        this.loggingService.logContentEvent(event.getUserID(), "", "", event.getIdentifier(), event.getPath(), "", "propertyAdded", new JSONObject(event.getInfo()).toString());
                        break;
                    }
                    case 16: {
                        this.loggingService.logContentEvent(event.getUserID(), "", "", event.getIdentifier(), event.getPath(), "", "propertyChanged", new JSONObject(event.getInfo()).toString());
                        break;
                    }
                    case 8: {
                        this.loggingService.logContentEvent(event.getUserID(), "", "", event.getIdentifier(), event.getPath(), "", "propertyRemoved", new JSONObject(event.getInfo()).toString());
                    }
                }
            }
            catch (RepositoryException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

