/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.logging;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.jahia.services.logging.MetricsLoggingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.profiler.Profiler;
import org.slf4j.profiler.ProfilerRegistry;

public class MetricsLoggingServiceImpl
implements MetricsLoggingService {
    private static transient Logger metricsLogger = LoggerFactory.getLogger((String)"loggingService");
    private static transient Logger profilerMetricsLogger = LoggerFactory.getLogger((String)"profilerLoggingService");
    private Map<String, String> logTemplatesMap;
    private Set<String> ignoreUsers = new HashSet<String>();
    private static MetricsLoggingServiceImpl instance;
    private static final String headerTemplate = "user {} ip {} session {} identifier {} path {} nodetype {} ";
    private ThreadLocal<Stack<Profiler>> threadLocal = new ThreadLocal();

    public void setLogTemplatesMap(Map<String, String> logTemplatesMap) {
        this.logTemplatesMap = new LinkedHashMap<String, String>(logTemplatesMap.size());
        for (Map.Entry<String, String> entry : logTemplatesMap.entrySet()) {
            this.logTemplatesMap.put(entry.getKey(), headerTemplate + entry.getValue());
        }
    }

    public void setIgnoreUsers(Set<String> ignoreUsers) {
        this.ignoreUsers = ignoreUsers;
    }

    @Override
    public void logContentEvent(String user, String ipAddress, String sessionID, String nodeIdentifier, String path, String nodeType, String logTemplate, String ... args) {
        if (!this.isEnabled() || this.ignoreUsers.contains(user)) {
            return;
        }
        String template = this.logTemplatesMap.get(logTemplate);
        Object[] templateParameters = new String[6 + args.length];
        templateParameters[0] = user;
        templateParameters[1] = ipAddress;
        templateParameters[2] = sessionID;
        templateParameters[3] = nodeIdentifier;
        templateParameters[4] = path;
        templateParameters[5] = nodeType;
        int i = 6;
        for (String arg : args) {
            templateParameters[i++] = arg;
        }
        if (template == null) {
            metricsLogger.trace("Couldn't find template for " + logTemplate + " and args " + Arrays.toString(templateParameters));
        } else {
            metricsLogger.trace(template, templateParameters);
        }
    }

    @Override
    public void startProfiler(String profilerName, String action) {
        if (!this.isProfilingEnabled()) {
            return;
        }
        ProfilerRegistry profilerRegistry = ProfilerRegistry.getThreadContextInstance();
        Profiler profiler = profilerRegistry.get(profilerName);
        if (profiler == null) {
            profiler = new Profiler(profilerName);
            profiler.setLogger(profilerMetricsLogger);
            profiler.registerWith(profilerRegistry);
        }
        profiler.start(action);
    }

    @Override
    public void stopProfiler(String profilerName) {
        if (!this.isProfilingEnabled()) {
            return;
        }
        ProfilerRegistry profilerRegistry = ProfilerRegistry.getThreadContextInstance();
        Profiler profiler = profilerRegistry.get(profilerName);
        if (profiler != null) {
            profiler.stop().log();
        }
        profilerRegistry.clear();
        this.threadLocal.set(null);
    }

    @Override
    public Profiler createNestedProfiler(String parentProfilerName, String nestedProfilerName) {
        Stack<Object> profilers;
        if (!this.isProfilingEnabled()) {
            return null;
        }
        if (this.threadLocal.get() == null) {
            profilers = new Stack();
            ProfilerRegistry profilerRegistry = ProfilerRegistry.getThreadContextInstance();
            profilers.push(profilerRegistry.get(parentProfilerName));
            this.threadLocal.set(profilers);
        } else {
            profilers = this.threadLocal.get();
        }
        Profiler profiler = (Profiler)profilers.peek();
        if (profiler == null) {
            profiler = this.startProfiler(parentProfilerName);
            profilers.push(profiler);
        }
        Profiler nestedProfiler = profiler.startNested(nestedProfilerName);
        profilers.push(nestedProfiler);
        return nestedProfiler;
    }

    @Override
    public void stopNestedProfiler(String parentProfilerName, String nestedProfilerName) {
        if (!this.isProfilingEnabled()) {
            return;
        }
        Stack<Profiler> profilers = this.threadLocal.get();
        Profiler profiler = profilers.pop();
        if (profiler.getName().equals(nestedProfilerName)) {
            profiler.stop();
        }
    }

    @Override
    public Profiler startProfiler(String profilerName) {
        if (!this.isProfilingEnabled()) {
            return null;
        }
        ProfilerRegistry profilerRegistry = ProfilerRegistry.getThreadContextInstance();
        Profiler profiler = profilerRegistry.get(profilerName);
        if (profiler == null) {
            profiler = new Profiler(profilerName);
            profiler.setLogger(profilerMetricsLogger);
            profiler.registerWith(profilerRegistry);
        }
        return profiler;
    }

    public static MetricsLoggingServiceImpl getInstance() {
        if (instance == null) {
            instance = new MetricsLoggingServiceImpl();
        }
        return instance;
    }

    @Override
    public boolean isEnabled() {
        return metricsLogger.isTraceEnabled();
    }

    @Override
    public boolean isProfilingEnabled() {
        return profilerMetricsLogger.isDebugEnabled();
    }
}

