/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.mail;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import javax.script.SimpleScriptContext;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.Handler;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jahia.bin.listeners.JahiaContextLoaderListener;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.mail.MailService;
import org.jahia.services.mail.MailSettings;
import org.jahia.services.mail.MailSettingsValidationResult;
import org.jahia.services.templates.JahiaTemplateManagerService;
import org.jahia.utils.Patterns;
import org.jahia.utils.ScriptEngineUtils;
import org.jahia.utils.i18n.ResourceBundles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.io.Resource;

public class MailServiceImpl
extends MailService
implements CamelContextAware,
InitializingBean,
DisposableBean,
ApplicationListener<ApplicationEvent> {
    private static Logger logger = LoggerFactory.getLogger(MailServiceImpl.class);
    private String charset;
    private ProducerTemplate template;
    private ScriptEngineUtils scriptEngineUtils;
    private JahiaTemplateManagerService templateManagerService;
    private CamelContext camelContext;
    private String mailEndpointUri;
    private String sendMailEndpointUri;
    private MailSettings settings;

    public static MailSettingsValidationResult validateSettings(MailSettings cfg, boolean skipIfEmpty) {
        boolean doValidation;
        MailSettingsValidationResult result = MailSettingsValidationResult.SUCCESSFULL;
        boolean bl = doValidation = cfg.getNotificationSeverity() != 0 || cfg.getUri().length() > 0 || cfg.getTo().length() > 0 || cfg.getFrom().length() > 0;
        if (doValidation || !skipIfEmpty) {
            if (cfg.getUri().length() == 0) {
                result = new MailSettingsValidationResult("host", "serverSettings.mailServerSettings.errors.server.mandatory");
            } else if (cfg.getNotificationSeverity() != 0 && cfg.getTo().length() == 0) {
                result = new MailSettingsValidationResult("to", "serverSettings.mailServerSettings.errors.administrator.mandatory");
            } else if (cfg.getFrom().length() == 0) {
                result = new MailSettingsValidationResult("from", "serverSettings.mailServerSettings.errors.from.mandatory");
            } else if (cfg.getNotificationSeverity() != 0 && !MailService.isValidEmailAddress(cfg.getTo(), true)) {
                result = new MailSettingsValidationResult("to", "org.jahia.admin.JahiaDisplayMessage.enterValidEmailAdmin.label");
            } else if (!MailService.isValidEmailAddress(cfg.getFrom(), false)) {
                result = new MailSettingsValidationResult("from", "org.jahia.admin.JahiaDisplayMessage.enterValidEmailFrom.label");
            }
        }
        return result;
    }

    @Override
    public String defaultRecipient() {
        return this.settings.getTo();
    }

    @Override
    public String defaultSender() {
        return this.settings.getFrom();
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public MailSettings getSettings() {
        return this.settings;
    }

    @Handler
    public void handleSend(Exchange exchange) {
        if (!this.isEnabled()) {
            logger.warn("Mail service is not enabled. Skip sending message.");
            return;
        }
        if (this.charset != null && exchange.getProperty("CamelCharsetName") == null) {
            exchange.setProperty("CamelCharsetName", (Object)this.charset);
        }
        if (exchange.getIn().getHeader("From") != null && exchange.getIn().getHeader("To") == null) {
            exchange.getIn().setHeader("To", (Object)this.settings.getTo());
        }
        long timer = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug("Sending message: " + exchange);
        }
        try {
            this.template.send(this.getEndpointUri(), exchange);
        }
        catch (RuntimeException e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
        logger.info("Mail message sent in " + (System.currentTimeMillis() - timer) + " ms");
    }

    public String getEndpointUri() {
        if (this.sendMailEndpointUri == null) {
            StringBuilder uri = new StringBuilder();
            if (!this.settings.getUri().startsWith("smtp://") && !this.settings.getUri().startsWith("smtps://")) {
                uri.append("smtp://");
            }
            uri.append(this.settings.getUri());
            if (StringUtils.isNotEmpty((String)this.settings.getFrom())) {
                uri.append(uri.indexOf("?") != -1 ? "&" : "?").append("from=").append(this.settings.getFrom());
            }
            if (StringUtils.isNotEmpty((String)this.settings.getTo())) {
                uri.append(uri.indexOf("?") != -1 ? "&" : "?").append("to=").append(this.settings.getTo());
            }
            this.sendMailEndpointUri = uri.toString();
            logger.debug("Using mail endpoint: {}", (Object)this.sendMailEndpointUri);
        }
        return this.sendMailEndpointUri;
    }

    @Override
    public boolean sendHtmlMessage(String from, String to, String cc, String bcc, String subject, String message) {
        if (this.isEnabled()) {
            this.sendMessage(from, to, cc, bcc, subject, null, message);
            return true;
        }
        return false;
    }

    @Override
    public boolean sendMessage(String message) {
        return this.sendMessage(this.settings.getFrom(), this.settings.getTo(), null, null, null, message);
    }

    @Override
    public boolean sendMessage(String to, String message) {
        return this.sendMessage(this.settings.getFrom(), to, null, null, null, message);
    }

    @Override
    public boolean sendMessage(String from, String to, String message) {
        return this.sendMessage(from, to, null, null, null, message);
    }

    @Override
    public boolean sendMessage(String from, String to, String cc, String bcc, String subject, String message) {
        if (this.isEnabled()) {
            this.sendMessage(from, to, cc, bcc, subject, message, null);
            return true;
        }
        return false;
    }

    @Override
    public void sendMessage(String from, String toList, String ccList, String bcclist, String subject, String textBody, String htmlBody) {
        this.sendMessage(this.mailEndpointUri, from, toList, ccList, bcclist, subject, textBody, htmlBody);
    }

    public void sendMessage(String endpointUri, String from, String toList, String ccList, String bcclist, String subject, String textBody, String htmlBody) {
        String body;
        final HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("To", toList);
        if (StringUtils.isEmpty((String)from)) {
            headers.put("From", this.settings.getFrom());
        } else {
            headers.put("From", from);
        }
        if (StringUtils.isNotEmpty((String)ccList)) {
            headers.put("Cc", ccList);
        }
        if (StringUtils.isNotEmpty((String)bcclist)) {
            headers.put("Bcc", bcclist);
        }
        headers.put("Subject", subject);
        if (StringUtils.isNotEmpty((String)htmlBody)) {
            headers.put("contentType", this.charset != null ? "text/html; charset=" + this.charset : "text/html");
            headers.put("alternativeBodyHeader", textBody);
            body = htmlBody;
        } else {
            headers.put("contentType", this.charset != null ? "text/plain; charset=" + this.charset : "text/plain");
            body = textBody;
        }
        this.template.send(endpointUri, new Processor(){

            public void process(Exchange exchange) throws Exception {
                if (MailServiceImpl.this.charset != null) {
                    exchange.setProperty("CamelCharsetName", (Object)MailServiceImpl.this.charset);
                }
                Message in = exchange.getIn();
                for (Map.Entry header : headers.entrySet()) {
                    in.setHeader((String)header.getKey(), header.getValue());
                }
                in.setBody((Object)body);
            }
        });
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
        this.template = camelContext.createProducerTemplate();
    }

    public void setMailEndpointUri(String mailEndpointUri) {
        this.mailEndpointUri = mailEndpointUri;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        logger.info("Mail Service successfully stopped");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMessageWithTemplate(String template, Map<String, Object> boundObjects, String toMail, String fromMail, String ccList, String bcclist, Locale locale, String templatePackageName) throws RepositoryException, ScriptException {
        block12: {
            String subject;
            ResourceBundle resourceBundle;
            ScriptEngine scriptEngine = this.scriptEngineUtils.scriptEngine(StringUtils.substringAfterLast((String)template, (String)"."));
            SimpleScriptContext scriptContext = new SimpleScriptContext();
            String suffix = StringUtils.substringAfterLast((String)template, (String)".");
            String languageMailConfTemplate = template.substring(0, template.length() - (suffix.length() + 1)) + "_" + locale.toString() + "." + suffix;
            JahiaTemplatesPackage templatePackage = this.templateManagerService.getTemplatePackage(templatePackageName);
            Resource templateRealPath = templatePackage.getResource(languageMailConfTemplate);
            if (templateRealPath == null) {
                templateRealPath = templatePackage.getResource(template);
            }
            InputStream scriptInputStream = null;
            try {
                scriptInputStream = templateRealPath.getInputStream();
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            if (scriptInputStream == null) break block12;
            if (templatePackageName == null) {
                String resourceBundleName = StringUtils.substringBeforeLast((String)Patterns.SLASH.matcher(StringUtils.substringAfter((String)Patterns.WEB_INF.matcher(template).replaceAll(""), (String)"/")).replaceAll("."), (String)".");
                resourceBundle = ResourceBundles.get(resourceBundleName, locale);
            } else {
                resourceBundle = ResourceBundles.get(ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackage(templatePackageName), locale);
            }
            SimpleBindings bindings = new SimpleBindings();
            bindings.put("bundle", (Object)resourceBundle);
            bindings.putAll((Map<? extends String, ? extends Object>)boundObjects);
            InputStreamReader scriptContent = null;
            try {
                String subjectTemplatePath = StringUtils.substringBeforeLast((String)templateRealPath.getURI().getPath(), (String)".") + ".subject." + StringUtils.substringAfterLast((String)templateRealPath.getFilename(), (String)".");
                InputStream stream = templatePackage.getResource(subjectTemplatePath).getInputStream();
                scriptContent = new InputStreamReader(stream);
                scriptContext.setBindings(bindings, 100);
                scriptContext.setBindings(scriptEngine.getContext().getBindings(200), 200);
                scriptContext.setWriter(new StringWriter());
                scriptEngine.eval((Reader)scriptContent, (ScriptContext)scriptContext);
                subject = scriptContext.getWriter().toString().trim();
            }
            catch (Exception e) {
                try {
                    logger.warn("Exception while rendering mail subject using " + StringUtils.substringBeforeLast((String)templateRealPath.getFilename(), (String)".") + ".subject." + StringUtils.substringAfterLast((String)templateRealPath.getFilename(), (String)"."), (Throwable)e);
                    subject = resourceBundle.getString(StringUtils.substringBeforeLast((String)StringUtils.substringAfterLast((String)template, (String)"/"), (String)".") + ".subject");
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(scriptContent);
                    throw throwable;
                }
                IOUtils.closeQuietly((Reader)scriptContent);
            }
            IOUtils.closeQuietly((Reader)scriptContent);
            try {
                scriptContent = new InputStreamReader(scriptInputStream);
                scriptContext.setWriter(new StringWriter());
                scriptContext.setErrorWriter(new StringWriter());
                bindings.put("out", (Object)new PrintWriter(scriptContext.getWriter()));
                scriptContext.setBindings(bindings, 100);
                scriptEngine.eval((Reader)scriptContent, (ScriptContext)scriptContext);
                StringWriter writer = (StringWriter)scriptContext.getWriter();
                String body = writer.toString();
                this.sendMessage(fromMail, toMail, ccList, bcclist, subject, null, body);
            }
            finally {
                IOUtils.closeQuietly((Reader)scriptContent);
            }
        }
        logger.warn("Cannot send mail, template [" + template + "] from module [" + templatePackageName + "] not found");
    }

    public void destroy() throws Exception {
        if (this.template != null) {
            this.template.stop();
        }
    }

    public void setScriptEngineUtils(ScriptEngineUtils scriptEngineUtils) {
        this.scriptEngineUtils = scriptEngineUtils;
    }

    protected void load() {
        this.sendMailEndpointUri = null;
        this.settings = new MailSettings();
        try {
            this.settings = JCRTemplate.getInstance().doExecuteWithSystemSession(null, "default", new JCRCallback<MailSettings>(){

                @Override
                public MailSettings doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    MailSettings cfg = new MailSettings();
                    JCRNodeWrapper mailNode = null;
                    try {
                        mailNode = session.getNode("/settings/mail-server");
                        cfg.setServiceActivated(mailNode.hasProperty("j:activated") && mailNode.getProperty("j:activated").getBoolean());
                        cfg.setUri(mailNode.hasProperty("j:uri") ? mailNode.getProperty("j:uri").getString() : null);
                        cfg.setFrom(mailNode.hasProperty("j:from") ? mailNode.getProperty("j:from").getString() : null);
                        cfg.setTo(mailNode.hasProperty("j:to") ? mailNode.getProperty("j:to").getString() : null);
                        cfg.setNotificationLevel(mailNode.hasProperty("j:notificationLevel") ? mailNode.getProperty("j:notificationLevel").getString() : "Disabled");
                    }
                    catch (PathNotFoundException e) {
                        MailServiceImpl.this.store(cfg, session);
                    }
                    return cfg;
                }
            });
        }
        catch (RepositoryException e) {
            logger.error("Error reading mail server settings from the repository. Mail server will be disabled.", (Throwable)e);
        }
        if (this.settings.isServiceActivated()) {
            MailSettingsValidationResult result = MailServiceImpl.validateSettings(this.settings, false);
            if (result.isSuccess()) {
                this.settings.setConfigurationValid(true);
                logger.info("Mail Service is using following settings: host=[" + this.settings.getSmtpHost() + "] to=[" + this.settings.getTo() + "] from=[" + this.settings.getFrom() + "] notificationLevel=[" + this.settings.getNotificationLevel() + "]");
            } else {
                this.settings.setConfigurationValid(false);
                logger.info("Mail settings are not set or invalid. Mail Service will be disabled");
            }
        } else {
            logger.info("Mail Service is disabled.");
        }
    }

    @Override
    public void store(final MailSettings cfg) {
        try {
            JCRTemplate.getInstance().doExecuteWithSystemSession(new JCRCallback<Boolean>(){

                @Override
                public Boolean doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    MailServiceImpl.this.store(cfg, session);
                    return Boolean.TRUE;
                }
            });
            this.load();
        }
        catch (RepositoryException e) {
            logger.error("Error storing mail server settings into the repository.", (Throwable)e);
        }
    }

    protected void store(MailSettings cfg, JCRSessionWrapper session) throws RepositoryException {
        JCRNodeWrapper mailNode = null;
        try {
            mailNode = session.getNode("/settings/mail-server");
        }
        catch (PathNotFoundException e) {
            mailNode = session.nodeExists("/settings") ? session.getNode("/settings").addNode("mail-server", "jnt:mailServerSettings") : session.getNode("/").addNode("settings", "jnt:globalSettings").addNode("mail-server", "jnt:mailServerSettings");
        }
        mailNode.setProperty("j:activated", cfg.isServiceActivated());
        mailNode.setProperty("j:uri", cfg.getUri());
        mailNode.setProperty("j:from", cfg.getFrom());
        mailNode.setProperty("j:to", cfg.getTo());
        mailNode.setProperty("j:notificationLevel", cfg.getNotificationLevel());
        session.save();
    }

    public void onApplicationEvent(ApplicationEvent evt) {
        if (evt instanceof JahiaContextLoaderListener.RootContextInitializedEvent || evt instanceof MailSettingsChangedEvent) {
            this.sendMailEndpointUri = null;
            this.load();
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (this.charset == null) {
            this.charset = this.settingsBean.getCharacterEncoding();
        } else if (this.charset.length() == 0) {
            this.charset = null;
        }
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setTemplateManagerService(JahiaTemplateManagerService templateManagerService) {
        this.templateManagerService = templateManagerService;
    }

    public static class MailSettingsChangedEvent
    extends ApplicationEvent {
        private static final long serialVersionUID = 3762898577271668634L;

        public MailSettingsChangedEvent(Object source) {
            super(source);
        }
    }
}

