/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.notification;

import au.com.bytecode.opencsv.CSVReader;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.jcr.ItemNotFoundException;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RangeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Query;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.QueryManagerWrapper;
import org.jahia.services.notification.Subscription;
import org.jahia.services.query.QueryWrapper;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.utils.PaginatedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionService {
    private static final String J_ALLOW_UNREGISTERED_USERS = "j:allowUnregisteredUsers";
    public static final String J_CONFIRMATION_KEY = "j:confirmationKey";
    public static final String J_CONFIRMED = "j:confirmed";
    private static final String J_EMAIL = "j:email";
    private static final String J_FIRST_NAME = "j:firstName";
    private static final String J_LAST_NAME = "j:lastName";
    private static final String J_PROVIDER = "j:provider";
    private static final String J_SUBSCRIBER = "j:subscriber";
    private static final String J_SUBSCRIPTIONS = "j:subscriptions";
    private static final String J_SUSPENDED = "j:suspended";
    private static final String JMIX_SUBSCRIBABLE = "jmix:subscribable";
    private static final String JNT_SUBSCRIPTION = "jnt:subscription";
    private static final Logger logger = LoggerFactory.getLogger(SubscriptionService.class);
    private JahiaUserManagerService userManagerService;

    public void cancel(List<String> subscriptionIds, JCRSessionWrapper session) {
        try {
            int count = 0;
            for (String id : subscriptionIds) {
                try {
                    JCRNodeWrapper target = session.getNodeByIdentifier(id);
                    ++count;
                    session.checkout(target.getParent());
                    target.remove();
                }
                catch (ItemNotFoundException e) {
                    logger.warn("Unable to find subscription node for identifier {}. Skip cancelling subscription.", (Object)id);
                }
            }
            if (count > 0) {
                session.save();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Successfully cancelled {} subscriptions.", (Object)count);
            }
        }
        catch (RepositoryException e) {
            logger.error("Error cancelling subscriptions " + subscriptionIds, (Throwable)e);
        }
    }

    public void cancel(String subscriptionId, JCRSessionWrapper session) {
        LinkedList<String> ids = new LinkedList<String>();
        ids.add(subscriptionId);
        this.cancel(ids, session);
    }

    private void changeSuspendedStatus(List<String> subscriptionIds, boolean doSuspend, JCRSessionWrapper session) {
        try {
            int count = 0;
            for (String subscriptionId : subscriptionIds) {
                try {
                    JCRNodeWrapper subscriptionNode = session.getNodeByIdentifier(subscriptionId);
                    JCRPropertyWrapper property = subscriptionNode.getProperty(J_SUSPENDED);
                    if (doSuspend && !property.getBoolean() || !doSuspend && property.getBoolean()) {
                        ++count;
                        session.checkout(subscriptionNode);
                        subscriptionNode.setProperty(J_SUSPENDED, doSuspend);
                    }
                }
                catch (ItemNotFoundException nfe) {
                    logger.warn("Unable to find subscription node for identifier {}", (Object)subscriptionId);
                }
                catch (RepositoryException e) {
                    logger.error("Error changing suspended status of the subscription with ID " + subscriptionId, (Throwable)e);
                }
                if (count <= 0) continue;
                session.save();
            }
        }
        catch (RepositoryException e) {
            logger.error("Error changing suspended status of subscriptions " + subscriptionIds, (Throwable)e);
        }
    }

    public PaginatedList<Subscription> getSubscriptions(String subscribableIdentifier, String orderBy, boolean orderAscending, int offset, int limit, JCRSessionWrapper session) {
        return this.getSubscriptions(subscribableIdentifier, false, false, orderBy, orderAscending, offset, limit, session);
    }

    public PaginatedList<Subscription> getSubscriptions(String subscribableIdentifier, boolean activeOnly, boolean confirmedOnly, String orderBy, boolean orderAscending, int offset, int limit, JCRSessionWrapper session) {
        long timer = System.currentTimeMillis();
        int total = 0;
        LinkedList<Subscription> subscriptions = new LinkedList<Subscription>();
        try {
            JCRNodeWrapper target = session.getNodeByIdentifier(subscribableIdentifier);
            if (!target.isNodeType(JMIX_SUBSCRIBABLE)) {
                logger.warn("The target node {} does not have the jmix:subscribable mixin. No subscriptions can be found.", (Object)target.getPath());
                return new PaginatedList<Subscription>(subscriptions, 0);
            }
            QueryManagerWrapper queryManager = session.getWorkspace().getQueryManager();
            if (queryManager == null) {
                logger.error("Unable to obtain QueryManager instance");
                return new PaginatedList<Subscription>(subscriptions, 0);
            }
            StringBuilder q = new StringBuilder();
            q.append("select * from [jnt:subscription] where isdescendantnode([").append(target.getPath()).append("/j:subscriptions])");
            if (activeOnly) {
                q.append(" and [j:suspended]=false");
            }
            if (confirmedOnly) {
                q.append(" and [j:confirmed]=true");
            }
            if (orderBy != null) {
                q.append(" order by [").append(orderBy).append("]").append(orderAscending ? "asc" : "desc");
            }
            Query query = queryManager.createQuery(q.toString(), "JCR-SQL2");
            if (limit > 0 || offset > 0) {
                total = (int)JCRContentUtils.size((RangeIterator)query.execute().getNodes());
            }
            query.setLimit((long)limit);
            query.setOffset((long)offset);
            NodeIterator nodes = query.execute().getNodes();
            while (nodes.hasNext()) {
                JCRNodeWrapper subscriptionNode = (JCRNodeWrapper)nodes.next();
                subscriptions.add(this.toSubscription(subscriptionNode, session));
            }
        }
        catch (RepositoryException e) {
            logger.error("Error retrieving subscriptions for node " + subscribableIdentifier, (Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            logger.info("Subscriber search took " + (System.currentTimeMillis() - timer) + " ms. Returning " + subscriptions.size() + " subscriber(s)");
        }
        return new PaginatedList<Subscription>(subscriptions, limit > 0 || offset > 0 ? total : subscriptions.size());
    }

    public String getSubscription(String subscribableIdentifier, String user, JCRSessionWrapper session) {
        try {
            JCRNodeWrapper target = session.getNodeByIdentifier(subscribableIdentifier);
            if (!target.isNodeType(JMIX_SUBSCRIBABLE)) {
                logger.warn("The target node {} does not have the jmix:subscribable mixin. No subscriptions can be found.", (Object)target.getPath());
                return null;
            }
            JCRNodeWrapper sub = this.getSubscription(target, user, session);
            if (sub != null) {
                return sub.getIdentifier();
            }
            return null;
        }
        catch (RepositoryException e) {
            logger.error("Error checking subscription status for user '" + user + "' and node " + subscribableIdentifier, (Throwable)e);
            return null;
        }
    }

    public JCRNodeWrapper getSubscription(JCRNodeWrapper target, String user, JCRSessionWrapper session) throws InvalidQueryException, RepositoryException {
        QueryManagerWrapper queryManager = session.getWorkspace().getQueryManager();
        if (queryManager == null) {
            logger.error("Unable to obtain QueryManager instance");
            return null;
        }
        String subscriber = user;
        String provider = null;
        if (user.charAt(0) == '{') {
            subscriber = StringUtils.substringAfter((String)user, (String)"}");
            provider = StringUtils.substringBetween((String)user, (String)"{", (String)"}");
        }
        StringBuilder q = new StringBuilder(64);
        q.append("select * from [jnt:subscription] where [j:subscriber]='").append(subscriber).append("'");
        if (provider != null) {
            q.append(" and [j:provider]='").append(provider).append("'");
        }
        q.append(" and").append(" isdescendantnode([").append(target.getPath()).append("])");
        Query query = queryManager.createQuery(q.toString(), "JCR-SQL2");
        query.setLimit(1L);
        NodeIterator nodeIterator = query.execute().getNodes();
        if (nodeIterator.hasNext()) {
            return (JCRNodeWrapper)nodeIterator.nextNode();
        }
        return null;
    }

    public void resume(List<String> subscriptionIds, JCRSessionWrapper session) {
        this.changeSuspendedStatus(subscriptionIds, false, session);
    }

    public void resume(String subscriptionId, JCRSessionWrapper session) {
        LinkedList<String> subscriptions = new LinkedList<String>();
        subscriptions.add(subscriptionId);
        this.changeSuspendedStatus(subscriptions, false, session);
    }

    public String generateConfirmationKey(JCRNodeWrapper subscription) {
        try {
            return DigestUtils.md5Hex((String)(subscription.getIdentifier() + System.currentTimeMillis()));
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public JCRNodeWrapper getSubscriptionFromKey(String key, JCRSessionWrapper session) {
        try {
            QueryWrapper q = session.getWorkspace().getQueryManager().createQuery("select * from [jnt:subscription] where [j:confirmationKey]='" + key + "'", "JCR-SQL2");
            NodeIterator ni = q.execute().getNodes();
            if (ni.hasNext()) {
                return (JCRNodeWrapper)ni.nextNode();
            }
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public void setUserManagerService(JahiaUserManagerService userManagerService) {
        this.userManagerService = userManagerService;
    }

    protected void storeProperties(JCRNodeWrapper newSubscriptionNode, Map<String, Object> properties, JCRSessionWrapper session) {
        if (properties == null || properties.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Object> property : properties.entrySet()) {
            if (!property.getValue().getClass().isArray()) {
                try {
                    newSubscriptionNode.setProperty(property.getKey(), JCRContentUtils.createValue(property.getValue(), session.getValueFactory()));
                }
                catch (RepositoryException e) {
                    logger.warn("Unable to set property " + property.getKey(), (Throwable)e);
                }
                continue;
            }
            logger.warn("Cannot handle nultivalue properties. Skipping property {}", (Object)property.getKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void importSubscriptions(String subscribableIdentifier, File subscribersCSVFile, JCRSessionWrapper session) {
        int emailPosition;
        int usernamePosition;
        Object[] columns;
        char separator;
        CSVReader reader;
        BufferedInputStream is;
        int importedCount;
        long timer;
        block35: {
            block36: {
                block33: {
                    block34: {
                        timer = System.currentTimeMillis();
                        if (logger.isDebugEnabled()) {
                            logger.debug("Start importing subscriptions for source node {}", (Object)subscribableIdentifier);
                        }
                        importedCount = 0;
                        is = null;
                        reader = null;
                        is = new BufferedInputStream(new FileInputStream(subscribersCSVFile));
                        separator = ',';
                        reader = new CSVReader((Reader)new InputStreamReader((InputStream)is, "UTF-8"), separator);
                        columns = reader.readNext();
                        if (columns != null) break block33;
                        logger.warn("No data for importing subscriptions is found or the file is not well-formed");
                        if (reader == null) break block34;
                        try {
                            reader.close();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    IOUtils.closeQuietly((InputStream)is);
                    return;
                }
                if (columns.length == 1 && columns[0].contains(";")) {
                    reader.close();
                    IOUtils.closeQuietly((InputStream)is);
                    is = new BufferedInputStream(new FileInputStream(subscribersCSVFile));
                    separator = ';';
                    reader = new CSVReader((Reader)new InputStreamReader((InputStream)is, "UTF-8"), separator);
                    columns = reader.readNext();
                }
                usernamePosition = ArrayUtils.indexOf((Object[])columns, (Object)"j:nodename");
                emailPosition = ArrayUtils.indexOf((Object[])columns, (Object)J_EMAIL);
                if (usernamePosition != -1 || emailPosition != -1) break block35;
                logger.warn("No data for importing subscriptions is found or the file is not well-formed");
                if (reader == null) break block36;
                try {
                    reader.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            IOUtils.closeQuietly((InputStream)is);
            return;
        }
        try {
            HashMap hashMap = new HashMap();
            while (true) {
                void var13_18;
                HashMap<Object, Object> props;
                boolean registered;
                String username;
                Object[] nextLine;
                if ((nextLine = reader.readNext()) != null) {
                    block37: {
                        username = usernamePosition != -1 ? nextLine[usernamePosition] : null;
                        String email = emailPosition != -1 ? nextLine[emailPosition] : null;
                        registered = true;
                        if (StringUtils.isNotEmpty((String)username)) {
                            JahiaUser user;
                            JahiaUser jahiaUser = user = username.charAt(0) == '{' ? this.userManagerService.lookupUserByKey(username) : this.userManagerService.lookupUser(username);
                            if (user != null) {
                                if (username.charAt(0) != '{') {
                                    username = "{" + user.getProviderName() + "}" + username;
                                }
                                break block37;
                            } else {
                                logger.warn("No user can be found for the specified username '" + username + "'. Skipping subscription: " + StringUtils.join((Object[])nextLine, (char)separator));
                                continue;
                            }
                        }
                        if (StringUtils.isNotEmpty((String)email)) {
                            username = email;
                            registered = false;
                        } else {
                            logger.warn("Neither a j:nodename nor j:email is provided.Skipping subscription: " + StringUtils.join((Object[])nextLine, (char)separator));
                            continue;
                        }
                    }
                    props = new HashMap<Object, Object>(columns.length);
                } else {
                    if (!var13_18.isEmpty()) {
                        importedCount += var13_18.size();
                        this.subscribe(subscribableIdentifier, (Map<String, Map<String, Object>>)var13_18, session);
                    }
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    IOUtils.closeQuietly((InputStream)is);
                    break;
                }
                for (int i = 0; i < columns.length; ++i) {
                    Object column = columns[i];
                    if ("j:nodename".equals(column) || !registered && J_EMAIL.equals(column)) continue;
                    props.put(column, nextLine[i]);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Subscribing '" + username + "' with properties: " + props);
                }
                var13_18.put(username, props);
                if (var13_18.size() <= 1000) continue;
                this.subscribe(subscribableIdentifier, (Map<String, Map<String, Object>>)var13_18, session);
                importedCount += var13_18.size();
                HashMap hashMap2 = new HashMap();
            }
        }
        catch (Exception e) {
            block39: {
                try {
                    logger.error(e.getMessage(), (Throwable)e);
                    if (reader == null) break block39;
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Exception e2) {
                            // empty catch block
                        }
                    }
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
                try {
                    reader.close();
                }
                catch (Exception e3) {
                    // empty catch block
                }
            }
            IOUtils.closeQuietly((InputStream)is);
        }
        if (logger.isInfoEnabled()) {
            logger.info("Importing {} subscriptions for source node {} took {} ms", new Object[]{importedCount, subscribableIdentifier, System.currentTimeMillis() - timer});
        }
    }

    public JCRNodeWrapper subscribe(String subscribableIdentifier, List<String> userKeys, JCRSessionWrapper session) {
        HashMap<String, Map<String, Object>> subscribers = new HashMap<String, Map<String, Object>>(userKeys.size());
        for (String user : userKeys) {
            subscribers.put(user, null);
        }
        return this.subscribe(subscribableIdentifier, subscribers, session);
    }

    public JCRNodeWrapper subscribe(String subscribableIdentifier, Map<String, Map<String, Object>> subscribers, JCRSessionWrapper session) {
        JCRNodeWrapper newSubscriptionNode = null;
        try {
            JCRNodeWrapper target = session.getNodeByIdentifier(subscribableIdentifier);
            if (!target.isNodeType(JMIX_SUBSCRIBABLE)) {
                logger.warn("The target node {} does not have the jmix:subscribable mixin. No subscriptions can be created.", (Object)target.getPath());
                return null;
            }
            JCRNodeWrapper subscriptionsNode = target.getNode(J_SUBSCRIPTIONS);
            String targetPath = subscriptionsNode.getPath();
            if (target.isLocked() || subscriptionsNode.isLocked()) {
                logger.info("The target {} is locked and no subscriptions can be created. Skipping {} subscribers.", (Object)targetPath, (Object)subscribers.size());
            }
            boolean allowUnregisteredUsers = target.hasProperty(J_ALLOW_UNREGISTERED_USERS) ? target.getProperty(J_ALLOW_UNREGISTERED_USERS).getBoolean() : true;
            for (Map.Entry<String, Map<String, Object>> subscriber : subscribers.entrySet()) {
                String username = subscriber.getKey();
                String provider = null;
                if (username.charAt(0) == '{') {
                    username = StringUtils.substringAfter((String)subscriber.getKey(), (String)"}");
                    provider = StringUtils.substringBetween((String)subscriber.getKey(), (String)"{", (String)"}");
                } else if (!allowUnregisteredUsers) {
                    logger.info("The target {} does not allow unregistered users to be subscribed. Skipping subscription for {}.", (Object)targetPath, (Object)subscriber.getKey());
                    continue;
                }
                if (this.getSubscription(target, subscriber.getKey(), session) == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Creating subscription to the {} for {}.", (Object)targetPath, (Object)subscriber.getKey());
                    }
                    session.checkout(subscriptionsNode);
                    newSubscriptionNode = subscriptionsNode.addNode(JCRContentUtils.findAvailableNodeName(subscriptionsNode, "subscription"), JNT_SUBSCRIPTION);
                    newSubscriptionNode.setProperty(J_SUBSCRIBER, username);
                    if (provider != null) {
                        newSubscriptionNode.setProperty(J_PROVIDER, provider);
                    }
                    this.storeProperties(newSubscriptionNode, subscriber.getValue(), session);
                    continue;
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Subscription for the {} and {} is already present. Skipping ceraring new one.", (Object)targetPath, (Object)subscriber.getKey());
            }
            session.save();
        }
        catch (RepositoryException e) {
            logger.error("Error creating subscriptions for node " + subscribableIdentifier, (Throwable)e);
        }
        return newSubscriptionNode;
    }

    public JCRNodeWrapper subscribe(String subscribableIdentifier, String userKey, boolean confirmationNeeded, JCRSessionWrapper session) {
        HashMap<String, Map<String, Object>> subscribers = new HashMap<String, Map<String, Object>>(1);
        HashMap<String, Boolean> props = new HashMap<String, Boolean>(1);
        props.put(J_CONFIRMED, !confirmationNeeded);
        subscribers.put(userKey, props);
        return this.subscribe(subscribableIdentifier, subscribers, session);
    }

    public JCRNodeWrapper subscribe(String subscribableIdentifier, String subscriberEmail, Map<String, Object> properties, JCRSessionWrapper session) {
        HashMap<String, Map<String, Object>> subscribers = new HashMap<String, Map<String, Object>>(1);
        subscribers.put(subscriberEmail, properties);
        return this.subscribe(subscribableIdentifier, subscribers, session);
    }

    public void suspend(List<String> subscriptionIds, JCRSessionWrapper session) {
        this.changeSuspendedStatus(subscriptionIds, true, session);
    }

    public void suspend(String subscriptionId, JCRSessionWrapper session) {
        LinkedList<String> subscriptions = new LinkedList<String>();
        subscriptions.add(subscriptionId);
        this.changeSuspendedStatus(subscriptions, true, session);
    }

    protected Subscription toSubscription(JCRNodeWrapper subscriptionNode, JCRSessionWrapper session) throws ValueFormatException, PathNotFoundException, RepositoryException {
        Subscription subscriber = new Subscription();
        subscriber.setId(subscriptionNode.getIdentifier());
        subscriber.setSubscriber(subscriptionNode.getProperty(J_SUBSCRIBER).getString());
        String provider = null;
        try {
            provider = subscriptionNode.getProperty(J_PROVIDER).getString();
            subscriber.setProvider(provider);
        }
        catch (PathNotFoundException e) {
            // empty catch block
        }
        if (provider != null) {
            String key = "{" + provider + "}" + subscriber.getSubscriber();
            JahiaUser user = this.userManagerService.lookupUserByKey(key);
            if (user != null) {
                subscriber.setFirstName(user.getProperty(J_FIRST_NAME));
                subscriber.setLastName(user.getProperty(J_LAST_NAME));
                subscriber.setEmail(user.getProperty(J_EMAIL));
            } else {
                logger.warn("Unable to find user for key {}", (Object)key);
            }
        } else {
            subscriber.setEmail(subscriber.getSubscriber());
            try {
                subscriber.setFirstName(subscriptionNode.getProperty(J_FIRST_NAME).getString());
            }
            catch (PathNotFoundException e) {
                // empty catch block
            }
            try {
                subscriber.setLastName(subscriptionNode.getProperty(J_LAST_NAME).getString());
            }
            catch (PathNotFoundException e) {
                // empty catch block
            }
        }
        try {
            subscriber.setConfirmationKey(subscriptionNode.getProperty(J_CONFIRMATION_KEY).getString());
        }
        catch (PathNotFoundException e) {
            // empty catch block
        }
        subscriber.setConfirmed(subscriptionNode.getProperty(J_CONFIRMED).getBoolean());
        subscriber.setSuspended(subscriptionNode.getProperty(J_SUSPENDED).getBoolean());
        subscriber.getProperties().putAll(subscriptionNode.getPropertiesAsString());
        return subscriber;
    }
}

