/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.preferences.user;

import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.mail.internet.InternetAddress;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.sites.JahiaSite;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.LanguageCodeConverters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UserPreferencesHelper {
    private static Logger logger = LoggerFactory.getLogger(UserPreferencesHelper.class);

    private UserPreferencesHelper() {
    }

    public static boolean areEmailNotificationsDisabled(JahiaUser user) {
        String emailNotificationsDisabled = user.getProperty("emailNotificationsDisabled");
        return emailNotificationsDisabled != null && "true".equals(emailNotificationsDisabled);
    }

    public static String getEmailAddress(JahiaUser user) {
        String email = user != null ? user.getProperty("j:email") : null;
        return StringUtils.isNotBlank((String)email) ? email : null;
    }

    public static String getFirstName(JahiaUser user) {
        String name = user != null ? user.getProperty("j:firstName") : null;
        return !StringUtils.isBlank((String)name) ? name : null;
    }

    public static String getFullName(JahiaUser user) {
        String name = null;
        if (user != null) {
            String firstName = UserPreferencesHelper.getFirstName(user);
            String lastName = UserPreferencesHelper.getLastName(user);
            if (firstName != null && lastName != null) {
                name = firstName + " " + lastName;
            } else if (firstName != null || lastName != null) {
                name = firstName != null ? firstName : lastName;
            }
        }
        return name != null ? name : user.getUsername();
    }

    public static String getLastName(JahiaUser user) {
        String name = user != null ? user.getProperty("j:lastName") : null;
        return !StringUtils.isBlank((String)name) ? name : null;
    }

    public static String getPersonalizedEmailAddress(JahiaUser user) {
        return UserPreferencesHelper.getPersonalizedEmailAddress(UserPreferencesHelper.getEmailAddress(user), user);
    }

    public static String getPersonalizedEmailAddress(String email, JahiaUser user) {
        if (email == null || email.length() == 0 || email.contains("<")) {
            return email;
        }
        String recipientEmail = email;
        if (user != null) {
            String name = UserPreferencesHelper.getPersonalName(user);
            try {
                recipientEmail = new InternetAddress(recipientEmail, name, SettingsBean.getInstance().getCharacterEncoding()).toString();
            }
            catch (UnsupportedEncodingException e) {
                logger.warn(e.getMessage(), (Throwable)e);
                try {
                    recipientEmail = new InternetAddress(recipientEmail, name).toString();
                }
                catch (UnsupportedEncodingException e2) {
                    // empty catch block
                }
            }
        }
        return recipientEmail;
    }

    public static String getPersonalName(JahiaUser user) {
        String name = null;
        if (user != null) {
            name = UserPreferencesHelper.getFullName(user);
            name = name != null ? name : user.getUsername();
        }
        return name;
    }

    public static Locale getPreferredLocale(JahiaUser user) {
        return UserPreferencesHelper.getPreferredLocale(user, (Locale)null);
    }

    public static Locale getPreferredLocale(JahiaUser user, Locale fallback) {
        String propValue = user != null ? user.getProperty("preferredLanguage") : null;
        Locale locale = propValue != null ? LanguageCodeConverters.languageCodeToLocale(propValue) : null;
        return locale != null ? locale : fallback;
    }

    public static Locale getPreferredLocale(JahiaUser user, JahiaSite site) {
        Locale locale;
        String propValue = user != null ? user.getProperty("preferredLanguage") : null;
        Locale locale2 = locale = propValue != null ? LanguageCodeConverters.languageCodeToLocale(propValue) : null;
        if (null == locale) {
            List<Object> siteLocales = Collections.emptyList();
            if (site != null) {
                siteLocales = site.getLanguagesAsLocales();
            }
            if (siteLocales == null || siteLocales.size() == 0) {
                return JCRSessionFactory.getInstance().getCurrentLocale() != null ? JCRSessionFactory.getInstance().getCurrentLocale() : SettingsBean.getInstance().getDefaultLocale();
            }
            List<Locale> availableBundleLocales = LanguageCodeConverters.getAvailableBundleLocales();
            for (Locale locale3 : siteLocales) {
                Locale languageOnlyLocale;
                if (availableBundleLocales.contains(locale3)) {
                    locale = locale3;
                    break;
                }
                if (!StringUtils.isNotEmpty((String)locale3.getCountry()) || !availableBundleLocales.contains(languageOnlyLocale = new Locale(locale3.getLanguage()))) continue;
                locale = new Locale(locale3.getLanguage());
                break;
            }
            if (null == locale) {
                locale = availableBundleLocales.get(0);
            }
        }
        return locale;
    }
}

