/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.pwdpolicy;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.CompactWriter;
import com.thoughtworks.xstream.io.xml.XppDriver;
import java.io.Writer;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.time.FastDateFormat;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.pwdpolicy.JahiaPasswordPolicy;
import org.jahia.services.pwdpolicy.JahiaPasswordPolicyRule;
import org.jahia.services.pwdpolicy.JahiaPasswordPolicyRuleParam;
import org.jahia.services.pwdpolicy.PasswordHistoryEntry;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.services.usermanager.jcr.JCRUser;

class JahiaPasswordPolicyManager {
    private static final String HISTORY_NODENAME = "passwordHistory";
    private static final FastDateFormat NODENAME_FORMAT = FastDateFormat.getInstance((String)"yyyy-MM-dd-HH-mm-ss");
    private static final String POLICY_NODENAME = "passwordPolicy";
    private static final String POLICY_NODETYPE = "jnt:passwordPolicy";
    private static final String POLICY_PROPERTY = "j:policy";
    private static volatile XStream serializer;

    JahiaPasswordPolicyManager() {
    }

    private static XStream createSerializer() {
        XStream xstream = new XStream((HierarchicalStreamDriver)new XppDriver(){

            public HierarchicalStreamWriter createWriter(Writer out) {
                return new CompactWriter(out, this.getNameCoder());
            }
        });
        xstream.alias("password-policy", JahiaPasswordPolicy.class);
        xstream.alias("rule", JahiaPasswordPolicyRule.class);
        xstream.alias("param", JahiaPasswordPolicyRuleParam.class);
        return xstream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static XStream getSerializer() {
        if (serializer != null) return serializer;
        Class<JahiaPasswordPolicyManager> clazz = JahiaPasswordPolicyManager.class;
        synchronized (JahiaPasswordPolicyManager.class) {
            if (serializer != null) return serializer;
            serializer = JahiaPasswordPolicyManager.createSerializer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return serializer;
        }
    }

    public JahiaPasswordPolicy getDefaultPolicy() throws RepositoryException {
        return JCRTemplate.getInstance().doExecuteWithSystemSession(new JCRCallback<JahiaPasswordPolicy>(){

            @Override
            public JahiaPasswordPolicy doInJCR(JCRSessionWrapper session) throws RepositoryException {
                JahiaPasswordPolicy policy = null;
                try {
                    JCRNodeWrapper policyNode = session.getNode("/passwordPolicy");
                    String serializedPolicy = policyNode.getProperty(JahiaPasswordPolicyManager.POLICY_PROPERTY).getString();
                    if (serializedPolicy != null) {
                        policy = (JahiaPasswordPolicy)JahiaPasswordPolicyManager.getSerializer().fromXML(serializedPolicy);
                    }
                }
                catch (PathNotFoundException pathNotFoundException) {
                    // empty catch block
                }
                return policy;
            }
        });
    }

    public List<PasswordHistoryEntry> getPasswordHistory(final JahiaUser user) throws RepositoryException {
        return JCRTemplate.getInstance().doExecuteWithSystemSession(new JCRCallback<List<PasswordHistoryEntry>>(){

            @Override
            public List<PasswordHistoryEntry> doInJCR(JCRSessionWrapper session) throws RepositoryException {
                List<PasswordHistoryEntry> pwds = Collections.emptyList();
                try {
                    pwds = new LinkedList();
                    JCRNodeIteratorWrapper iterator = ((JCRUser)user).getNode(session).getNode(JahiaPasswordPolicyManager.HISTORY_NODENAME).getNodes();
                    while (iterator.hasNext()) {
                        JCRNodeWrapper historyEntryNode = (JCRNodeWrapper)iterator.next();
                        pwds.add(new PasswordHistoryEntry(historyEntryNode.getPropertyAsString("j:password"), historyEntryNode.getProperty("jcr:created").getDate().getTime()));
                    }
                    Collections.sort(pwds);
                }
                catch (PathNotFoundException e) {
                    pwds = Collections.emptyList();
                }
                return pwds;
            }
        });
    }

    public void storePasswordHistory(final JahiaUser user) throws RepositoryException {
        JCRTemplate.getInstance().doExecuteWithSystemSession(new JCRCallback<Boolean>(){

            @Override
            public Boolean doInJCR(JCRSessionWrapper session) throws RepositoryException {
                JCRNodeWrapper pwdHistory = ((JCRUser)user).getNode(session).getNode(JahiaPasswordPolicyManager.HISTORY_NODENAME);
                session.checkout(pwdHistory);
                JCRNodeWrapper entry = pwdHistory.addNode(JCRContentUtils.findAvailableNodeName(pwdHistory, "pwd-" + NODENAME_FORMAT.format(System.currentTimeMillis())), "jnt:passwordHistoryEntry");
                entry.setProperty("j:password", user.getProperty("j:password"));
                session.save();
                return true;
            }
        });
    }

    public synchronized void update(final JahiaPasswordPolicy policy) throws RepositoryException {
        JCRTemplate.getInstance().doExecuteWithSystemSession(new JCRCallback<Boolean>(){

            @Override
            public Boolean doInJCR(JCRSessionWrapper session) throws RepositoryException {
                JCRNodeWrapper policyNode = null;
                try {
                    policyNode = session.getNode("/passwordPolicy");
                }
                catch (PathNotFoundException e) {
                    JCRNodeWrapper root = session.getRootNode();
                    session.checkout(root);
                    policyNode = root.addNode(JahiaPasswordPolicyManager.POLICY_NODENAME, JahiaPasswordPolicyManager.POLICY_NODETYPE);
                }
                policyNode.setProperty(JahiaPasswordPolicyManager.POLICY_PROPERTY, JahiaPasswordPolicyManager.getSerializer().toXML((Object)policy));
                session.save();
                return Boolean.TRUE;
            }
        });
    }
}

