/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.pwdpolicy;

import com.ibm.icu.text.MessageFormat;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jahia.engines.EngineMessage;
import org.jahia.engines.EngineMessages;
import org.jahia.services.pwdpolicy.JahiaPasswordPolicyRule;
import org.jahia.services.pwdpolicy.JahiaPasswordPolicyRuleParam;
import org.jahia.services.pwdpolicy.PolicyEnforcementResult;
import org.jahia.utils.i18n.Messages;

final class PolicyEnforcementResultConvertor {
    private static final Pattern POLICY_PARAM_PATTERN = Pattern.compile("params\\['(.+)'\\]");

    PolicyEnforcementResultConvertor() {
    }

    static final EngineMessages toEngineMessages(PolicyEnforcementResult evalResult) {
        EngineMessages msgs = new EngineMessages();
        List<JahiaPasswordPolicyRule> rules = evalResult.getViolatedRules();
        for (JahiaPasswordPolicyRule theRule : rules) {
            List<JahiaPasswordPolicyRuleParam> params = theRule.getActionParameters();
            if (params.size() <= 0) continue;
            Map<String, String> paramMap = theRule.getActionParametersValues();
            String msgKey = paramMap.get("message");
            if (msgKey == null) {
                msgKey = params.get(0).getValue();
            }
            LinkedList<String> arguments = new LinkedList<String>();
            for (int i = 0; i < params.size() - 1; ++i) {
                arguments.add(paramMap.get("arg" + i));
            }
            while (arguments.size() > 0 && arguments.get(arguments.size() - 1) == null) {
                arguments.remove(arguments.size() - 1);
            }
            if (arguments.size() > 0) {
                LinkedList<String> argValues = new LinkedList<String>();
                Map<String, String> condParams = theRule.getConditionParametersValues();
                Iterator i$ = arguments.iterator();
                while (i$.hasNext()) {
                    String condParamName;
                    Matcher argMatcher;
                    String argParam;
                    String value = argParam = (String)i$.next();
                    if (argParam != null && (argMatcher = POLICY_PARAM_PATTERN.matcher(argParam)).find() && argMatcher.groupCount() > 0 && condParams.containsKey(condParamName = argMatcher.group(1))) {
                        value = condParams.get(condParamName);
                    }
                    argValues.add(value);
                }
                msgs.add(new EngineMessage(msgKey, argValues.toArray()));
                continue;
            }
            msgs.add(new EngineMessage(msgKey));
        }
        return msgs;
    }

    static final List<String> toText(PolicyEnforcementResult evalResult) {
        LinkedList<String> texts = new LinkedList<String>();
        for (EngineMessage msg : PolicyEnforcementResultConvertor.toEngineMessages(evalResult).getMessages()) {
            texts.add(PolicyEnforcementResultConvertor.getMsg(msg.getKey(), msg.getValues()));
        }
        return texts;
    }

    private static String getMsg(String key, Object[] args) {
        String msg = Messages.getInternal(key, Locale.ENGLISH);
        if (args != null && args.length > 0 && msg != null && msg.contains("{0}")) {
            msg = MessageFormat.format((String)msg, (Object[])args);
        }
        return msg;
    }
}

