/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.query;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RangeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.map.LazyMap;
import org.apache.jackrabbit.commons.iterator.NodeIteratorAdapter;
import org.apache.jackrabbit.commons.iterator.RangeIteratorAdapter;
import org.apache.jackrabbit.commons.iterator.RowIteratorAdapter;
import org.apache.jackrabbit.core.query.FacetedQueryResult;
import org.apache.jackrabbit.core.query.JahiaSimpleQueryResult;
import org.apache.jackrabbit.value.StringValue;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.RangeFacet;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRStoreProvider;
import org.jahia.services.content.NodeIteratorWrapper;
import org.jahia.utils.LanguageCodeConverters;

public class QueryResultAdapter
implements QueryResult {
    private JCRStoreProvider provider;
    private QueryResult result;
    private JCRSessionWrapper session;
    private String sessionLanguage;

    public QueryResultAdapter(QueryResult result, JCRStoreProvider provider, JCRSessionWrapper session) {
        this.result = result;
        this.provider = provider;
        this.session = session;
        this.sessionLanguage = session.getLocale() != null ? session.getLocale().toString() : null;
    }

    public JCRStoreProvider getProvider() {
        return this.provider;
    }

    public String[] getColumnNames() throws RepositoryException {
        return this.result.getColumnNames();
    }

    public RowIterator getRows() throws RepositoryException {
        RowIterator rowIterator = this.result.getRows();
        return new RowIteratorAdapter((RangeIterator)new RangeIteratorAdapter((Iterator)rowIterator, rowIterator.getSize())){

            public Row next() {
                return new RowDecorator((Row)super.next());
            }
        };
    }

    public JCRNodeIteratorWrapper getNodes() throws RepositoryException {
        Object ni = this.result.getSelectorNames().length <= 1 ? this.result.getNodes() : new NodeIteratorAdapter((RangeIterator)this.result.getRows()){

            public Object next() {
                Row row = (Row)super.next();
                try {
                    return row.getNode(QueryResultAdapter.this.result.getSelectorNames()[0]);
                }
                catch (RepositoryException e) {
                    throw new UnsupportedOperationException("Unable to access the node in " + row, e);
                }
            }
        };
        return new NodeIteratorWrapper((NodeIterator)ni, this.session, this.provider);
    }

    public List<FacetField> getFacetFields() {
        return this.result instanceof FacetedQueryResult ? ((FacetedQueryResult)this.result).getFacetFields() : null;
    }

    public List<FacetField> getFacetDates() {
        return this.result instanceof FacetedQueryResult ? ((FacetedQueryResult)this.result).getFacetDates() : null;
    }

    public List<RangeFacet> getRangeFacets() {
        return this.result instanceof FacetedQueryResult ? ((FacetedQueryResult)this.result).getRangeFacets() : null;
    }

    public FacetField getFacetField(String name) {
        return this.result instanceof FacetedQueryResult ? ((FacetedQueryResult)this.result).getFacetField(name) : null;
    }

    public FacetField getFacetDate(String name) {
        return this.result instanceof FacetedQueryResult ? ((FacetedQueryResult)this.result).getFacetDate(name) : null;
    }

    public RangeFacet getRangeFacet(String name) {
        return this.result instanceof FacetedQueryResult ? ((FacetedQueryResult)this.result).getRangeFacet(name) : null;
    }

    public Map<String, Long> getFacetQuery() {
        return this.result instanceof FacetedQueryResult ? ((FacetedQueryResult)this.result).getFacetQuery() : null;
    }

    public List<FacetField> getLimitingFacets() {
        return this.result instanceof FacetedQueryResult ? ((FacetedQueryResult)this.result).getLimitingFacets() : null;
    }

    public String[] getSelectorNames() throws RepositoryException {
        return this.result.getSelectorNames();
    }

    JCRSessionWrapper getSession() {
        return this.session;
    }

    private String getSessionLanguage() {
        return this.sessionLanguage;
    }

    public long getApproxCount() {
        return this.result instanceof JahiaSimpleQueryResult ? ((JahiaSimpleQueryResult)this.result).getApproxCount() : 0L;
    }

    public class RowDecorator
    implements Row {
        private JCRNodeWrapper node;
        private Map<String, JCRNodeWrapper> nodesBySelector;
        private Row row;

        RowDecorator(Row decoratedRow) {
            this.row = decoratedRow;
        }

        public JCRNodeWrapper getNode() throws RepositoryException {
            if (this.node == null) {
                this.node = this.wrap(this.row.getNode());
            }
            return this.node;
        }

        public JCRNodeWrapper getNode(String selectorName) throws RepositoryException {
            return this.getNodes().get(selectorName);
        }

        public Map<String, JCRNodeWrapper> getNodes() throws RepositoryException {
            if (this.nodesBySelector == null) {
                this.nodesBySelector = LazyMap.decorate(new HashMap(), (Transformer)new Transformer(){

                    public Object transform(Object selector) {
                        try {
                            return RowDecorator.this.wrap(RowDecorator.this.row.getNode((String)selector));
                        }
                        catch (RepositoryException e) {
                            throw new UnsupportedOperationException(e);
                        }
                    }
                });
            }
            return this.nodesBySelector;
        }

        private String getDerivedPath(String originalPath) throws RepositoryException {
            String path = originalPath.replaceFirst(QueryResultAdapter.this.getProvider().getRelativeRoot(), "");
            String mountPoint = QueryResultAdapter.this.getProvider().getMountPoint();
            return mountPoint.equals("/") ? path : mountPoint + path;
        }

        public String getPath() throws RepositoryException {
            return this.getDerivedPath(this.row.getPath());
        }

        public String getPath(String selectorName) throws RepositoryException {
            return this.getDerivedPath(this.row.getPath(selectorName));
        }

        public double getScore() throws RepositoryException {
            return this.row.getScore();
        }

        public double getScore(String selectorName) throws RepositoryException {
            return this.row.getScore(selectorName);
        }

        public Value getValue(String columnName) throws RepositoryException {
            if (columnName.equals("jcr:path")) {
                return new StringValue(this.getPath());
            }
            Value valueResult = this.row.getValue(columnName);
            if (valueResult == null && QueryResultAdapter.this.session.getLocale() != null) {
                JCRPropertyWrapper property = null;
                if (!(columnName.startsWith("rep:spellcheck(") || columnName.startsWith("rep:excerpt(") || this.row.getNode() != null && this.row.getNode().hasProperty(columnName))) {
                    JCRNodeWrapper valueNode = this.getNode();
                    try {
                        property = valueNode.getProperty(columnName);
                    }
                    catch (RepositoryException e) {
                        // empty catch block
                    }
                }
                if (property != null && !property.isMultiple()) {
                    valueResult = property.getValue();
                }
            }
            return valueResult;
        }

        public Value[] getValues() throws RepositoryException {
            return this.row.getValues();
        }

        private JCRNodeWrapper wrap(Node node) throws RepositoryException {
            if (node != null && QueryResultAdapter.this.session.getLocale() != null && node.hasProperty("jcr:language")) {
                String language = node.getProperty("jcr:language").getString();
                if (!QueryResultAdapter.this.getSessionLanguage().equals(language)) {
                    QueryResultAdapter.this.session = ServicesRegistry.getInstance().getJCRStoreService().getSessionFactory().getCurrentUserSession(QueryResultAdapter.this.session.getWorkspace().getName(), LanguageCodeConverters.languageCodeToLocale(language), QueryResultAdapter.this.session.getFallbackLocale());
                }
            }
            return node != null && !(node instanceof JCRNodeWrapper) ? QueryResultAdapter.this.getProvider().getNodeWrapper(node, QueryResultAdapter.this.session) : (JCRNodeWrapper)node;
        }

        public String getSpellcheck() throws RepositoryException {
            Value suggestion = this.row.getValue("rep:spellcheck()");
            return suggestion != null ? suggestion.getString() : null;
        }
    }
}

