/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.apache.commons.lang.ArrayUtils;
import org.apache.jackrabbit.commons.iterator.RowIteratorAdapter;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.RangeFacet;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.MultipleIterator;
import org.jahia.services.content.MultipleNodeIterator;
import org.jahia.services.query.QueryResultAdapter;
import org.jahia.services.query.QueryResultWrapper;

public final class QueryResultWrapperImpl
implements QueryResultWrapper {
    private static final QueryResultWrapperImpl EMPTY = new QueryResultWrapperImpl();
    private List<QueryResultAdapter> queryResults;
    private long limit;

    public static QueryResultWrapper wrap(List<QueryResultAdapter> queryResults, long limit) {
        if (queryResults == null || queryResults.isEmpty()) {
            return EMPTY;
        }
        return new QueryResultWrapperImpl(queryResults, limit);
    }

    private QueryResultWrapperImpl() {
        this.queryResults = Collections.emptyList();
    }

    private QueryResultWrapperImpl(List<QueryResultAdapter> queryResults, long limit) {
        this.queryResults = queryResults;
        this.limit = limit;
    }

    public String[] getColumnNames() throws RepositoryException {
        return !this.queryResults.isEmpty() ? this.queryResults.get(0).getColumnNames() : ArrayUtils.EMPTY_STRING_ARRAY;
    }

    public RowIterator getRows() throws RepositoryException {
        RowIterator resultRowIterator = RowIteratorAdapter.EMPTY;
        if (!this.queryResults.isEmpty()) {
            ArrayList<RowIterator> rowIterators = new ArrayList<RowIterator>();
            for (QueryResultAdapter queryResult : this.queryResults) {
                rowIterators.add(queryResult.getRows());
            }
            resultRowIterator = new MultipleRowIterator((List<RowIterator>)rowIterators, this.limit);
        }
        return resultRowIterator;
    }

    @Override
    public JCRNodeIteratorWrapper getNodes() throws RepositoryException {
        JCRNodeIteratorWrapper nodeIterator = JCRNodeIteratorWrapper.EMPTY;
        if (!this.queryResults.isEmpty()) {
            ArrayList<NodeIterator> nodeIterators = new ArrayList<NodeIterator>();
            for (QueryResultAdapter queryResult : this.queryResults) {
                nodeIterators.add(queryResult.getNodes());
            }
            nodeIterator = new MultipleNodeIterator((List<NodeIterator>)nodeIterators, this.limit);
        }
        return nodeIterator;
    }

    public String[] getSelectorNames() throws RepositoryException {
        return !this.queryResults.isEmpty() ? this.queryResults.get(0).getSelectorNames() : ArrayUtils.EMPTY_STRING_ARRAY;
    }

    @Override
    public List<FacetField> getFacetFields() {
        for (QueryResultAdapter queryResult : this.queryResults) {
            if (queryResult.getFacetFields() == null) continue;
            return queryResult.getFacetFields();
        }
        return null;
    }

    @Override
    public List<FacetField> getFacetDates() {
        for (QueryResultAdapter queryResult : this.queryResults) {
            if (queryResult.getFacetDates() == null) continue;
            return queryResult.getFacetDates();
        }
        return null;
    }

    @Override
    public List<RangeFacet> getRangeFacets() {
        for (QueryResultAdapter queryResult : this.queryResults) {
            if (queryResult.getRangeFacets() == null) continue;
            return queryResult.getRangeFacets();
        }
        return null;
    }

    @Override
    public FacetField getFacetField(String name) {
        for (QueryResultAdapter queryResult : this.queryResults) {
            if (queryResult.getFacetField(name) == null) continue;
            return queryResult.getFacetField(name);
        }
        return null;
    }

    @Override
    public FacetField getFacetDate(String name) {
        for (QueryResultAdapter queryResult : this.queryResults) {
            if (queryResult.getFacetDate(name) == null) continue;
            return queryResult.getFacetDate(name);
        }
        return null;
    }

    @Override
    public RangeFacet getRangeFacet(String name) {
        for (QueryResultAdapter queryResult : this.queryResults) {
            if (queryResult.getRangeFacet(name) == null) continue;
            return queryResult.getRangeFacet(name);
        }
        return null;
    }

    @Override
    public Map<String, Long> getFacetQuery() {
        for (QueryResultAdapter queryResult : this.queryResults) {
            if (queryResult.getFacetQuery() == null) continue;
            return queryResult.getFacetQuery();
        }
        return null;
    }

    @Override
    public List<FacetField> getLimitingFacets() {
        for (QueryResultAdapter queryResult : this.queryResults) {
            if (queryResult.getLimitingFacets() == null) continue;
            return queryResult.getLimitingFacets();
        }
        return null;
    }

    @Override
    public boolean isFacetFieldsEmpty(List<FacetField> facetFields) {
        if (facetFields.isEmpty()) {
            return true;
        }
        for (FacetField facetField : facetFields) {
            if (facetField.getValueCount() == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isRangeFacetsEmpty(List<RangeFacet> rangeFacets) {
        if (rangeFacets.isEmpty()) {
            return true;
        }
        for (RangeFacet facetField : rangeFacets) {
            List<RangeFacet.Count> counts = facetField.getCounts();
            for (RangeFacet.Count count : counts) {
                if (count.getCount() == 0) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isFacetResultsEmpty() {
        return !(this.getFacetFields() != null && !this.isFacetFieldsEmpty(this.getFacetFields()) || this.getFacetDates() != null && !this.isFacetFieldsEmpty(this.getFacetDates()) || this.getRangeFacets() != null && !this.isRangeFacetsEmpty(this.getRangeFacets()) || this.getFacetQuery() != null && !this.getFacetQuery().isEmpty());
    }

    @Override
    public long getApproxCount() {
        int result = 0;
        for (QueryResultAdapter queryResult : this.queryResults) {
            result = (int)((long)result + queryResult.getApproxCount());
        }
        return result;
    }

    public static class MultipleRowIterator
    extends MultipleIterator<RowIterator>
    implements RowIterator {
        public MultipleRowIterator(List<RowIterator> iterators, long limit) {
            super(iterators, limit);
        }

        public Row nextRow() {
            return (Row)this.next();
        }
    }
}

