/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.query;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.qom.And;
import javax.jcr.query.qom.ChildNode;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.DescendantNode;
import javax.jcr.query.qom.Join;
import javax.jcr.query.qom.Not;
import javax.jcr.query.qom.Or;
import javax.jcr.query.qom.QueryObjectModel;
import javax.jcr.query.qom.QueryObjectModelFactory;
import javax.jcr.query.qom.Selector;
import javax.jcr.query.qom.Source;
import javax.jcr.version.VersionException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.core.query.JahiaQueryObjectModelImpl;
import org.apache.jackrabbit.core.query.lucene.JahiaLuceneQueryFactoryImpl;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRStoreProvider;
import org.jahia.services.query.QueryResultAdapter;
import org.jahia.services.query.QueryResultWrapper;
import org.jahia.services.query.QueryResultWrapperImpl;
import org.jahia.services.query.QueryServiceImpl;
import org.jahia.utils.LuceneUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryWrapper
implements Query {
    public static final Logger logger = LoggerFactory.getLogger(QueryWrapper.class);
    private String statement;
    private QueryObjectModel jrQOM;
    private String sqlStatement;
    private String language;
    private long limit = -1L;
    private long offset = 0L;
    private Map<JCRStoreProvider, Query> queries;
    private Map<String, Value> vars;
    private Node node;
    private JCRSessionFactory service;
    private JCRSessionWrapper session;

    public QueryWrapper(String statement, String language, JCRSessionWrapper session, JCRSessionFactory service) throws InvalidQueryException, RepositoryException {
        this.statement = statement;
        this.language = language;
        this.vars = new HashMap<String, Value>();
        this.session = session;
        this.service = service;
        this.init();
    }

    public QueryWrapper(String statement, String language, String sqlStatement, JCRSessionWrapper session, JCRSessionFactory service) throws InvalidQueryException, RepositoryException {
        this.statement = statement;
        this.language = language;
        this.sqlStatement = sqlStatement;
        this.vars = new HashMap<String, Value>();
        this.session = session;
        this.service = service;
        this.init();
    }

    public QueryWrapper(QueryObjectModel qom, JCRSessionWrapper session, JCRSessionFactory service) throws InvalidQueryException, RepositoryException {
        this.jrQOM = qom;
        this.statement = qom.getStatement();
        this.language = "JCR-SQL2";
        this.vars = new HashMap<String, Value>();
        this.session = session;
        this.service = service;
        this.init();
    }

    public QueryWrapper(Node node, JCRSessionWrapper session, JCRSessionFactory service) throws InvalidQueryException, RepositoryException {
        this(node.getProperty("jcr:statement").getString(), node.getProperty("jcr:language").getString(), session, service);
        this.node = node;
    }

    private void init() throws InvalidQueryException, RepositoryException {
        this.queries = new LinkedHashMap<JCRStoreProvider, Query>();
        Collection<JCRStoreProvider> providers = this.service.getProviders().values();
        if (this.language.equals("xpath")) {
            // empty if block
        }
        for (JCRStoreProvider jcrStoreProvider : providers) {
            Query query = this.getQuery(jcrStoreProvider);
            if (query == null) continue;
            this.queries.put(jcrStoreProvider, query);
        }
    }

    protected Query getQuery(JCRStoreProvider jcrStoreProvider) throws RepositoryException {
        Object query = null;
        QueryManager qm = jcrStoreProvider.getQueryManager(this.session);
        String statement = null;
        String language = this.language;
        if (qm != null) {
            if (ArrayUtils.contains((Object[])qm.getSupportedQueryLanguages(), (Object)language)) {
                statement = this.statement;
            } else if (this.sqlStatement != null && ArrayUtils.contains((Object[])qm.getSupportedQueryLanguages(), (Object)"JCR-SQL2")) {
                statement = this.sqlStatement;
                language = "JCR-SQL2";
            }
        }
        if (statement != null) {
            QueryObjectModel qom;
            query = jcrStoreProvider.isDefault() && this.jrQOM != null ? this.jrQOM : qm.createQuery(statement, language);
            QueryObjectModelFactory factory = qm.getQOMFactory();
            if (!jcrStoreProvider.getMountPoint().equals("/") && query instanceof QueryObjectModel) {
                try {
                    qom = (QueryObjectModel)query;
                    query = factory.createQuery(qom.getSource(), this.convertPath(qom.getConstraint(), jcrStoreProvider.getMountPoint(), factory), qom.getOrderings(), qom.getColumns());
                }
                catch (ConstraintViolationException e) {
                    return null;
                }
            }
            if (query != null && query instanceof QueryObjectModel) {
                if ("JCR-SQL2".equals(language)) {
                    qom = QueryServiceImpl.getInstance().modifyAndOptimizeQuery((QueryObjectModel)query, factory, this.session);
                    Constraint constraint = jcrStoreProvider.isDefault() ? this.filterMountPoints(qom.getConstraint(), qom.getSource(), factory) : qom.getConstraint();
                    query = factory.createQuery(qom.getSource(), constraint, qom.getOrderings(), qom.getColumns());
                }
                if (query instanceof JahiaQueryObjectModelImpl) {
                    JahiaLuceneQueryFactoryImpl lqf = (JahiaLuceneQueryFactoryImpl)((JahiaQueryObjectModelImpl)((Object)query)).getLuceneQueryFactory();
                    lqf.setQueryLanguageAndLocale(LuceneUtils.extractLanguageOrNullFromStatement(statement), this.session.getLocale());
                }
            }
        }
        return query;
    }

    private Constraint filterMountPoints(Constraint constraint, Source source, QueryObjectModelFactory f) throws RepositoryException {
        if (source instanceof Selector) {
            Not c = f.not((Constraint)f.propertyExistence(((Selector)source).getSelectorName(), "j:isExternalProviderRoot"));
            if (constraint == null) {
                return c;
            }
            return f.and((Constraint)c, constraint);
        }
        if (source instanceof Join) {
            constraint = this.filterMountPoints(constraint, ((Join)source).getLeft(), f);
            constraint = this.filterMountPoints(constraint, ((Join)source).getRight(), f);
        }
        return constraint;
    }

    private Constraint convertPath(Constraint constraint, String mountPoint, QueryObjectModelFactory f) throws RepositoryException {
        if (constraint instanceof ChildNode) {
            String rootNoSlash;
            String root = ((ChildNode)constraint).getParentPath();
            String rootWithSlash = root.endsWith("/") ? root : root + "/";
            String string = rootNoSlash = root.endsWith("/") ? root.substring(0, root.length() - 1) : root;
            if (mountPoint.equals(rootNoSlash)) {
                return f.childNode(((ChildNode)constraint).getSelectorName(), "/");
            }
            if (mountPoint.startsWith(rootWithSlash)) {
                if (root.equals(StringUtils.substringBeforeLast((String)mountPoint, (String)"/"))) {
                    return f.sameNode(((ChildNode)constraint).getSelectorName(), "/");
                }
                throw new ConstraintViolationException();
            }
            if (rootWithSlash.startsWith(mountPoint)) {
                return f.childNode(((ChildNode)constraint).getSelectorName(), rootNoSlash.substring(mountPoint.length()));
            }
            throw new ConstraintViolationException();
        }
        if (constraint instanceof DescendantNode) {
            String rootNoSlash;
            String root = ((DescendantNode)constraint).getAncestorPath();
            String rootWithSlash = root.endsWith("/") ? root : root + "/";
            String string = rootNoSlash = root.endsWith("/") ? root.substring(0, root.length() - 1) : root;
            if (mountPoint.startsWith(rootWithSlash) || mountPoint.equals(rootNoSlash)) {
                return null;
            }
            if (rootWithSlash.startsWith(mountPoint)) {
                return f.descendantNode(((DescendantNode)constraint).getSelectorName(), root.substring(mountPoint.length()));
            }
            throw new ConstraintViolationException();
        }
        if (constraint instanceof And) {
            Constraint c1 = this.convertPath(((And)constraint).getConstraint1(), mountPoint, f);
            Constraint c2 = this.convertPath(((And)constraint).getConstraint2(), mountPoint, f);
            if (c1 == null) {
                return c2;
            }
            if (c2 == null) {
                return c1;
            }
            return f.and(c1, c2);
        }
        if (constraint instanceof Or) {
            Constraint c1 = null;
            try {
                c1 = this.convertPath(((Or)constraint).getConstraint1(), mountPoint, f);
            }
            catch (ConstraintViolationException e) {
                return this.convertPath(((Or)constraint).getConstraint2(), mountPoint, f);
            }
            Constraint c2 = null;
            try {
                c2 = this.convertPath(((Or)constraint).getConstraint2(), mountPoint, f);
            }
            catch (ConstraintViolationException e) {
                return c1;
            }
            if (c1 == null || c2 == null) {
                return null;
            }
            return f.or(c1, c2);
        }
        if (constraint instanceof Not) {
            Constraint notConstraint = null;
            try {
                notConstraint = this.convertPath(((Not)constraint).getConstraint(), mountPoint, f);
            }
            catch (ConstraintViolationException e) {
                return null;
            }
            if (notConstraint == null) {
                throw new ConstraintViolationException();
            }
            return f.not(notConstraint);
        }
        return constraint;
    }

    public QueryResultWrapper execute() throws RepositoryException {
        long queryOffset = this.offset;
        long queryLimit = this.limit;
        LinkedList<QueryResultAdapter> results = new LinkedList<QueryResultAdapter>();
        Iterator<Map.Entry<JCRStoreProvider, Query>> it = this.queries.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<JCRStoreProvider, Query> entry = it.next();
            Query query = entry.getValue();
            if (queryLimit >= 0L) {
                query.setLimit(queryLimit);
            }
            if (queryOffset >= 0L) {
                query.setOffset(queryOffset);
            }
            QueryResultAdapter queryResult = new QueryResultAdapter(query.execute(), entry.getKey(), this.session);
            results.add(queryResult);
            if (!it.hasNext() || queryLimit < 0L && queryOffset <= 0L) continue;
            long resultCount = this.getResultCount(queryResult);
            if (queryLimit >= 0L) {
                if (resultCount >= queryLimit) break;
                queryLimit -= resultCount;
            }
            if (queryOffset <= 0L) continue;
            if (resultCount == 0L) {
                Query noLimitNoOffsetQuery = this.getQuery(entry.getKey());
                queryOffset -= this.getResultCount(new QueryResultAdapter(noLimitNoOffsetQuery.execute(), entry.getKey(), this.session));
                continue;
            }
            queryOffset = 0L;
        }
        return QueryResultWrapperImpl.wrap(results, this.limit);
    }

    protected long getResultCount(QueryResultAdapter queryResult) throws RepositoryException {
        JCRNodeIteratorWrapper nodes = queryResult.getNodes();
        long size = nodes.getSize();
        if (size < 0L) {
            size = 0L;
            while (nodes.hasNext()) {
                ++size;
                nodes.next();
            }
        }
        return size;
    }

    public String getStatement() {
        return this.statement;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getStoredQueryPath() throws ItemNotFoundException, RepositoryException {
        if (this.node == null) {
            throw new ItemNotFoundException();
        }
        return this.node.getPath();
    }

    public Node storeAsNode(String s) throws ItemExistsException, PathNotFoundException, VersionException, ConstraintViolationException, LockException, UnsupportedRepositoryOperationException, RepositoryException {
        String path = StringUtils.substringBeforeLast((String)s, (String)"/");
        String name = StringUtils.substringAfterLast((String)s, (String)"/");
        Node n = (Node)this.session.getItem(path);
        this.node = n.addNode(name, "jnt:query");
        this.node.setProperty("jcr:statement", this.statement);
        this.node.setProperty("jcr:language", this.language);
        return this.node;
    }

    public void setLimit(long limit) {
        this.limit = limit;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public void bindValue(String varName, Value value) throws IllegalArgumentException, RepositoryException {
        this.vars.put(varName, value);
    }

    public String[] getBindVariableNames() throws RepositoryException {
        return this.vars.keySet().toArray(new String[this.vars.size()]);
    }

    public Map<JCRStoreProvider, Query> getQueries() {
        return this.queries;
    }
}

