/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Resource {
    public static final String CONFIGURATION_PAGE = "page";
    public static final String CONFIGURATION_GWT = "gwt";
    public static final String CONFIGURATION_MODULE = "module";
    public static final String CONFIGURATION_INCLUDE = "include";
    public static final String CONFIGURATION_WRAPPER = "wrapper";
    public static final String CONFIGURATION_WRAPPEDCONTENT = "wrappedcontent";
    private static Logger logger = LoggerFactory.getLogger(Resource.class);
    private JCRNodeWrapper node;
    private String templateType;
    private String template;
    private String contextConfiguration;
    private Stack<String> wrappers;
    private Set<String> dependencies;
    private List<String> missingResources;
    private List<Option> options;
    private ExtendedNodeType resourceNodeType;
    private Map<String, Serializable> moduleParams = new HashMap<String, Serializable>();
    private Set<String> regexpDependencies;

    public Resource(JCRNodeWrapper node, String templateType, String template, String contextConfiguration) {
        this.node = node;
        this.templateType = templateType;
        this.template = template;
        this.contextConfiguration = contextConfiguration;
        this.dependencies = new HashSet<String>();
        this.dependencies.add(node.getCanonicalPath());
        this.regexpDependencies = new LinkedHashSet<String>();
        this.missingResources = new ArrayList<String>();
        this.wrappers = new Stack();
        this.options = new ArrayList<Option>();
    }

    public JCRNodeWrapper getNode() {
        return this.node;
    }

    public void setNode(JCRNodeWrapper node) {
        this.node = node;
    }

    public String getTemplateType() {
        return this.templateType;
    }

    public void setTemplateType(String templateType) {
        this.templateType = templateType;
    }

    public String getWorkspace() {
        try {
            return this.node.getSession().getWorkspace().getName();
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public Locale getLocale() {
        try {
            return this.node.getSession().getLocale();
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public String getContextConfiguration() {
        return this.contextConfiguration;
    }

    public String getResolvedTemplate() {
        String resolvedTemplate = this.template;
        if (StringUtils.isEmpty((String)resolvedTemplate)) {
            try {
                resolvedTemplate = this.node.isNodeType("jmix:renderable") && this.node.hasProperty("j:view") ? this.node.getProperty("j:view").getString() : "default";
            }
            catch (RepositoryException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return resolvedTemplate;
    }

    public String getTemplate() {
        if (StringUtils.isEmpty((String)this.template)) {
            return "default";
        }
        return this.template;
    }

    public Set<String> getDependencies() {
        return this.dependencies;
    }

    public Set<String> getRegexpDependencies() {
        return this.regexpDependencies;
    }

    public List<String> getMissingResources() {
        return this.missingResources;
    }

    public Map<String, Serializable> getModuleParams() {
        return this.moduleParams;
    }

    public boolean hasWrapper() {
        return !this.wrappers.isEmpty();
    }

    public boolean hasWrapper(String wrapper) {
        return this.wrappers.contains(wrapper);
    }

    public String popWrapper() {
        return this.wrappers.pop();
    }

    public String pushWrapper(String wrapper) {
        return this.wrappers.push(wrapper);
    }

    public String getPath() {
        return this.node.getPath() + "." + this.getTemplate() + "." + this.templateType;
    }

    public String toString() {
        String primaryNodeTypeName = null;
        try {
            primaryNodeTypeName = this.node.getPrimaryNodeTypeName();
        }
        catch (RepositoryException e) {
            logger.error("Error while retrieving node primary node type name", (Throwable)e);
        }
        return "Resource{node=" + this.node.getPath() + ", primaryNodeTypeName='" + primaryNodeTypeName + "', templateType='" + this.templateType + "', template='" + this.getTemplate() + "', configuration='" + this.contextConfiguration + "'}";
    }

    public void addOption(String wrapper, ExtendedNodeType nodeType) {
        this.options.add(new Option(wrapper, nodeType));
    }

    public List<Option> getOptions() {
        return this.options;
    }

    public boolean hasOptions() {
        return !this.options.isEmpty();
    }

    public void removeOption(ExtendedNodeType mixinNodeType) {
        this.options.remove(new Option("", mixinNodeType));
    }

    public ExtendedNodeType getResourceNodeType() {
        return this.resourceNodeType;
    }

    public void setContextConfiguration(String contextConfiguration) {
        this.contextConfiguration = contextConfiguration;
    }

    public void setResourceNodeType(ExtendedNodeType resourceNodeType) {
        this.resourceNodeType = resourceNodeType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Resource resource = (Resource)o;
        if (this.node != null ? !this.node.getCanonicalPath().equals(resource.node.getCanonicalPath()) : resource.node != null) {
            return false;
        }
        if (this.templateType != null ? !this.templateType.equals(resource.templateType) : resource.templateType != null) {
            return false;
        }
        if (this.template != null ? !this.template.equals(resource.template) : resource.template != null) {
            return false;
        }
        if (this.wrappers != null ? !this.wrappers.equals(resource.wrappers) : resource.wrappers != null) {
            return false;
        }
        if (this.options != null ? !this.options.equals(resource.options) : resource.options != null) {
            return false;
        }
        if (this.resourceNodeType != null ? !this.resourceNodeType.equals(resource.resourceNodeType) : resource.resourceNodeType != null) {
            return false;
        }
        return !(this.moduleParams != null ? !this.moduleParams.equals(resource.moduleParams) : resource.moduleParams != null);
    }

    public int hashCode() {
        int result = this.node != null ? this.node.hashCode() : 0;
        result = 31 * result + (this.templateType != null ? this.templateType.hashCode() : 0);
        result = 31 * result + (this.getTemplate() != null ? this.getTemplate().hashCode() : 0);
        result = 31 * result + (this.wrappers != null ? this.wrappers.hashCode() : 0);
        result = 31 * result + (this.options != null ? this.options.hashCode() : 0);
        result = 31 * result + (this.resourceNodeType != null ? this.resourceNodeType.hashCode() : 0);
        result = 31 * result + (this.moduleParams != null ? this.moduleParams.hashCode() : 0);
        return result;
    }

    public class Option
    implements Comparable<Option> {
        private final String wrapper;
        private final ExtendedNodeType nodeType;

        public Option(String wrapper, ExtendedNodeType nodeType) {
            this.wrapper = wrapper;
            this.nodeType = nodeType;
        }

        public ExtendedNodeType getNodeType() {
            return this.nodeType;
        }

        public String getWrapper() {
            return this.wrapper;
        }

        @Override
        public int compareTo(Option o) {
            return this.nodeType.getName().compareTo(o.getNodeType().getName());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Option option = (Option)o;
            return this.nodeType.getName().equals(option.nodeType.getName());
        }

        public int hashCode() {
            return this.nodeType.getName().hashCode();
        }
    }
}

