/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.map.LazyMap;
import org.apache.commons.lang.StringUtils;
import org.jahia.bin.Captcha;
import org.jahia.bin.DocumentConverter;
import org.jahia.bin.Find;
import org.jahia.bin.FindPrincipal;
import org.jahia.bin.FindUser;
import org.jahia.bin.FindUsersAndGroups;
import org.jahia.bin.FindUsersAndGroupsInAcl;
import org.jahia.bin.Initializers;
import org.jahia.bin.Login;
import org.jahia.bin.Logout;
import org.jahia.bin.Render;
import org.jahia.params.valves.LoginConfig;
import org.jahia.params.valves.LogoutConfig;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.View;
import org.jahia.services.render.scripting.Script;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.Url;

public class URLGenerator {
    private String base;
    private String live;
    private String edit;
    private String preview;
    private String contribute;
    private String studio;
    private String studioVisual;
    private String find;
    private String initializers;
    private Resource resource;
    private RenderContext context;
    private Map<String, String> languages;
    private Map<String, String> templates;
    private Map<String, String> templateTypes;
    private Map<String, String> bases;
    private String templatesPath;
    private String baseLive;
    private String baseContribute;
    private String baseEdit;
    private String basePreview;
    private String baseUserBoardEdit;
    private String baseUserBoardLive;
    private String baseUserBoardFrameEdit;
    private String baseUserBoardFrameLive;
    private String convert;
    private String myProfile;
    private String server;
    private String login;
    private String logout;

    public URLGenerator(RenderContext context, Resource resource) {
        this.context = context;
        this.resource = resource;
        this.initURL();
        if (context.getURLGenerator() == null) {
            context.setURLGenerator(this);
        }
    }

    protected void initURL() {
        this.base = this.getBase(this.resource.getLocale().toString());
        String resourcePath = this.getResourcePath();
        this.baseLive = Render.getRenderServletPath() + "/" + "live" + "/" + this.resource.getLocale();
        this.live = this.baseLive + resourcePath;
        if (!SettingsBean.getInstance().isDistantPublicationServerMode()) {
            this.baseEdit = "/cms/edit/default/" + this.resource.getLocale();
            this.edit = this.baseEdit + resourcePath;
            this.baseContribute = "/cms/contribute/default/" + this.resource.getLocale();
            this.contribute = this.baseContribute + resourcePath;
        }
        this.basePreview = Render.getRenderServletPath() + "/" + "default" + "/" + this.resource.getLocale();
        this.preview = this.basePreview + resourcePath;
        this.find = Find.getFindServletPath() + "/" + this.resource.getWorkspace() + "/" + this.resource.getLocale();
        this.initializers = Initializers.getInitializersServletPath() + "/" + this.resource.getWorkspace() + "/" + this.resource.getLocale();
        this.convert = DocumentConverter.getPath() + "/" + this.resource.getWorkspace();
        this.templatesPath = "/modules";
        this.baseUserBoardEdit = "/cms/dashboard/default/" + this.resource.getLocale();
        this.baseUserBoardLive = "/cms/dashboard/live/" + this.resource.getLocale();
        this.baseUserBoardFrameEdit = "/cms/dashboardframe/default/" + this.resource.getLocale();
        this.baseUserBoardFrameLive = "/cms/dashboardframe/live/" + this.resource.getLocale();
    }

    public String getResourcePath() {
        return this.context.getMainResource().getNode().getPath() + (!"default".equals(this.context.getMainResource().getTemplate()) ? "." + this.context.getMainResource().getTemplate() + "." : ".") + this.context.getMainResource().getTemplateType();
    }

    public String getContext() {
        return this.context.getRequest().getContextPath();
    }

    public String getFiles() {
        return "/files/" + this.resource.getWorkspace();
    }

    public String getFilesPlaceholders() {
        return "/files/{workspace}";
    }

    public String getBase() {
        return this.base;
    }

    public String getBasePlaceholders() {
        return StringUtils.substringBeforeLast((String)this.context.getServletPath(), (String)"/") + "/{mode}/{lang}";
    }

    public String getLive() {
        return this.live;
    }

    public String getEdit() {
        return this.edit;
    }

    public String getPreview() {
        return this.preview;
    }

    public String getContribute() {
        return this.contribute;
    }

    public String getStudio() {
        if (this.studio == null) {
            this.studio = this.getStudio(false);
        }
        return this.studio;
    }

    private String getStudio(boolean isVisual) {
        String mode = isVisual ? "studiovisual" : "studio";
        SettingsBean cfg = SettingsBean.getInstance();
        if (cfg.isDistantPublicationServerMode() || cfg.isProductionMode()) {
            return null;
        }
        String url = this.context.getSite() != null && this.context.getSite().getPath().startsWith("/modules/") ? "/cms/" + mode + "/" + "default" + "/" + this.resource.getLocale() + this.context.getSite().getPath() + ".html" : (isVisual ? "/welcome/studiovisualmode" : "/welcome/studiomode");
        return url;
    }

    public String getStudioVisual() {
        if (this.studioVisual == null) {
            this.studioVisual = this.getStudio(true);
        }
        return this.studioVisual;
    }

    public String getFind() {
        return this.find;
    }

    public String getFindPrincipal() {
        return FindPrincipal.getFindPrincipalServletPath();
    }

    public String getLogout() {
        if (this.logout == null) {
            this.logout = StringUtils.defaultIfEmpty((String)LogoutConfig.getInstance().getCustomLogoutUrl(this.context.getRequest()), (String)Logout.getLogoutServletPath());
        }
        return this.logout;
    }

    public String getCurrentModule() {
        View view = ((Script)this.context.getRequest().getAttribute("script")).getView();
        return view.getModule().getRootFolderPath();
    }

    public String getCurrent() {
        return this.buildURL(this.resource.getNode(), this.resource.getResolvedTemplate(), this.resource.getTemplateType());
    }

    public Map<String, String> getLanguages() {
        if (this.languages == null) {
            this.languages = LazyMap.decorate(new HashMap(), (Transformer)new Transformer(){

                public Object transform(Object lang) {
                    return URLGenerator.this.getLanguage((String)lang);
                }
            });
        }
        return this.languages;
    }

    public String getLanguage(String languageCode) {
        return this.getContext() + this.context.getServletPath() + "/" + this.resource.getWorkspace() + "/" + languageCode + this.context.getMainResource().getNode().getPath() + ("default".equals(this.resource.getTemplate()) ? "" : "." + this.resource.getTemplate()) + ".html";
    }

    public Map<String, String> getTemplates() {
        if (this.templates == null) {
            this.templates = LazyMap.decorate(new HashMap(), (Transformer)new Transformer(){

                public Object transform(Object template) {
                    return URLGenerator.this.getTemplate((String)template);
                }
            });
        }
        return this.templates;
    }

    public String getTemplate(String template) {
        return this.buildURL(this.resource.getNode(), template, this.resource.getTemplateType());
    }

    public Map<String, String> getTemplateTypes() {
        if (this.templateTypes == null) {
            this.templateTypes = LazyMap.decorate(new HashMap(), (Transformer)new Transformer(){

                public Object transform(Object templateType) {
                    return URLGenerator.this.getTemplateType((String)templateType);
                }
            });
        }
        return this.templateTypes;
    }

    public String getTemplateType(String templateType) {
        return this.buildURL(this.resource.getNode(), this.resource.getResolvedTemplate(), templateType);
    }

    public Map<String, String> getBases() {
        if (this.bases == null) {
            this.bases = LazyMap.decorate(new HashMap(), (Transformer)new Transformer(){

                public Object transform(Object lang) {
                    return URLGenerator.this.getBase((String)lang);
                }
            });
        }
        return this.bases;
    }

    public String getBase(String languageCode) {
        return this.context.getServletPath() + "/" + this.resource.getWorkspace() + "/" + languageCode;
    }

    public String getTemplatesPath() {
        return this.templatesPath;
    }

    public String getMainResource() {
        return this.base + this.context.getMainResource().getNode().getPath() + "." + this.context.getMainResource().getResolvedTemplate() + ".html";
    }

    public String buildURL(JCRNodeWrapper node, String template, String templateType) {
        return this.base + node.getPath() + (template != null && !"default".equals(template) ? "." + template : "") + "." + templateType;
    }

    public String buildURL(JCRNodeWrapper node, String languageCode, String template, String templateType) {
        if (StringUtils.isEmpty((String)languageCode)) {
            return this.buildURL(node, template, templateType);
        }
        return this.context.getServletPath() + "/" + this.resource.getWorkspace() + "/" + languageCode + node.getPath() + (template != null && !"default".equals(template) ? "." + template : "") + "." + templateType;
    }

    public String getInitializers() {
        return this.initializers;
    }

    public String getCaptcha() {
        return Captcha.getCaptchaServletPath();
    }

    public String getBaseContribute() {
        return this.baseContribute;
    }

    public String getBaseEdit() {
        return this.baseEdit;
    }

    public String getBaseLive() {
        return this.baseLive;
    }

    public String getBasePreview() {
        return this.basePreview;
    }

    public String getConvert() {
        return this.convert;
    }

    public String getBaseUserBoardEdit() {
        return this.baseUserBoardEdit;
    }

    public String getBaseUserBoardLive() {
        return this.baseUserBoardLive;
    }

    public String getBaseUserBoardFrameEdit() {
        return this.baseUserBoardFrameEdit;
    }

    public String getBaseUserBoardFrameLive() {
        return this.baseUserBoardFrameLive;
    }

    public String getRealResource() {
        if (this.context.isAjaxRequest() && this.context.getAjaxResource() != null) {
            if (this.context.isEditMode()) {
                return this.baseEdit + this.context.getAjaxResource().getNode().getPath() + ".html";
            }
            if (this.context.isContributionMode()) {
                return this.baseContribute + this.context.getAjaxResource().getNode().getPath() + ".html";
            }
            return ("live".equals(this.context.getAjaxResource().getWorkspace()) ? this.baseLive : this.basePreview) + this.context.getAjaxResource().getNode().getPath() + ".html";
        }
        if (this.context.isEditMode()) {
            if (this.context.getEditModeConfigName().equals("studiomode")) {
                return this.getStudio();
            }
            return this.getEdit();
        }
        return "live".equals(this.resource.getWorkspace()) ? this.live : this.preview;
    }

    public String getServer() {
        if (this.server == null) {
            int port;
            StringBuilder url = new StringBuilder();
            String scheme = this.context.getRequest().getScheme();
            String host = this.context.getSite().getServerName();
            if (Url.isLocalhost(host)) {
                host = this.context.getRequest().getServerName();
            }
            if ((port = SettingsBean.getInstance().getSiteURLPortOverride()) == 0) {
                port = this.context.getRequest().getServerPort();
            }
            url.append(scheme).append("://").append(host);
            if (!(port == 80 && "http".equals(scheme) || port == 443 && "https".equals(scheme))) {
                url.append(":").append(port);
            }
            this.server = url.toString();
        }
        return this.server;
    }

    public String getMyProfile() {
        if (this.myProfile == null) {
            JahiaUser user = this.context.getUser();
            this.myProfile = JahiaUserManagerService.isNotGuest(user) && user.isMemberOfGroup(0, "privileged") ? "/start" : "";
        }
        return this.myProfile;
    }

    public String getLogin() {
        if (this.login == null) {
            this.login = StringUtils.defaultIfEmpty((String)LoginConfig.getInstance().getCustomLoginUrl(this.context.getRequest()), (String)Login.getServletPath());
        }
        return this.login;
    }

    public String getFindUser() {
        return FindUser.getFindUserServletPath();
    }

    public String getFindUsersAndGroups() {
        return FindUsersAndGroups.getFindUsersAndGroupsServletPath();
    }

    public String getFindUsersAndGroupsInAcl() {
        return FindUsersAndGroupsInAcl.getFindUsersAndGroupsInAclServletPath();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("URLGenerator");
        sb.append("{base='").append(this.base).append('\'');
        sb.append(", live='").append(this.live).append('\'');
        sb.append(", edit='").append(this.edit).append('\'');
        sb.append(", preview='").append(this.preview).append('\'');
        sb.append(", contribute='").append(this.contribute).append('\'');
        sb.append(", studio='").append(this.studio).append('\'');
        sb.append(", find='").append(this.find).append('\'');
        sb.append(", initializers='").append(this.initializers).append('\'');
        sb.append(", resource=").append(this.resource);
        sb.append(", context=").append(this.context);
        sb.append(", languages=").append(this.languages);
        sb.append(", templates=").append(this.templates);
        sb.append(", templateTypes=").append(this.templateTypes);
        sb.append(", templatesPath='").append(this.templatesPath).append('\'');
        sb.append(", baseLive='").append(this.baseLive).append('\'');
        sb.append(", baseContribute='").append(this.baseContribute).append('\'');
        sb.append(", baseEdit='").append(this.baseEdit).append('\'');
        sb.append(", basePreview='").append(this.basePreview).append('\'');
        sb.append(", convert='").append(this.convert).append('\'');
        sb.append(", myProfile='").append(this.myProfile).append('\'');
        sb.append(", server='").append(this.server).append('\'');
        sb.append(", login='").append(this.login).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

