/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.search.Query;
import net.sf.ehcache.search.Result;
import org.jahia.services.cache.ehcache.EhCacheProvider;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.URLResolver;
import org.jahia.services.render.URLResolverListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLResolverFactory {
    private static Logger logger = LoggerFactory.getLogger(URLResolverFactory.class);
    private Ehcache nodePathCache;
    private Ehcache siteInfoCache;
    private static final String NODE_PATH_CACHE = "urlResolverNodePath";
    private static final String SITE_INFO_CACHE = "urlResolverSiteInfo";

    public void setCacheService(EhCacheProvider cacheService) {
        this.nodePathCache = cacheService.getCacheManager().addCacheIfAbsent(NODE_PATH_CACHE);
        this.siteInfoCache = cacheService.getCacheManager().addCacheIfAbsent(SITE_INFO_CACHE);
    }

    public void setUrlResolverListener(URLResolverListener urlResolverListener) {
        urlResolverListener.setUrlResolverFactory(this);
    }

    public URLResolver createURLResolver(String urlPathInfo, String serverName, String workspace, HttpServletRequest request) {
        return new URLResolver(urlPathInfo, serverName, workspace, request, this.nodePathCache, this.siteInfoCache);
    }

    public URLResolver createURLResolver(String urlPathInfo, String serverName, HttpServletRequest request) {
        return new URLResolver(urlPathInfo, serverName, request, this.nodePathCache, this.siteInfoCache);
    }

    public URLResolver createURLResolver(String url, RenderContext context) {
        return new URLResolver(url, context, this.nodePathCache, this.siteInfoCache);
    }

    public synchronized void flushCaches(String path) {
        List all = this.nodePathCache.createQuery().includeKeys().addCriteria(Query.VALUE.eq((Object)path)).execute().all();
        if (logger.isDebugEnabled() && !all.isEmpty()) {
            logger.debug("Flushing {} keys from URLResolver Caches.", (Object)all.size());
        }
        for (Result result : all) {
            if (logger.isDebugEnabled()) {
                logger.debug("Flushing key: {}", result.getKey());
            }
            this.nodePathCache.remove(result.getKey());
            this.siteInfoCache.remove(result.getKey());
        }
    }
}

