/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render;

import java.io.Serializable;
import java.util.UUID;
import javax.jcr.RepositoryException;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import net.sf.ehcache.Element;
import org.apache.jackrabbit.core.JahiaRepositoryImpl;
import org.jahia.services.content.DefaultEventListener;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.impl.jackrabbit.SpringJackrabbitRepository;
import org.jahia.services.render.URLResolverFactory;
import org.jahia.services.render.filter.cache.CacheClusterEvent;
import org.jahia.services.render.filter.cache.ModuleCacheProvider;
import org.jahia.services.seo.jcr.VanityUrlService;
import org.jahia.settings.SettingsBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLResolverListener
extends DefaultEventListener {
    private static Logger logger = LoggerFactory.getLogger(URLResolverListener.class);
    private URLResolverFactory urlResolverFactory;
    private VanityUrlService vanityUrlService;
    private ModuleCacheProvider moduleCacheProvider;

    @Override
    public int getEventTypes() {
        return 63;
    }

    public void onEvent(EventIterator events) {
        if (this.urlResolverFactory == null) {
            return;
        }
        try {
            while (events.hasNext()) {
                int pos;
                Event event = events.nextEvent();
                if (this.isExternal(event)) continue;
                String path = event.getPath();
                if (event.getType() != 1 && event.getType() != 2 && event.getType() != 32 && !path.endsWith("/j:published") && !path.contains("/vanityUrlMapping/")) continue;
                if ((event.getType() == 16 || event.getType() == 4 || event.getType() == 8) && (pos = (path = path.substring(0, path.lastIndexOf("/"))).lastIndexOf("/")) != -1 && path.substring(pos, path.length()).startsWith("/j:translation_")) {
                    path = path.substring(0, pos);
                }
                this.flushCaches(path);
                return;
            }
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void setUrlResolverFactory(URLResolverFactory urlResolverFactory) {
        this.urlResolverFactory = urlResolverFactory;
    }

    public void setVanityUrlService(VanityUrlService vanityUrlService) {
        this.vanityUrlService = vanityUrlService;
    }

    private void flushCaches(String path) throws RepositoryException {
        this.urlResolverFactory.flushCaches(path);
        boolean clusterActivated = SettingsBean.getInstance().isClusterActivated();
        if (clusterActivated) {
            this.moduleCacheProvider.getSyncCache().put(new Element((Serializable)((Object)("FLUSH_URLRESOLVER-" + UUID.randomUUID())), (Serializable)new CacheClusterEvent(path, URLResolverListener.getClusterRevision())));
        }
        if (path.contains("vanityUrlMapping")) {
            this.vanityUrlService.flushCaches();
            if (clusterActivated) {
                this.moduleCacheProvider.getSyncCache().put(new Element((Serializable)((Object)("FLUSH_VANITYURL-" + UUID.randomUUID())), (Serializable)new CacheClusterEvent("", URLResolverListener.getClusterRevision())));
            }
        }
    }

    private static long getClusterRevision() {
        return ((JahiaRepositoryImpl)((SpringJackrabbitRepository)JCRSessionFactory.getInstance().getDefaultProvider().getRepository()).getRepository()).getContext().getClusterNode().getRevision();
    }

    public void setModuleCacheProvider(ModuleCacheProvider moduleCacheProvider) {
        this.moduleCacheProvider = moduleCacheProvider;
    }
}

