/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render.filter;

import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.TemplateNotFoundException;
import org.jahia.services.render.URLGenerator;
import org.jahia.services.render.filter.AbstractFilter;
import org.jahia.services.render.filter.RenderChain;
import org.jahia.services.render.scripting.Script;
import org.jahia.services.uicomponents.bean.editmode.EditConfiguration;

public class BaseAttributesFilter
extends AbstractFilter {
    public Set<String> configurationToSkipInResourceRenderedPath;

    @Override
    public String prepare(RenderContext context, Resource resource, RenderChain chain) throws Exception {
        JCRNodeWrapper node = resource.getNode();
        HttpServletRequest request = context.getRequest();
        request.setAttribute("renderContext", (Object)context);
        try {
            Script script = this.service.resolveScript(resource, context);
            chain.pushAttribute(request, "script", script);
            chain.pushAttribute(request, "scriptInfo", script.getView().getInfo());
        }
        catch (TemplateNotFoundException e) {
            chain.pushAttribute(request, "script", null);
            chain.pushAttribute(request, "scriptInfo", null);
        }
        chain.pushAttribute(request, "workspace", node.getSession().getWorkspace().getName());
        chain.pushAttribute(request, "currentResource", resource);
        String contextPath = null;
        contextPath = context.isEditMode() && !context.isContributionMode() ? StringUtils.substringAfterLast((String)((EditConfiguration)SpringContextSingleton.getBean(context.getEditModeConfigName())).getDefaultUrlMapping(), (String)"/") : (context.isContributionMode() ? "contribute" : "render");
        String mode = contextPath + "/" + resource.getWorkspace();
        chain.pushAttribute(request, "currentLocale", resource.getLocale());
        chain.pushAttribute(request, "currentWorkspace", resource.getNode().getSession().getWorkspace().getName());
        chain.pushAttribute(request, "currentMode", mode);
        chain.pushAttribute(request, "currentUser", context.getMainResource().getNode().getSession().getUser());
        chain.pushAttribute(request, "currentAliasUser", context.getMainResource().getNode().getSession().getAliasedUser());
        if (!"include".equals(resource.getContextConfiguration())) {
            chain.pushAttribute(request, "currentNode", node);
            chain.pushAttribute(request, "url", new URLGenerator(context, resource));
        }
        boolean added = false;
        if (!this.configurationToSkipInResourceRenderedPath.contains(resource.getContextConfiguration())) {
            added = context.getRenderedPaths().add(resource.getNode().getPath());
        }
        chain.pushAttribute(request, "resourceAddedInRenderedPath", added);
        return null;
    }

    @Override
    public String execute(String previousOut, RenderContext renderContext, Resource resource, RenderChain chain) throws Exception {
        if (renderContext.getRequest().getAttribute("resourceAddedInRenderedPath").equals(true)) {
            renderContext.getRenderedPaths().remove(resource.getNode().getPath());
        }
        return super.execute(previousOut, renderContext, resource, chain);
    }

    public void setConfigurationToSkipInResourceRenderedPath(Set<String> configurationToSkipInResourceRenderedPath) {
        this.configurationToSkipInResourceRenderedPath = configurationToSkipInResourceRenderedPath;
    }
}

