/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render.filter;

import java.util.Arrays;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.PathNotFoundException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import net.htmlparser.jericho.OutputDocument;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.URLGenerator;
import org.jahia.services.render.filter.AbstractFilter;
import org.jahia.services.render.filter.RenderChain;
import org.jahia.utils.Patterns;
import org.jahia.utils.StringResponseWrapper;

public class EditModeFilter
extends AbstractFilter {
    private List<String> blockableModes;

    @Override
    public String execute(String previousOut, RenderContext renderContext, Resource resource, RenderChain chain) throws Exception {
        String out = super.execute(previousOut, renderContext, resource, chain);
        if (renderContext.getServletPath().endsWith("frame")) {
            Source source = new Source((CharSequence)out);
            OutputDocument document = new OutputDocument(source);
            List tags = source.getAllStartTags("a");
            for (StartTag tag : tags) {
                String href = tag.getAttributeValue("href");
                if (href == null || (!href.startsWith("/") || href.startsWith(renderContext.getRequest().getContextPath() + renderContext.getServletPath())) && !href.contains("://") || tag.getAttributeValue("target") != null) continue;
                document.insert(tag.getEnd() - 1, (CharSequence)" target=\"_parent\"");
            }
            return document.toString();
        }
        return out;
    }

    @Override
    public String prepare(RenderContext renderContext, Resource resource, RenderChain chain) throws Exception {
        JCRSiteNode site = resource.getNode().getResolveSite();
        JahiaTemplatesPackage templatePackage = site.getTemplatePackage();
        if (templatePackage == null) {
            throw new PathNotFoundException("Couldn't find the template associated with site " + site.getName() + ". Please check that all its dependencies are started.");
        }
        if (this.blockableModes != null && this.blockableModes.contains(renderContext.getMode()) && templatePackage.isEditModeBlocked()) {
            throw new AccessDeniedException("This site is not accessible in Edit mode.");
        }
        if (!renderContext.getServletPath().endsWith("frame")) {
            StringResponseWrapper wrapper = new StringResponseWrapper(renderContext.getResponse());
            renderContext.getRequest().setAttribute("currentResource", (Object)resource);
            renderContext.getRequest().setAttribute("renderContext", (Object)renderContext);
            renderContext.getRequest().setAttribute("servletPath", (Object)renderContext.getRequest().getServletPath());
            renderContext.getRequest().setAttribute("url", (Object)new URLGenerator(renderContext, resource));
            renderContext.getRequest().getRequestDispatcher("/engines/edit.jsp").forward((ServletRequest)renderContext.getRequest(), (ServletResponse)wrapper);
            return wrapper.getString();
        }
        return super.prepare(renderContext, resource, chain);
    }

    public void setBlockableModes(String blockableModes) {
        this.blockableModes = Arrays.asList(Patterns.COMMA.split(blockableModes));
    }
}

