/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render.filter;

import javax.servlet.http.HttpSession;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.logging.MetricsLoggingService;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.filter.AbstractFilter;
import org.jahia.services.render.filter.RenderChain;
import org.slf4j.profiler.Profiler;

public class MetricsLoggingFilter
extends AbstractFilter {
    private MetricsLoggingService loggingService;

    public void setLoggingService(MetricsLoggingService loggingService) {
        this.loggingService = loggingService;
    }

    @Override
    public String prepare(RenderContext context, Resource resource, RenderChain chain) throws Exception {
        if (!this.loggingService.isProfilingEnabled()) {
            return null;
        }
        JCRNodeWrapper node = resource.getNode();
        String profilerName = "render module " + node.getPath();
        Profiler profiler = this.loggingService.createNestedProfiler("MAIN", profilerName);
        profiler.start("render filters for " + node.getPath());
        context.getRequest().setAttribute("profiler", (Object)profiler);
        return null;
    }

    @Override
    public String execute(String previousOut, RenderContext context, Resource resource, RenderChain chain) throws Exception {
        if (!this.loggingService.isProfilingEnabled()) {
            return previousOut;
        }
        JCRNodeWrapper node = resource.getNode();
        String profilerName = "render module " + node.getPath();
        String sessionID = "";
        HttpSession session = context.getRequest().getSession(false);
        if (session != null) {
            sessionID = session.getId();
        }
        if (this.loggingService.isEnabled()) {
            this.loggingService.logContentEvent(context.getUser().getName(), context.getRequest().getRemoteAddr(), sessionID, node.getIdentifier(), node.getPath(), node.getNodeTypes().get(0), "moduleViewed", resource.getResolvedTemplate());
        }
        this.loggingService.stopNestedProfiler("MAIN", profilerName);
        return previousOut;
    }
}

