/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render.filter;

import java.util.List;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.URLGenerator;
import org.jahia.services.render.filter.HtmlTagAttributeTraverser;
import org.jahia.services.seo.VanityUrl;
import org.jahia.services.seo.jcr.VanityUrlService;
import org.jahia.utils.Url;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SiteParameterAdder
implements HtmlTagAttributeTraverser.HtmlTagAttributeVisitor {
    private static transient Logger logger = LoggerFactory.getLogger(SiteParameterAdder.class);
    public static final String SITE_URL_PARAMETER_NAME = "jsite";
    private static final String DEFAULT_WORKSPACE = "live";
    private VanityUrlService vanityUrlService;

    public void setVanityUrlService(VanityUrlService vanityUrlService) {
        this.vanityUrlService = vanityUrlService;
    }

    @Override
    public String visit(String value, RenderContext context, String tagName, String attrName, Resource resource) {
        URLGenerator urlGenerator = context.getURLGenerator();
        if (value != null && value.startsWith(urlGenerator.getContext() + urlGenerator.getBase() + "/") && !value.startsWith(urlGenerator.getContext() + urlGenerator.getBase() + "/sites/") && !value.contains("jsite=")) {
            String jsite;
            String servletPath;
            String string = servletPath = context.getRequest().getContextPath().length() > 0 ? context.getRequest().getContextPath() + context.getServletPath() : context.getServletPath();
            if (StringUtils.isNotEmpty((String)value) && !Url.isLocalhost(context.getRequest().getServerName()) && value.startsWith(servletPath)) {
                try {
                    String pathInfo = value.substring(servletPath.length());
                    String tempWorkspace = this.verifyWorkspace(StringUtils.substringBefore((String)pathInfo.substring(1), (String)"/"));
                    String tempPath = StringUtils.substringAfter((String)pathInfo.substring(1), (String)"/");
                    List<VanityUrl> vanityUrls = this.vanityUrlService.findExistingVanityUrls("/" + tempPath, "", tempWorkspace);
                    VanityUrl resolvedVanityUrl = null;
                    String siteKey = context.getSite().getSiteKey();
                    for (VanityUrl vanityUrl : vanityUrls) {
                        if (!vanityUrl.isActive() || !StringUtils.isEmpty((String)siteKey) && !siteKey.equals(vanityUrl.getSite())) continue;
                        resolvedVanityUrl = vanityUrl;
                        break;
                    }
                    if (resolvedVanityUrl != null) {
                        return value;
                    }
                }
                catch (RepositoryException e) {
                    logger.error("Error trying to resolve vanity URL " + value, (Throwable)e);
                }
            }
            if ((jsite = context.getRequest().getParameter(SITE_URL_PARAMETER_NAME)) == null) {
                jsite = (String)((Object)context.getMainResource().getModuleParams().get(SITE_URL_PARAMETER_NAME));
            }
            if (jsite == null) {
                try {
                    jsite = resource.getNode().getResolveSite().getIdentifier();
                }
                catch (RepositoryException e) {
                    return value;
                }
            }
            value = value + (!value.contains("?") ? "?jsite=" : "&jsite=") + jsite;
        }
        return value;
    }

    protected String verifyWorkspace(String workspace) {
        if (StringUtils.isEmpty((String)workspace)) {
            if (workspace == null) {
                workspace = DEFAULT_WORKSPACE;
            }
        } else if (!JCRContentUtils.isValidWorkspace(workspace)) {
            return DEFAULT_WORKSPACE;
        }
        return workspace;
    }
}

