/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render.filter;

import com.yahoo.platform.yui.compressor.CssCompressor;
import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import com.yahoo.platform.yui.org.mozilla.javascript.ErrorReporter;
import com.yahoo.platform.yui.org.mozilla.javascript.EvaluatorException;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Pattern;
import javax.jcr.RepositoryException;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.SimpleScriptContext;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.EndTag;
import net.htmlparser.jericho.OutputDocument;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;
import org.apache.commons.collections.ComparatorUtils;
import org.apache.commons.collections.Factory;
import org.apache.commons.collections.FastHashMap;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.functors.NOPTransformer;
import org.apache.commons.collections.map.LazySortedMap;
import org.apache.commons.collections.map.TransformedSortedMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jahia.ajax.gwt.utils.GWTInitializer;
import org.jahia.bin.Jahia;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.nodetypes.ConstraintsHelper;
import org.jahia.services.render.AssetsMapFactory;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.filter.AbstractFilter;
import org.jahia.services.render.filter.RenderChain;
import org.jahia.services.render.filter.cache.AggregateCacheFilter;
import org.jahia.services.templates.JahiaTemplateManagerService;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.Patterns;
import org.jahia.utils.ScriptEngineUtils;
import org.jahia.utils.WebUtils;
import org.jahia.utils.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationListener;

public class StaticAssetsFilter
extends AbstractFilter
implements ApplicationListener<JahiaTemplateManagerService.TemplatePackageRedeployedEvent>,
InitializingBean {
    private static final Transformer LOW_CASE_TRANSFORMER = new Transformer(){

        public Object transform(Object input) {
            return input != null ? input.toString().toLowerCase() : null;
        }
    };
    private static final Pattern CLEANUP_REGEXP = Pattern.compile("<!-- jahia:temp value=\".*?\" -->");
    private static final FastHashMap RANK;
    private static final Pattern URL_PATTERN_1;
    private static final Pattern URL_PATTERN_2;
    private static final Pattern URL_PATTERN_3;
    private static final Pattern URL_PATTERN_4;
    private String jahiaContext = null;
    private boolean addLastModifiedDate = false;
    private static final Comparator<String> ASSET_COMPARATOR;
    private static Logger logger;
    private String ajaxResolvedTemplate;
    private String ajaxTemplate;
    private String ajaxTemplateExtension;
    private String ckeditorJavaScript = "/modules/ckeditor/javascript/ckeditor.js";
    private String resolvedTemplate;
    private ScriptEngineUtils scriptEngineUtils;
    private String template;
    private String templateExtension;
    private boolean aggregateAndCompress;
    private List<String> excludesFromAggregateAndCompress = new ArrayList<String>();
    private Set<String> ieHeaderRecognitions = new HashSet<String>();
    private String ieCompatibilityContent = "IE=8";

    @Override
    public String execute(String previousOut, RenderContext renderContext, Resource resource, RenderChain chain) throws Exception {
        String out = previousOut;
        Source source = new Source((CharSequence)previousOut);
        SortedMap assets = LazySortedMap.decorate((SortedMap)TransformedSortedMap.decorate(new TreeMap(ASSET_COMPARATOR), (Transformer)LOW_CASE_TRANSFORMER, (Transformer)NOPTransformer.INSTANCE), (Factory)new AssetsMapFactory());
        List esiResourceTags = source.getAllStartTags("jahia:resource");
        HashSet<String> keys = new HashSet<String>();
        for (StartTag esiResourceTag : esiResourceTags) {
            LinkedHashMap<String, HashMap<String, String>> my;
            LinkedHashMap<String, HashMap<String, String>> stringMap;
            String type = esiResourceTag.getAttributeValue("type");
            String path = esiResourceTag.getAttributeValue("path");
            String rel = esiResourceTag.getAttributeValue("rel");
            String media = esiResourceTag.getAttributeValue("media");
            String condition = esiResourceTag.getAttributeValue("condition");
            path = URLDecoder.decode(path, "UTF-8");
            Boolean insert = Boolean.parseBoolean(esiResourceTag.getAttributeValue("insert"));
            String title = esiResourceTag.getAttributeValue("title");
            String key = esiResourceTag.getAttributeValue("key");
            HashMap<String, String> optionsMap = new HashMap<String, String>();
            if (title != null && !"".equals(title.trim())) {
                optionsMap.put("title", title);
            }
            if (rel != null && !"".equals(rel.trim())) {
                optionsMap.put("rel", rel);
            }
            if (media != null && !"".equals(media.trim())) {
                optionsMap.put("media", media);
            }
            if (condition != null && !"".equals(condition.trim())) {
                optionsMap.put("condition", condition);
            }
            if ((stringMap = (LinkedHashMap<String, HashMap<String, String>>)assets.get(type)) == null) {
                LinkedHashMap assetMap = new LinkedHashMap();
                stringMap = assets.put(type, assetMap);
            }
            if (insert.booleanValue()) {
                my = new LinkedHashMap<String, HashMap<String, String>>();
                my.put(path, optionsMap);
                my.putAll(stringMap);
                stringMap = my;
            } else if ("".equals(key) || !keys.contains(key)) {
                my = new LinkedHashMap();
                my.put(path, optionsMap);
                stringMap.putAll(my);
                keys.add(key);
            }
            assets.put(type, stringMap);
        }
        renderContext.getRequest().setAttribute("staticAssets", (Object)assets);
        OutputDocument outputDocument = new OutputDocument(source);
        if (renderContext.isAjaxRequest()) {
            String templateContent = this.getAjaxResolvedTemplate();
            if (templateContent != null) {
                Element element = source.getFirstElement();
                EndTag tag = element != null ? element.getEndTag() : null;
                ScriptEngine scriptEngine = this.scriptEngineUtils.scriptEngine(this.ajaxTemplateExtension);
                AssetsScriptContext scriptContext = new AssetsScriptContext();
                Bindings bindings = scriptEngine.createBindings();
                bindings.put("renderContext", (Object)renderContext);
                bindings.put("resource", (Object)resource);
                scriptContext.setBindings(bindings, 200);
                bindings.put("out", (Object)new PrintWriter(scriptContext.getWriter()));
                scriptEngine.eval(templateContent, (ScriptContext)scriptContext);
                StringWriter writer = (StringWriter)scriptContext.getWriter();
                String staticsAsset = writer.toString();
                if (StringUtils.isNotBlank((String)staticsAsset)) {
                    if (tag != null) {
                        outputDocument.replace(tag.getBegin(), tag.getBegin() + 1, (CharSequence)("\n" + staticsAsset + "\n<"));
                        out = outputDocument.toString();
                    } else {
                        out = staticsAsset + "\n" + previousOut;
                    }
                }
            }
        } else if (resource.getContextConfiguration().equals("page")) {
            if (renderContext.isEditMode() && renderContext.getServletPath().endsWith("frame")) {
                List bodyElementList;
                boolean doParse = true;
                if (renderContext.getEditModeConfig().getSkipMainModuleTypesDomParsing() != null) {
                    for (String nt : renderContext.getEditModeConfig().getSkipMainModuleTypesDomParsing()) {
                        doParse = !resource.getNode().isNodeType(nt);
                        if (doParse) continue;
                        break;
                    }
                }
                if ((bodyElementList = source.getAllElements("body")).size() > 0) {
                    Element bodyElement = (Element)bodyElementList.get(bodyElementList.size() - 1);
                    EndTag bodyEndTag = bodyElement.getEndTag();
                    outputDocument.replace(bodyEndTag.getBegin(), bodyEndTag.getBegin() + 1, (CharSequence)"</div><");
                    bodyElement = (Element)bodyElementList.get(0);
                    StartTag bodyStartTag = bodyElement.getStartTag();
                    outputDocument.replace(bodyStartTag.getEnd(), bodyStartTag.getEnd(), (CharSequence)("\n<div jahiatype=\"mainmodule\" path=\"" + resource.getNode().getPath() + "\" locale=\"" + resource.getLocale() + "\"" + " template=\"" + resource.getResolvedTemplate() + "\"" + " nodetypes=\"" + ConstraintsHelper.getConstraints(renderContext.getMainResource().getNode()) + "\"" + ">"));
                    if (doParse) {
                        outputDocument.replace(bodyStartTag.getEnd() - 1, bodyStartTag.getEnd(), (CharSequence)" jahia-parse-html=\"true\">");
                    }
                }
            }
            List headElementList = source.getAllElements("head");
            for (Element element : headElementList) {
                String templateContent = this.getResolvedTemplate();
                if (templateContent != null) {
                    EndTag headEndTag = element.getEndTag();
                    ScriptEngine scriptEngine = this.scriptEngineUtils.scriptEngine(this.templateExtension);
                    AssetsScriptContext scriptContext = new AssetsScriptContext();
                    Bindings bindings = scriptEngine.createBindings();
                    bindings.put("contextJsParameters", this.getContextJsParameters(assets, renderContext));
                    if (this.aggregateAndCompress && resource.getWorkspace().equals("live")) {
                        assets.put("css", this.aggregate((Map)assets.get("css"), "css"));
                        LinkedHashMap scripts = new LinkedHashMap((Map)assets.get("javascript"));
                        Map<String, Map<String, String>> newScripts = this.aggregate((Map)assets.get("javascript"), "js");
                        assets.put("javascript", newScripts);
                        scripts.keySet().removeAll(newScripts.keySet());
                        assets.put("aggregatedjavascript", scripts);
                    } else if (this.addLastModifiedDate) {
                        this.addLastModified(assets);
                    }
                    bindings.put("renderContext", (Object)renderContext);
                    bindings.put("resource", (Object)resource);
                    bindings.put("contextPath", (Object)renderContext.getRequest().getContextPath());
                    scriptContext.setBindings(bindings, 200);
                    bindings.put("out", (Object)new PrintWriter(scriptContext.getWriter()));
                    scriptEngine.eval(templateContent, (ScriptContext)scriptContext);
                    StringWriter writer = (StringWriter)scriptContext.getWriter();
                    String staticsAsset = writer.toString();
                    if (StringUtils.isNotBlank((String)staticsAsset)) {
                        outputDocument.replace(headEndTag.getBegin(), headEndTag.getBegin() + 1, (CharSequence)("\n" + AggregateCacheFilter.removeCacheTags(staticsAsset) + "\n<"));
                    }
                }
                if (this.isEnforceIECompatibilityMode(renderContext)) {
                    int idx = element.getBegin() + element.toString().indexOf(">");
                    String str = ">\n<meta http-equiv=\"X-UA-Compatible\" content=\"" + SettingsBean.getInstance().getInternetExplorerCompatibility() + "\"/>";
                    outputDocument.replace(idx, idx + 1, (CharSequence)str);
                }
                if (!renderContext.isPreviewMode() || Boolean.valueOf((String)renderContext.getRequest().getAttribute("org.jahia.StaticAssetFilter.doNotModifyDocumentTitle")).booleanValue()) continue;
                for (Element title : element.getAllElements("title")) {
                    int idx = title.getBegin() + title.toString().indexOf(">");
                    String str = Messages.getInternal("label.preview", renderContext.getUILocale());
                    str = ">" + str + " - ";
                    outputDocument.replace(idx, idx + 1, (CharSequence)str);
                }
            }
            out = outputDocument.toString();
        }
        source = new Source((CharSequence)out);
        esiResourceTags = new Source((CharSequence)out).getAllStartTags("jahia:resource");
        outputDocument = new OutputDocument(source);
        for (StartTag segment : esiResourceTags) {
            outputDocument.replace((Segment)segment, (CharSequence)"");
        }
        String s = outputDocument.toString();
        s = StaticAssetsFilter.removeTempTags(s);
        return s.trim();
    }

    private void addLastModified(Map<String, Map<String, Map<String, String>>> assets) throws IOException {
        for (Map.Entry<String, Map<String, Map<String, String>>> assetsEntry : assets.entrySet()) {
            if (!assetsEntry.getKey().equals("css") && !assetsEntry.getKey().equals("javascript")) continue;
            LinkedHashMap<String, Map<String, String>> newMap = new LinkedHashMap<String, Map<String, String>>();
            for (Map.Entry<String, Map<String, String>> entry : assetsEntry.getValue().entrySet()) {
                org.springframework.core.io.Resource r = this.getResource(this.getKey(entry.getKey()));
                if (r != null) {
                    newMap.put(entry.getKey() + "?" + r.lastModified(), entry.getValue());
                    continue;
                }
                newMap.put(entry.getKey(), entry.getValue());
            }
            assetsEntry.getValue().clear();
            assetsEntry.getValue().putAll(newMap);
        }
    }

    private Object getContextJsParameters(Map<String, Map<String, Map<String, String>>> assets, RenderContext ctx) {
        String customCkeditorConfig;
        StringBuilder params = new StringBuilder(128);
        params.append("{contextPath:\"").append(ctx.getRequest().getContextPath()).append("\",lang:\"").append(ctx.getMainResourceLocale()).append("\",uilang:\"").append(ctx.getUILocale());
        try {
            params.append("\",siteUuid:\"").append(ctx.getSite() != null ? ctx.getSite().getIdentifier() : "''");
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        params.append("\",wcag:").append(ctx.getSiteInfo() != null ? Boolean.valueOf(ctx.getSiteInfo().isWCAGComplianceCheckEnabled()) : "false");
        Map<String, Map<String, String>> js = assets.get("javascript");
        if (js != null && js.containsKey(this.ckeditorJavaScript) && (customCkeditorConfig = GWTInitializer.getCustomCKEditorConfig(ctx)) != null) {
            params.append(",ckeCfg:\"").append(customCkeditorConfig).append("\"");
        }
        params.append(",ckeCfg:\"\"}");
        return params.toString();
    }

    private boolean isEnforceIECompatibilityMode(RenderContext renderContext) {
        if (!renderContext.isEditMode()) {
            return false;
        }
        String header = renderContext.getRequest().getHeader("user-agent");
        if (header == null || header.length() == 0) {
            return false;
        }
        header = header.toLowerCase();
        for (String ieHeaderRecognition : this.getIeHeaderRecognitions()) {
            if (!header.contains(ieHeaderRecognition)) continue;
            return true;
        }
        return false;
    }

    public static String removeTempTags(String content) {
        if (StringUtils.isNotEmpty((String)content)) {
            return CLEANUP_REGEXP.matcher(content).replaceAll("");
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Map<String, String>> aggregate(Map<String, Map<String, String>> map, String type) throws IOException {
        ArrayList<Map.Entry<String, Map<String, String>>> entries = new ArrayList<Map.Entry<String, Map<String, String>>>(map.entrySet());
        LinkedHashMap<String, Map<String, String>> newCss = new LinkedHashMap<String, Map<String, String>>();
        int i = 0;
        while (i < entries.size()) {
            org.springframework.core.io.Resource r;
            long filesDates = 0L;
            LinkedHashMap<String, org.springframework.core.io.Resource> pathsToAggregate = new LinkedHashMap<String, org.springframework.core.io.Resource>();
            while (i < entries.size()) {
                Map.Entry entry = (Map.Entry)entries.get(i);
                String key = this.getKey((String)entry.getKey());
                org.springframework.core.io.Resource r2 = this.getResource(key);
                if (!((Map)entry.getValue()).isEmpty() || this.excludesFromAggregateAndCompress.contains(key) || r2 == null || !r2.exists()) break;
                pathsToAggregate.put(key, r2);
                long lastModified = r2.lastModified();
                if (filesDates < lastModified) {
                    filesDates = lastModified;
                }
                ++i;
            }
            if (!pathsToAggregate.isEmpty()) {
                String ctx;
                File minifiedAggregatedFile;
                String aggregatedKey = this.generateAggregateName(pathsToAggregate.keySet());
                String minifiedAggregatedPath = "/generated-resources/" + aggregatedKey + ".min." + type;
                String minifiedAggregatedRealPath = this.getFileSystemPath(minifiedAggregatedPath);
                if (this.addLastModifiedDate) {
                    minifiedAggregatedPath = minifiedAggregatedPath + "?" + filesDates;
                }
                if (!(minifiedAggregatedFile = new File(minifiedAggregatedRealPath)).exists() || minifiedAggregatedFile.lastModified() < filesDates) {
                    new File(this.getFileSystemPath("/generated-resources")).mkdirs();
                    LinkedHashMap<String, String> minifiedPaths = new LinkedHashMap<String, String>();
                    for (Map.Entry entry : pathsToAggregate.entrySet()) {
                        String path = (String)entry.getKey();
                        String minifiedPath = "/generated-resources/" + Patterns.SLASH.matcher(path).replaceAll("_") + ".min." + type;
                        File minifiedFile = new File(this.getFileSystemPath(minifiedPath));
                        org.springframework.core.io.Resource f = (org.springframework.core.io.Resource)entry.getValue();
                        if (!minifiedFile.exists() || minifiedFile.lastModified() < f.lastModified()) {
                            CssCompressor compressor;
                            InputStreamReader reader = new InputStreamReader(f.getInputStream(), "UTF-8");
                            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.getFileSystemPath(minifiedPath)), "UTF-8");
                            boolean compress = true;
                            if (compress && type.equals("css")) {
                                compressor = new CssCompressor((Reader)reader);
                                compressor.compress((Writer)writer, -1);
                            } else if (compress && type.equals("js")) {
                                compressor = null;
                                try {
                                    compressor = new JavaScriptCompressor((Reader)reader, new ErrorReporter(){

                                        public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
                                            if (!logger.isDebugEnabled()) {
                                                return;
                                            }
                                            if (line < 0) {
                                                logger.debug(message);
                                            } else {
                                                logger.debug(line + ":" + lineOffset + ":" + message);
                                            }
                                        }

                                        public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
                                            if (line < 0) {
                                                logger.error(message);
                                            } else {
                                                logger.error(line + ":" + lineOffset + ":" + message);
                                            }
                                        }

                                        public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
                                            this.error(message, sourceName, line, lineSource, lineOffset);
                                            return new EvaluatorException(message);
                                        }
                                    });
                                    compressor.compress((Writer)writer, -1, true, true, false, false);
                                }
                                catch (EvaluatorException e) {
                                    logger.error("Error when minifying " + path, (Throwable)e);
                                    IOUtils.closeQuietly((Reader)reader);
                                    IOUtils.closeQuietly((Writer)writer);
                                    reader = new InputStreamReader(f.getInputStream(), "UTF-8");
                                    writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.getFileSystemPath(minifiedPath)), "UTF-8");
                                    IOUtils.copy((Reader)reader, (Writer)writer);
                                }
                            } else {
                                BufferedWriter bw = new BufferedWriter(writer);
                                BufferedReader br = new BufferedReader(reader);
                                String s = null;
                                while ((s = br.readLine()) != null) {
                                    bw.write(s);
                                    bw.write("\n");
                                }
                                IOUtils.closeQuietly((Writer)bw);
                                IOUtils.closeQuietly((Reader)br);
                            }
                            IOUtils.closeQuietly((Reader)reader);
                            IOUtils.closeQuietly((Writer)writer);
                        }
                        minifiedPaths.put(path, minifiedPath);
                    }
                    try {
                        BufferedOutputStream outMerged = new BufferedOutputStream(new FileOutputStream(minifiedAggregatedRealPath));
                        try {
                            for (Map.Entry entry : minifiedPaths.entrySet()) {
                                if (type.equals("js")) {
                                    ((OutputStream)outMerged).write("//".getBytes());
                                    ((OutputStream)outMerged).write(((String)entry.getValue()).getBytes());
                                    ((OutputStream)outMerged).write("\n".getBytes());
                                }
                                InputStream is = new FileInputStream(this.getFileSystemPath((String)entry.getValue()));
                                if (type.equals("css")) {
                                    ByteArrayOutputStream stream = new ByteArrayOutputStream();
                                    IOUtils.copy((InputStream)is, (OutputStream)stream);
                                    IOUtils.closeQuietly((InputStream)is);
                                    String s = stream.toString("UTF-8");
                                    String url = StringUtils.substringBeforeLast((String)((String)entry.getKey()), (String)"/") + "/";
                                    s = URL_PATTERN_1.matcher(s).replaceAll("url(");
                                    s = URL_PATTERN_2.matcher(s).replaceAll("url(\".." + url);
                                    s = URL_PATTERN_3.matcher(s).replaceAll("url('.." + url);
                                    s = URL_PATTERN_4.matcher(s).replaceAll("url(.." + url);
                                    is = new ByteArrayInputStream(s.getBytes("UTF-8"));
                                }
                                IOUtils.copy((InputStream)is, (OutputStream)outMerged);
                                if (type.equals("js")) {
                                    ((OutputStream)outMerged).write(";\n".getBytes());
                                }
                                IOUtils.closeQuietly((InputStream)is);
                            }
                        }
                        finally {
                            IOUtils.closeQuietly((OutputStream)outMerged);
                        }
                    }
                    catch (IOException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
                newCss.put((ctx = Jahia.getContextPath()).length() > 0 ? ctx + minifiedAggregatedPath : minifiedAggregatedPath, new HashMap());
            }
            if (i >= entries.size()) continue;
            if (this.addLastModifiedDate && (r = this.getResource(this.getKey((String)((Map.Entry)entries.get(i)).getKey()))) != null) {
                newCss.put((String)((Map.Entry)entries.get(i)).getKey() + "?lastModified=" + r.lastModified(), (Map<String, String>)((Map.Entry)entries.get(i)).getValue());
            } else {
                newCss.put((String)((Map.Entry)entries.get(i)).getKey(), (Map<String, String>)((Map.Entry)entries.get(i)).getValue());
            }
            ++i;
        }
        return newCss;
    }

    private String getKey(String key) {
        if (Jahia.getContextPath().length() > 0 && key.startsWith(this.jahiaContext)) {
            key = key.substring(Jahia.getContextPath().length());
        }
        return key;
    }

    private org.springframework.core.io.Resource getResource(String key) {
        org.springframework.core.io.Resource r = null;
        String filePath = StringUtils.substringAfter((String)key.substring(1), (String)"/");
        String moduleId = StringUtils.substringBefore((String)filePath, (String)"/");
        filePath = StringUtils.substringAfter((String)filePath, (String)"/");
        if (key.startsWith("/modules/")) {
            r = ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackageById(moduleId).getResource(filePath);
        } else if (key.startsWith("/files/")) {
            r = this.getResourceFromFile(r, moduleId, "/" + filePath);
        }
        return r;
    }

    private String getFileSystemPath(String minifiedAggregatedPath) {
        return SettingsBean.getInstance().getJahiaVarDiskPath() + minifiedAggregatedPath;
    }

    private org.springframework.core.io.Resource getResourceFromFile(org.springframework.core.io.Resource r, String workspace, String fFilePath) {
        try {
            final JCRNodeWrapper contentNode = JCRSessionFactory.getInstance().getCurrentUserSession(workspace).getNode(fFilePath);
            r = new org.springframework.core.io.Resource(){

                public boolean exists() {
                    return true;
                }

                public boolean isReadable() {
                    return false;
                }

                public boolean isOpen() {
                    return false;
                }

                public URL getURL() throws IOException {
                    return null;
                }

                public URI getURI() throws IOException {
                    return null;
                }

                public File getFile() throws IOException {
                    return null;
                }

                public long contentLength() throws IOException {
                    return contentNode.getFileContent().getContentLength();
                }

                public long lastModified() throws IOException {
                    return contentNode.getLastModifiedAsDate().getTime();
                }

                public org.springframework.core.io.Resource createRelative(String relativePath) throws IOException {
                    return null;
                }

                public String getFilename() {
                    return contentNode.getName();
                }

                public String getDescription() {
                    return null;
                }

                public InputStream getInputStream() throws IOException {
                    return contentNode.getFileContent().downloadFile();
                }
            };
        }
        catch (RepositoryException e) {
            // empty catch block
        }
        return r;
    }

    public String generateAggregateName(Collection<String> m) {
        StringBuilder sb = new StringBuilder();
        for (String s1 : m) {
            sb.append(s1);
        }
        try {
            MessageDigest digester = MessageDigest.getInstance("MD5");
            byte[] digest = digester.digest(sb.toString().getBytes("UTF-8"));
            StringBuilder hexString = new StringBuilder();
            for (byte aDigest : digest) {
                hexString.append(Integer.toHexString(0xFF & aDigest));
            }
            return hexString.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String getAjaxResolvedTemplate() throws IOException {
        if (this.ajaxResolvedTemplate == null) {
            this.ajaxResolvedTemplate = WebUtils.getResourceAsString(this.ajaxTemplate);
            if (this.ajaxResolvedTemplate == null) {
                logger.warn("Unable to lookup template at {}", (Object)this.ajaxTemplate);
            }
        }
        return this.ajaxResolvedTemplate;
    }

    protected String getResolvedTemplate() throws IOException {
        if (this.resolvedTemplate == null) {
            this.resolvedTemplate = WebUtils.getResourceAsString(this.template);
            if (this.resolvedTemplate == null) {
                logger.warn("Unable to lookup template at {}", (Object)this.template);
            }
        }
        return this.resolvedTemplate;
    }

    public void setAjaxTemplate(String ajaxTemplate) {
        this.ajaxTemplate = ajaxTemplate;
        if (ajaxTemplate != null) {
            this.ajaxTemplateExtension = StringUtils.substringAfterLast((String)ajaxTemplate, (String)".");
        }
    }

    public void setScriptEngineUtils(ScriptEngineUtils scriptEngineUtils) {
        this.scriptEngineUtils = scriptEngineUtils;
    }

    public void setTemplate(String template) {
        this.template = template;
        if (template != null) {
            this.templateExtension = StringUtils.substringAfterLast((String)template, (String)".");
        }
    }

    public void setAggregateAndCompress(boolean aggregateAndCompress) {
        this.aggregateAndCompress = aggregateAndCompress;
    }

    public void setExcludesFromAggregateAndCompress(List<String> skipAggregation) {
        this.excludesFromAggregateAndCompress = skipAggregation;
    }

    public void onApplicationEvent(JahiaTemplateManagerService.TemplatePackageRedeployedEvent event) {
        this.ajaxResolvedTemplate = null;
        this.resolvedTemplate = null;
    }

    public void afterPropertiesSet() throws Exception {
        this.jahiaContext = Jahia.getContextPath() + "/";
    }

    public Set<String> getIeHeaderRecognitions() {
        return this.ieHeaderRecognitions;
    }

    public void setIeHeaderRecognitions(Set<String> ieHeaderRecognitions) {
        this.ieHeaderRecognitions = ieHeaderRecognitions;
    }

    public String getIeCompatibilityContent() {
        return this.ieCompatibilityContent;
    }

    public void setIeCompatibilityContent(String ieCompatibilityContent) {
        this.ieCompatibilityContent = ieCompatibilityContent;
    }

    public void setCkeditorJavaScript(String ckeditorJavaScript) {
        this.ckeditorJavaScript = ckeditorJavaScript;
    }

    public void setAddLastModifiedDate(boolean addLastModifiedDate) {
        this.addLastModifiedDate = addLastModifiedDate;
    }

    static {
        URL_PATTERN_1 = Pattern.compile("url\\( ");
        URL_PATTERN_2 = Pattern.compile("url\\(\"(?!(/|http:|https:|data:))");
        URL_PATTERN_3 = Pattern.compile("url\\('(?!(/|http:|https:|data:))");
        URL_PATTERN_4 = Pattern.compile("url\\((?!(/|'|\"|http:|https:|data:))");
        RANK = new FastHashMap();
        RANK.put((Object)"inlinebefore", (Object)0);
        RANK.put((Object)"css", (Object)1);
        RANK.put((Object)"inlinecss", (Object)2);
        RANK.put((Object)"javascript", (Object)3);
        RANK.put((Object)"inlinejavascript", (Object)4);
        RANK.put((Object)"inline", (Object)5);
        RANK.put((Object)"unknown", (Object)6);
        RANK.setFast(true);
        ASSET_COMPARATOR = ComparatorUtils.transformedComparator(null, (Transformer)new Transformer(){

            public Object transform(Object input) {
                Object rank = null;
                if (input != null) {
                    rank = (Integer)RANK.get((Object)input.toString());
                }
                return rank != null ? rank : RANK.get((Object)"unknown");
            }
        });
        logger = LoggerFactory.getLogger(StaticAssetsFilter.class);
    }

    class AssetsScriptContext
    extends SimpleScriptContext {
        private Writer writer = null;

        AssetsScriptContext() {
        }

        @Override
        public Writer getWriter() {
            if (this.writer == null) {
                this.writer = new StringWriter();
            }
            return this.writer;
        }
    }
}

