/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render.filter.cache;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.query.QueryResult;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.cache.ehcache.EhCacheProvider;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.JCRValueWrapper;
import org.jahia.services.query.QueryWrapper;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.filter.cache.CacheKeyPartGenerator;
import org.jahia.services.usermanager.JahiaGroup;
import org.jahia.services.usermanager.JahiaGroupManagerService;
import org.jahia.services.usermanager.JahiaUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class AclCacheKeyPartGenerator
implements CacheKeyPartGenerator,
InitializingBean {
    public static final String PER_USER = "_perUser_";
    public static final String MR_ACL = "_mraclmr_";
    public static final String LOGGED_USER = "_logged_";
    public static final Pattern P_PATTERN = Pattern.compile("_p_");
    public static final Pattern DEP_ACLS_PATTERN = Pattern.compile("_depacl_");
    public static final Pattern ACLS_PATH_PATTERN = Pattern.compile("_p_");
    private static final Logger logger = LoggerFactory.getLogger(AclCacheKeyPartGenerator.class);
    private static final String CACHE_NAME = "HTMLNodeUsersACLs";
    private static final String PROPERTY_CACHE_NAME = "HTMLRequiredPermissionsCache";
    private final Object objForSync = new Object();
    private EhCacheProvider cacheProvider;
    private Cache cache;
    private JahiaGroupManagerService groupManagerService;
    private Cache permissionCache;
    private JCRTemplate template;
    private final ConcurrentMap<String, Semaphore> processings = new ConcurrentHashMap<String, Semaphore>();

    public void setGroupManagerService(JahiaGroupManagerService groupManagerService) {
        this.groupManagerService = groupManagerService;
    }

    public void setCacheProvider(EhCacheProvider cacheProvider) {
        this.cacheProvider = cacheProvider;
    }

    public void setTemplate(JCRTemplate template) {
        this.template = template;
    }

    public void afterPropertiesSet() throws Exception {
        CacheManager cacheManager = this.cacheProvider.getCacheManager();
        this.cache = cacheManager.getCache(CACHE_NAME);
        if (this.cache == null) {
            cacheManager.addCache(CACHE_NAME);
            this.cache = cacheManager.getCache(CACHE_NAME);
        }
        this.permissionCache = cacheManager.getCache(PROPERTY_CACHE_NAME);
        if (this.permissionCache == null) {
            cacheManager.addCache(PROPERTY_CACHE_NAME);
            this.permissionCache = cacheManager.getCache(PROPERTY_CACHE_NAME);
        }
    }

    @Override
    public String getKey() {
        return "acls";
    }

    @Override
    public String getValue(Resource resource, RenderContext renderContext, Properties properties) {
        try {
            Boolean[] values;
            Element element;
            if ("true".equals(properties.get("cache.perUser"))) {
                return PER_USER;
            }
            JCRNodeWrapper node = resource.getNode();
            String nodePath = node.getPath();
            TreeSet<String> aclsKeys = new TreeSet<String>();
            aclsKeys.add(URLEncoder.encode(nodePath, "UTF-8"));
            String s = (String)properties.get("cache.dependsOnVisibilityOf");
            if (s != null) {
                String[] dependencies = s.split(",");
                for (int i = 0; i < dependencies.length; ++i) {
                    String dep = dependencies[i];
                    dep = dep.replace("$currentNode", nodePath);
                    dep = dep.replace("$currentSite", renderContext.getSite().getPath());
                    dep = dep.replace("$mainResource", renderContext.getMainResource().getNode().getPath());
                    aclsKeys.add("*" + URLEncoder.encode(dep, "UTF-8"));
                }
            }
            if ((element = this.permissionCache.get((Serializable)((Object)node.getPath()))) != null && element.getObjectValue() != null) {
                values = (Boolean[])element.getObjectValue();
            } else {
                values = new Boolean[]{node.hasProperty("j:requiredPermissionNames") || node.hasProperty("j:requiredPermissions"), node.hasProperty("j:requirePrivilegedUser") && node.getProperty("j:requirePrivilegedUser").getBoolean(), node.hasProperty("j:requireLoggedUser") && node.getProperty("j:requireLoggedUser").getBoolean()};
                this.permissionCache.put(new Element((Serializable)((Object)node.getPath()), (Serializable)values));
            }
            if ("true".equals(properties.get("cache.mainResource"))) {
                aclsKeys.add(MR_ACL);
            } else if (values[0].booleanValue()) {
                aclsKeys.add(MR_ACL);
            }
            if (values[1].booleanValue()) {
                aclsKeys.add(renderContext.getSite().getPath());
            }
            if (values[2].booleanValue() || "true".equals(properties.get("cache.useLoggedInState"))) {
                aclsKeys.add(LOGGED_USER);
            }
            return StringUtils.join(aclsKeys, (String)",");
        }
        catch (UnsupportedEncodingException e) {
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return "";
    }

    @Override
    public String replacePlaceholders(RenderContext renderContext, String keyPart) {
        if (keyPart.equals(PER_USER)) {
            keyPart = renderContext.getUser().getUsername();
        } else {
            String[] paths = keyPart.split(",");
            TreeSet<String> aclKeys = new TreeSet<String>();
            for (String s : paths) {
                try {
                    if (s.equals(MR_ACL)) {
                        aclKeys.add(this.getAclKeyPartForNode(renderContext, renderContext.getMainResource().getNode().getPath(), renderContext.getUser(), new HashSet<String>(), false));
                        continue;
                    }
                    if (s.equals(LOGGED_USER)) {
                        aclKeys.add(Boolean.toString(renderContext.getUser().getUsername().equals("guest")));
                        continue;
                    }
                    if (s.startsWith("*")) {
                        aclKeys.add(this.getAclKeyPartForNode(renderContext, URLDecoder.decode(s.substring(1), "UTF-8"), renderContext.getUser(), new HashSet<String>(), true));
                        continue;
                    }
                    aclKeys.add(this.getAclKeyPartForNode(renderContext, URLDecoder.decode(s, "UTF-8"), renderContext.getUser(), new HashSet<String>(), false));
                }
                catch (UnsupportedEncodingException e) {
                }
                catch (RepositoryException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            keyPart = StringUtils.join(aclKeys, (String)"|");
        }
        return keyPart;
    }

    public String getAclKeyPartForNode(RenderContext renderContext, String nodePath, JahiaUser principal, Set<String> aclPathChecked, boolean regexp) throws RepositoryException {
        ArrayList<Map<String, Set<String>>> l = new ArrayList<Map<String, Set<String>>>();
        l.add(this.getPrincipalAcl("u:" + principal.getName(), 0));
        List<String> groups = this.groupManagerService.getUserMembership(principal);
        for (String group : groups) {
            JahiaGroup jahiaGroup = this.groupManagerService.lookupGroup(group);
            l.add(this.getPrincipalAcl("g:" + jahiaGroup.getName(), jahiaGroup.getSiteID()));
        }
        TreeMap rolesForKey = new TreeMap();
        if (!regexp) {
            nodePath = nodePath + "/";
            for (Map map : l) {
                for (Map.Entry entry : map.entrySet()) {
                    String grantPath = (String)entry.getKey() + "/";
                    if (!nodePath.startsWith(grantPath) && !grantPath.startsWith(nodePath) || aclPathChecked.contains(entry.getKey())) continue;
                    Set roles = (Set)entry.getValue();
                    if (!rolesForKey.containsKey(entry.getKey())) {
                        rolesForKey.put(entry.getKey(), new TreeSet(roles));
                        continue;
                    }
                    ((Set)rolesForKey.get(entry.getKey())).addAll(roles);
                }
            }
        } else {
            Pattern p = Pattern.compile(nodePath);
            for (Map map : l) {
                for (Map.Entry entry : map.entrySet()) {
                    String grantPath = (String)entry.getKey();
                    if (!p.matcher(grantPath).matches()) continue;
                    Set roles = (Set)entry.getValue();
                    if (!rolesForKey.containsKey(entry.getKey())) {
                        rolesForKey.put(entry.getKey(), new TreeSet(roles));
                        continue;
                    }
                    ((Set)rolesForKey.get(entry.getKey())).addAll(roles);
                }
            }
        }
        aclPathChecked.addAll(rolesForKey.keySet());
        StringBuilder r = new StringBuilder();
        for (Map.Entry entry : rolesForKey.entrySet()) {
            try {
                r.append(URLEncoder.encode(StringUtils.join((Collection)((Collection)entry.getValue()), (String)","), "UTF-8") + ":" + URLEncoder.encode((String)entry.getKey(), "UTF-8") + "|");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return r.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Set<String>> getPrincipalAcl(final String key, final int siteId) throws RepositoryException {
        String cacheKey = key + ":" + siteId;
        Element element = this.cache.get((Serializable)((Object)cacheKey));
        if (element == null) {
            Semaphore semaphore = (Semaphore)this.processings.get(cacheKey);
            if (semaphore == null) {
                semaphore = new Semaphore(1);
                this.processings.putIfAbsent(cacheKey, semaphore);
            }
            try {
                semaphore.tryAcquire(500L, TimeUnit.MILLISECONDS);
                element = this.cache.get((Serializable)((Object)cacheKey));
                if (element != null) {
                    Map map = (Map)element.getObjectValue();
                    return map;
                }
                logger.debug("Getting ACL for " + cacheKey);
                long l = System.currentTimeMillis();
                Map<String, Set<String>> map = this.template.doExecuteWithSystemSession(null, "live", new JCRCallback<Map<String, Set<String>>>(){

                    @Override
                    public Map<String, Set<String>> doInJCR(JCRSessionWrapper session) throws RepositoryException {
                        QueryWrapper query = session.getWorkspace().getQueryManager().createQuery("select * from [jnt:ace] as ace where ace.[j:principal] = '" + key + "'", "JCR-SQL2");
                        QueryResult queryResult = query.execute();
                        NodeIterator rowIterator = queryResult.getNodes();
                        ConcurrentHashMap<String, Set<String>> mapGranted = new ConcurrentHashMap<String, Set<String>>();
                        LinkedHashMap mapDenied = new LinkedHashMap();
                        while (rowIterator.hasNext()) {
                            JCRValueWrapper[] roles;
                            JCRNodeWrapper node = (JCRNodeWrapper)rowIterator.next();
                            if (key.startsWith("g:") && siteId != node.getResolveSite().getID() && (!node.getResolveSite().getSiteKey().equals("systemsite") || siteId != 0)) continue;
                            String path = node.getParent().getParent().getPath();
                            if (path.startsWith("/sites/")) {
                                // empty if block
                            }
                            HashSet<String> foundRoles = new HashSet<String>();
                            boolean granted = node.getProperty("j:aceType").getString().equals("GRANT");
                            for (JCRValueWrapper r : roles = node.getProperty("j:roles").getValues()) {
                                String role = r.getString();
                                if (foundRoles.contains(role)) continue;
                                foundRoles.add(role);
                            }
                            if (path.equals("/")) {
                                path = "";
                            }
                            if (granted) {
                                mapGranted.put(path, foundRoles);
                                continue;
                            }
                            mapDenied.put(path, foundRoles);
                        }
                        Iterator i$ = mapDenied.keySet().iterator();
                        while (i$.hasNext()) {
                            String deniedPath;
                            String grantedPath = deniedPath = (String)i$.next();
                            while (grantedPath.length() > 0) {
                                if (!mapGranted.containsKey(grantedPath = StringUtils.substringBeforeLast((String)grantedPath, (String)"/"))) continue;
                                Collection intersection = CollectionUtils.intersection((Collection)((Collection)mapGranted.get(grantedPath)), (Collection)((Collection)mapDenied.get(deniedPath)));
                                ((Set)mapGranted.get(grantedPath)).removeAll(intersection);
                                for (String s : intersection) {
                                    ((Set)mapGranted.get(grantedPath)).add(s + " -> " + deniedPath);
                                }
                            }
                        }
                        return mapGranted;
                    }
                });
                element = new Element((Object)cacheKey, map);
                element.setEternal(true);
                this.cache.put(element);
                logger.debug("Getting ACL for " + cacheKey + " took " + (System.currentTimeMillis() - l) + "ms");
            }
            catch (InterruptedException e) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            finally {
                semaphore.release();
            }
        }
        return (Map)element.getObjectValue();
    }

    public void flushUsersGroupsKey() {
        this.flushUsersGroupsKey(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushUsersGroupsKey(boolean propageToOtherClusterNodes) {
        Object object = this.objForSync;
        synchronized (object) {
            this.cache.removeAll(!propageToOtherClusterNodes);
            this.cache.flush();
            logger.debug("Flushed HTMLNodeUsersACLs cache");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushUsersGroupsKey(String key, boolean propageToOtherClusterNodes) {
        Object object = this.objForSync;
        synchronized (object) {
            this.cache.remove((Serializable)((Object)key), !propageToOtherClusterNodes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushPermissionCacheEntry(String path, boolean propageToOtherClusterNodes) {
        Object object = this.objForSync;
        synchronized (object) {
            this.permissionCache.remove((Serializable)((Object)path));
        }
    }
}

