/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render.filter.cache;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import net.htmlparser.jericho.Config;
import net.htmlparser.jericho.LoggerProvider;
import net.htmlparser.jericho.OutputDocument;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;
import net.htmlparser.jericho.Tag;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import net.sf.ehcache.constructs.blocking.LockTimeoutException;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.cache.CacheEntry;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.RenderException;
import org.jahia.services.render.RenderService;
import org.jahia.services.render.Resource;
import org.jahia.services.render.Template;
import org.jahia.services.render.TemplateNotFoundException;
import org.jahia.services.render.filter.AbstractFilter;
import org.jahia.services.render.filter.RenderChain;
import org.jahia.services.render.filter.cache.CacheKeyGenerator;
import org.jahia.services.render.filter.cache.DefaultCacheKeyGenerator;
import org.jahia.services.render.filter.cache.ModuleCacheProvider;
import org.jahia.services.render.filter.cache.ModuleGeneratorQueue;
import org.jahia.services.render.scripting.Script;
import org.jahia.services.templates.JahiaTemplateManagerService;
import org.jahia.settings.SettingsBean;
import org.jahia.tools.jvm.ThreadMonitor;
import org.jahia.utils.LanguageCodeConverters;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationListener;

public class AggregateCacheFilter
extends AbstractFilter
implements ApplicationListener<JahiaTemplateManagerService.TemplatePackageRedeployedEvent>,
InitializingBean {
    protected static transient Logger logger = LoggerFactory.getLogger(AggregateCacheFilter.class);
    protected ModuleCacheProvider cacheProvider;
    protected ModuleGeneratorQueue generatorQueue;
    public static final Pattern ESI_INCLUDE_STARTTAG_REGEXP = Pattern.compile("<!-- cache:include src=\\\"(.*)\\\" -->");
    public static final Pattern ESI_INCLUDE_STOPTAG_REGEXP = Pattern.compile("<!-- /cache:include -->");
    protected static final Pattern CLEANUP_REGEXP = Pattern.compile("<!-- cache:include src=\\\"(.*)\\\" -->\n|\n<!-- /cache:include -->");
    protected static final Map<String, Boolean> notCacheableFragment = new ConcurrentHashMap<String, Boolean>(512);
    protected static ThreadLocal<Set<CountDownLatch>> processingLatches = new ThreadLocal();
    protected static ThreadLocal<String> acquiredSemaphore = new ThreadLocal();
    protected static ThreadLocal<LinkedList<String>> userKeys = new ThreadLocal();
    protected static long lastThreadDumpTime = 0L;
    protected Byte[] threadDumpCheckLock = new Byte[0];
    protected int dependenciesLimit = 1000;
    protected boolean cascadeFragmentErrors = false;
    protected int errorCacheExpiration = 5;
    private Set<String> skipLatchForConfigurations;
    private Set<String> skipLatchForPaths;
    private Set<String> skipLatchForNodeTypes;

    public void afterPropertiesSet() throws Exception {
        Config.LoggerProvider = LoggerProvider.DISABLED;
    }

    public void setDependenciesLimit(int dependenciesLimit) {
        this.dependenciesLimit = dependenciesLimit;
    }

    public void setCacheProvider(ModuleCacheProvider cacheProvider) {
        this.cacheProvider = cacheProvider;
    }

    public void setGeneratorQueue(ModuleGeneratorQueue generatorQueue) {
        this.generatorQueue = generatorQueue;
    }

    public void setCascadeFragmentErrors(boolean cascadeFragmentErrors) {
        this.cascadeFragmentErrors = cascadeFragmentErrors;
    }

    public void setErrorCacheExpiration(int errorCacheExpiration) {
        this.errorCacheExpiration = errorCacheExpiration;
    }

    public void setSkipLatchForConfigurations(Set<String> skipLatchForConfigurations) {
        this.skipLatchForConfigurations = skipLatchForConfigurations;
    }

    public void setSkipLatchForPaths(Set<String> skipLatchForPaths) {
        this.skipLatchForPaths = skipLatchForPaths;
    }

    public void setSkipLatchForNodeTypes(Set<String> skipLatchForNodeTypes) {
        this.skipLatchForNodeTypes = skipLatchForNodeTypes;
    }

    @Override
    public String prepare(RenderContext renderContext, Resource resource, RenderChain chain) throws Exception {
        boolean debugEnabled = logger.isDebugEnabled();
        Properties properties = this.getAttributesForKey(renderContext, resource);
        Boolean forceGeneration = (Boolean)resource.getModuleParams().remove("cache.forceGeneration");
        String key = this.cacheProvider.getKeyGenerator().generate(resource, renderContext, properties);
        resource.getModuleParams().put("cacheKey", (Serializable)((Object)key));
        if (debugEnabled) {
            logger.debug("Cache filter for key with placeholders : {}", (Object)key);
        }
        if (Boolean.TRUE.equals(forceGeneration)) {
            return null;
        }
        boolean cacheable = this.isCacheable(renderContext, resource, key, properties);
        if (!cacheable) {
            return null;
        }
        String finalKey = this.replacePlaceholdersInCacheKey(renderContext, key);
        LinkedList<String> userKeysLinkedList = userKeys.get();
        if (userKeysLinkedList == null) {
            userKeysLinkedList = new LinkedList();
            userKeys.set(userKeysLinkedList);
        }
        if (userKeysLinkedList.contains(finalKey)) {
            return null;
        }
        userKeysLinkedList.add(0, finalKey);
        Element element = null;
        Cache cache = this.cacheProvider.getCache();
        try {
            if (debugEnabled) {
                logger.debug("Try to get content from cache for node with final key: {}", (Object)finalKey);
            }
            element = cache.get((Serializable)((Object)finalKey));
        }
        catch (LockTimeoutException e) {
            logger.warn("Error while rendering " + renderContext.getMainResource() + e.getMessage(), (Throwable)e);
        }
        if (element != null && element.getObjectValue() != null) {
            return this.returnFromCache(renderContext, resource, key, finalKey, element, cache);
        }
        CountDownLatch countDownLatch = this.avoidParallelProcessingOfSameModule(finalKey, renderContext.getRequest(), resource, properties);
        if (countDownLatch == null) {
            element = cache.get((Serializable)((Object)finalKey));
            if (element != null && element.getObjectValue() != null) {
                return this.returnFromCache(renderContext, resource, key, finalKey, element, cache);
            }
        } else {
            Set<CountDownLatch> latches = processingLatches.get();
            if (latches == null) {
                latches = new HashSet<CountDownLatch>();
                processingLatches.set(latches);
            }
            latches.add(countDownLatch);
        }
        return null;
    }

    protected boolean isCacheable(RenderContext renderContext, Resource resource, String key, Properties properties) throws RepositoryException {
        Long expiration;
        boolean cacheable;
        boolean bl = cacheable = !notCacheableFragment.containsKey(key);
        if (renderContext.isLoggedIn() && renderContext.getRequest().getParameter("v") != null) {
            return false;
        }
        if (renderContext.getRequest().getParameter("ec") != null) {
            if (renderContext.getRequest().getParameter("ec").equals(resource.getNode().getIdentifier())) {
                return false;
            }
            for (Resource parent : renderContext.getResourcesStack()) {
                if (!renderContext.getRequest().getParameter("ec").equals(parent.getNode().getIdentifier())) continue;
                return false;
            }
        }
        if ((expiration = Long.valueOf(properties.getProperty("cache.expiration") != null ? Long.parseLong(properties.getProperty("cache.expiration")) : -1L)) == 0L) {
            cacheable = false;
        }
        return cacheable;
    }

    protected boolean useDependencies() {
        return true;
    }

    protected String returnFromCache(RenderContext renderContext, Resource resource, String key, String finalKey, Element element, Cache cache) throws RenderException {
        boolean displayCacheInfo;
        HashSet<String> servedFromCache;
        if (logger.isDebugEnabled()) {
            logger.debug("Content retrieved from cache for node with key: {}", (Object)finalKey);
        }
        CacheEntry cacheEntry = (CacheEntry)element.getObjectValue();
        String cachedContent = (String)cacheEntry.getObject();
        cachedContent = this.aggregateContent(cache, cachedContent, renderContext, (String)cacheEntry.getProperty("areaResource"), new Stack<String>(), (Set)cacheEntry.getProperty("allPaths"));
        if (renderContext.getMainResource() == resource) {
            cachedContent = AggregateCacheFilter.removeCacheTags(cachedContent);
        }
        if ((servedFromCache = (HashSet<String>)renderContext.getRequest().getAttribute("servedFromCache")) == null) {
            servedFromCache = new HashSet<String>();
            renderContext.getRequest().setAttribute("servedFromCache", servedFromCache);
        }
        servedFromCache.add(finalKey);
        boolean bl = displayCacheInfo = SettingsBean.getInstance().isDevelopmentMode() && Boolean.valueOf(renderContext.getRequest().getParameter("cacheinfo")) != false;
        if (displayCacheInfo && !cachedContent.contains("<body") && cachedContent.trim().length() > 0) {
            return this.appendDebugInformation(renderContext, key, cachedContent, element);
        }
        return cachedContent;
    }

    @Override
    public String execute(String previousOut, RenderContext renderContext, Resource resource, RenderChain chain) throws Exception {
        Properties properties = this.getAttributesForKey(renderContext, resource);
        resource.getDependencies().add(resource.getNode().getCanonicalPath());
        if ("true".equals(properties.getProperty("cache.mainResource"))) {
            resource.getDependencies().add(renderContext.getMainResource().getNode().getCanonicalPath());
        }
        String key = (String)((Object)resource.getModuleParams().remove("cacheKey"));
        String generatedKey = this.cacheProvider.getKeyGenerator().generate(resource, renderContext, properties);
        if (!generatedKey.equals(key)) {
            logger.warn("Key generation does not give the same result after execution , was" + key + " , now is " + generatedKey);
        }
        String finalKey = this.replacePlaceholdersInCacheKey(renderContext, key);
        Set servedFromCache = (Set)renderContext.getRequest().getAttribute("servedFromCache");
        if (servedFromCache != null && servedFromCache.contains(finalKey)) {
            return previousOut;
        }
        boolean cacheable = this.isCacheable(renderContext, resource, key, properties);
        boolean debugEnabled = logger.isDebugEnabled();
        boolean displayCacheInfo = SettingsBean.getInstance().isDevelopmentMode() && Boolean.valueOf(renderContext.getRequest().getParameter("cacheinfo")) != false;
        if (cacheable) {
            Cache cache = this.cacheProvider.getCache();
            if (debugEnabled) {
                logger.debug("Caching content for final key : {}", (Object)finalKey);
            }
            this.doCache(previousOut, renderContext, resource, properties, cache, key, finalKey);
        } else {
            notCacheableFragment.put(key, Boolean.TRUE);
        }
        if (displayCacheInfo && !previousOut.contains("<body") && previousOut.trim().length() > 0) {
            return this.appendDebugInformation(renderContext, key, this.surroundWithCacheTag(key, previousOut), null);
        }
        if (renderContext.getMainResource() == resource) {
            return AggregateCacheFilter.removeCacheTags(previousOut);
        }
        return this.surroundWithCacheTag(key, previousOut);
    }

    protected void doCache(String previousOut, RenderContext renderContext, Resource resource, Properties properties, Cache cache, String key, String finalKey) throws RepositoryException, ParseException {
        Long expiration = Long.parseLong(properties.getProperty("cache.expiration"));
        Set<String> depNodeWrappers = Collections.emptySet();
        CacheEntry<String> cacheEntry = this.createCacheEntry(previousOut, renderContext, resource, key);
        this.addPropertiesToCacheEntry(resource, cacheEntry, renderContext);
        Element cachedElement = new Element((Serializable)((Object)finalKey), cacheEntry);
        if (expiration > 0L) {
            this.addExpirationToCacheElements(cache, finalKey, expiration, cachedElement);
        }
        this.storeDependencies(renderContext, resource, finalKey, depNodeWrappers);
        cache.put(cachedElement);
        if (logger.isDebugEnabled()) {
            logger.debug("Store in cache content of node with key: {}", (Object)finalKey);
            StringBuilder stringBuilder = new StringBuilder();
            for (String path : depNodeWrappers) {
                stringBuilder.append(path).append("\n");
            }
            logger.debug("Dependencies of {}:\n", (Object)finalKey, (Object)stringBuilder.toString());
        }
    }

    private void addExpirationToCacheElements(Cache cache, String finalKey, Long expiration, Element cachedElement) throws ParseException {
        cachedElement.setTimeToLive(expiration.intValue());
    }

    private void storeDependencies(RenderContext renderContext, Resource resource, String finalKey, Set<String> depNodeWrappers) {
        if (this.useDependencies()) {
            Cache dependenciesCache = this.cacheProvider.getDependenciesCache();
            depNodeWrappers = resource.getDependencies();
            for (String path : depNodeWrappers) {
                Element element1 = dependenciesCache.get((Serializable)((Object)path));
                Set dependencies = element1 != null ? (Set)element1.getObjectValue() : Collections.emptySet();
                if (dependencies.contains("ALL")) continue;
                CopyOnWriteArraySet<String> newDependencies = new CopyOnWriteArraySet<String>(dependencies);
                if (newDependencies.size() + 1 > this.dependenciesLimit) {
                    newDependencies.clear();
                    newDependencies.add("ALL");
                    dependenciesCache.put(new Element((Object)path, newDependencies));
                    continue;
                }
                this.addDependencies(renderContext, finalKey, dependenciesCache, path, newDependencies);
            }
            Cache regexpDependenciesCache = this.cacheProvider.getRegexpDependenciesCache();
            Set<String> regexpDepNodeWrappers = resource.getRegexpDependencies();
            for (String regexp : regexpDepNodeWrappers) {
                Element element1 = regexpDependenciesCache.get((Serializable)((Object)regexp));
                Set dependencies = element1 != null ? (Set)element1.getObjectValue() : Collections.emptySet();
                CopyOnWriteArraySet<String> newDependencies = new CopyOnWriteArraySet<String>(dependencies);
                this.addDependencies(renderContext, finalKey, regexpDependenciesCache, regexp, newDependencies);
            }
        }
        resource.getDependencies().clear();
        resource.getRegexpDependencies().clear();
    }

    protected Properties getAttributesForKey(RenderContext renderContext, Resource resource) throws RepositoryException {
        String requestParameters;
        StringBuilder stringBuilder;
        Script script = (Script)renderContext.getRequest().getAttribute("script");
        boolean isBound = resource.getNode().isNodeType("jmix:bindedComponent");
        boolean isList = resource.getNode().isNodeType("jmix:list");
        Properties properties = new Properties();
        if (script != null) {
            properties.putAll((Map<?, ?>)script.getView().getDefaultProperties());
            properties.putAll((Map<?, ?>)script.getView().getProperties());
        }
        String expiration = properties.getProperty("cache.expiration");
        if (isList) {
            Resource listLoader = new Resource(resource.getNode(), resource.getTemplateType(), "hidden.load", "include");
            try {
                Script s = this.service.resolveScript(listLoader, renderContext);
                properties.putAll((Map<?, ?>)s.getView().getProperties());
            }
            catch (TemplateNotFoundException e) {
                logger.error("Cannot find loader script for list" + resource.getNode().getPath(), (Throwable)e);
            }
        }
        if (resource.getNode().hasProperty("j:perUser")) {
            properties.put("cache.perUser", resource.getNode().getProperty("j:perUser").getString());
        }
        if (isBound) {
            properties.put("cache.mainResource", "true");
        }
        if ((stringBuilder = new StringBuilder((requestParameters = properties.getProperty("cache.requestParameters")) != null ? requestParameters : "")).length() == 0) {
            stringBuilder.append("ec,v");
        } else {
            stringBuilder.append(",ec,v");
        }
        if (SettingsBean.getInstance().isDevelopmentMode()) {
            stringBuilder.append(",cacheinfo,moduleinfo");
        }
        requestParameters = stringBuilder.toString();
        properties.put("cache.requestParameters", requestParameters);
        if (renderContext.getRequest().getAttribute("expiration") != null) {
            properties.put("cache.expiration", renderContext.getRequest().getAttribute("expiration"));
        } else if (resource.getNode().hasProperty("j:expiration")) {
            properties.put("cache.expiration", resource.getNode().getProperty("j:expiration").getString());
        } else if (expiration != null) {
            properties.put("cache.expiration", expiration);
        } else {
            properties.put("cache.expiration", "-1");
        }
        return properties;
    }

    protected CacheEntry<String> createCacheEntry(String previousOut, RenderContext renderContext, Resource resource, String key) {
        String cachedRenderContent = ESI_INCLUDE_STOPTAG_REGEXP.matcher(previousOut).replaceAll("</jahia_esi:include>");
        if ((cachedRenderContent = ESI_INCLUDE_STARTTAG_REGEXP.matcher(cachedRenderContent).replaceAll("<jahia_esi:include src=\"$1\">")).contains("<jahia_esi:include")) {
            Source source = new Source((CharSequence)cachedRenderContent);
            List esiIncludeTags = source.getAllStartTags("jahia_esi:include");
            OutputDocument outputDocument = AggregateCacheFilter.emptyEsiIncludeTagContainer(esiIncludeTags, source);
            cachedRenderContent = outputDocument.toString();
        }
        cachedRenderContent = this.surroundWithCacheTag(key, cachedRenderContent);
        CacheEntry<String> cacheEntry = new CacheEntry<String>(cachedRenderContent);
        return cacheEntry;
    }

    private void addPropertiesToCacheEntry(Resource resource, CacheEntry<String> cacheEntry, RenderContext renderContext) throws RepositoryException {
        if (resource.getNode().isNodeType("jnt:area") || resource.getNode().isNodeType("jnt:mainResourceDisplay")) {
            cacheEntry.setProperty("areaResource", (Serializable)((Object)resource.getNode().getIdentifier()));
        }
        TreeSet<String> allPaths = new TreeSet<String>();
        allPaths.addAll(renderContext.getRenderedPaths());
        cacheEntry.setProperty("allPaths", allPaths);
    }

    protected void addDependencies(RenderContext renderContext, String finalKey, Cache cache, String value, Set<String> newDependencies) {
        if (newDependencies.add(finalKey)) {
            cache.put(new Element((Object)value, newDependencies));
        }
    }

    protected String replacePlaceholdersInCacheKey(RenderContext renderContext, String key) {
        return this.cacheProvider.getKeyGenerator().replacePlaceholdersInCacheKey(renderContext, key);
    }

    protected String aggregateContent(Cache cache, String cachedContent, RenderContext renderContext, String areaIdentifier, Stack<String> cacheKeyStack, Set<String> allPaths) throws RenderException {
        if (!cachedContent.contains("<jahia_esi:include")) {
            return cachedContent;
        }
        Source htmlContent = new Source((CharSequence)cachedContent);
        List esiIncludeTags = htmlContent.getAllStartTags("jahia_esi:include");
        if (esiIncludeTags.size() > 0) {
            OutputDocument outputDocument = new OutputDocument(htmlContent);
            for (Tag esiIncludeTag : esiIncludeTags) {
                StartTag segment = (StartTag)esiIncludeTag;
                String cacheKey = segment.getAttributeValue("src");
                String replacedCacheKey = this.replacePlaceholdersInCacheKey(renderContext, cacheKey);
                if (logger.isDebugEnabled()) {
                    logger.debug("Check if {} is in cache", (Object)replacedCacheKey);
                }
                boolean cacheable = true;
                CacheKeyGenerator keyGenerator = this.cacheProvider.getKeyGenerator();
                Map<String, String> keyAttrbs = keyGenerator.parse(cacheKey);
                if (renderContext.getRequest().getParameter("ec") != null && renderContext.getRequest().getParameter("ec").equals(keyAttrbs.get("resourceID"))) {
                    cacheable = false;
                }
                if (renderContext.isLoggedIn() && renderContext.getRequest().getParameter("v") != null) {
                    cacheable = false;
                }
                if (cacheable && cache.isKeyInCache((Object)replacedCacheKey)) {
                    Element element = cache.get((Serializable)((Object)replacedCacheKey));
                    if (element != null && element.getObjectValue() != null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("It has been found in cache");
                        }
                        CacheEntry cacheEntry = (CacheEntry)element.getObjectValue();
                        String content = (String)cacheEntry.getObject();
                        if (cacheKeyStack.contains(cacheKey)) continue;
                        cacheKeyStack.push(cacheKey);
                        if (!cachedContent.equals(content)) {
                            String aggregatedContent = this.aggregateContent(cache, content, renderContext, (String)cacheEntry.getProperty("areaResource"), cacheKeyStack, (Set)cacheEntry.getProperty("allPaths"));
                            outputDocument.replace(segment.getBegin(), segment.getElement().getEndTag().getEnd(), (CharSequence)aggregatedContent);
                        } else {
                            outputDocument.replace(segment.getBegin(), segment.getElement().getEndTag().getEnd(), (CharSequence)content);
                        }
                        cacheKeyStack.pop();
                        continue;
                    }
                    cache.put(new Element((Serializable)((Object)replacedCacheKey), null));
                    if (logger.isDebugEnabled()) {
                        logger.debug("Content is expired");
                    }
                    this.generateContent(renderContext, outputDocument, segment, cacheKey, areaIdentifier, allPaths);
                    continue;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Content is missing from cache");
                }
                this.generateContent(renderContext, outputDocument, segment, cacheKey, areaIdentifier, allPaths);
            }
            return outputDocument.toString();
        }
        return cachedContent;
    }

    protected void generateContent(RenderContext renderContext, OutputDocument outputDocument, StartTag segment, String cacheKey, String areaIdentifier, Set<String> allPaths) throws RenderException {
        CacheKeyGenerator cacheKeyGenerator = this.cacheProvider.getKeyGenerator();
        try {
            Map<String, String> keyAttrbs = cacheKeyGenerator.parse(cacheKey);
            JCRSessionWrapper currentUserSession = JCRSessionFactory.getInstance().getCurrentUserSession(renderContext.getWorkspace(), LanguageCodeConverters.languageCodeToLocale(keyAttrbs.get("language")), renderContext.getFallbackLocale());
            JCRNodeWrapper node = null;
            try {
                node = currentUserSession.getNode(StringUtils.replace((String)keyAttrbs.get("path"), (String)"_mr_", (String)""));
            }
            catch (PathNotFoundException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Node {} is no longer available. Replacing output with empty content.", (Object)keyAttrbs.get("path"));
                }
                outputDocument.replace(segment.getBegin(), segment.getElement().getEndTag().getEnd(), (CharSequence)"");
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Calling render service for generating content for key " + cacheKey + " with attributes : " + " areaIdentifier " + areaIdentifier);
            }
            renderContext.getRequest().removeAttribute("areaNodeTypesRestriction" + renderContext.getRequest().getAttribute("org.jahia.modules.level"));
            Template oldOne = (Template)renderContext.getRequest().getAttribute("previousTemplate");
            String context = keyAttrbs.get("context");
            if (!context.equals("page")) {
                renderContext.getRequest().setAttribute("templateSet", (Object)Boolean.TRUE);
            }
            if (!StringUtils.isEmpty((String)keyAttrbs.get("templateNodes"))) {
                Template templateNodes = new Template(keyAttrbs.get("templateNodes"));
                renderContext.getRequest().setAttribute("previousTemplate", (Object)templateNodes);
            } else {
                renderContext.getRequest().removeAttribute("previousTemplate");
            }
            HashSet<String> addedPath = new HashSet<String>();
            if (null != allPaths && !allPaths.isEmpty()) {
                for (String path : allPaths) {
                    if (renderContext.getRenderedPaths().contains(path)) continue;
                    renderContext.getRenderedPaths().add(path);
                    addedPath.add(path);
                }
            }
            renderContext.getRequest().setAttribute("skipWrapper", (Object)Boolean.TRUE);
            Object oldInArea = renderContext.getRequest().getAttribute("inArea");
            String inArea = keyAttrbs.get("inArea");
            if (inArea == null || "".equals(inArea)) {
                renderContext.getRequest().removeAttribute("inArea");
            } else {
                renderContext.getRequest().setAttribute("inArea", (Object)Boolean.valueOf(inArea));
            }
            if (areaIdentifier != null) {
                renderContext.getRequest().setAttribute("areaListResource", (Object)currentUserSession.getNodeByIdentifier(areaIdentifier));
            }
            Resource resource = new Resource(node, keyAttrbs.get("templateType"), keyAttrbs.get("template"), context);
            try {
                JSONObject map = new JSONObject(keyAttrbs.get("moduleParams"));
                Iterator keys = map.keys();
                while (keys.hasNext()) {
                    String next = (String)keys.next();
                    resource.getModuleParams().put(next, (Serializable)map.get(next));
                }
            }
            catch (JSONException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            resource.getModuleParams().put("cache.forceGeneration", Boolean.valueOf(true));
            String content = RenderService.getInstance().render(resource, renderContext);
            if (content == null || "".equals(content.trim())) {
                logger.error("Empty generated content for key " + cacheKey + " with attributes : " + " areaIdentifier " + areaIdentifier);
            }
            for (String s : addedPath) {
                renderContext.getRenderedPaths().remove(s);
            }
            outputDocument.replace(segment.getBegin(), segment.getElement().getEndTag().getEnd(), (CharSequence)content);
            if (oldInArea != null) {
                renderContext.getRequest().setAttribute("inArea", oldInArea);
            } else {
                renderContext.getRequest().removeAttribute("inArea");
            }
            if (oldOne != null) {
                renderContext.getRequest().setAttribute("previousTemplate", (Object)oldOne);
            } else {
                renderContext.getRequest().removeAttribute("previousTemplate");
            }
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    protected String surroundWithCacheTag(String key, String output) {
        StringBuilder builder = new StringBuilder();
        builder.append("<!-- cache:include src=\"");
        builder.append(key);
        builder.append("\" -->\n");
        builder.append(output);
        builder.append("\n<!-- /cache:include -->");
        String cachedRenderContent = builder.toString();
        return cachedRenderContent;
    }

    protected String appendDebugInformation(RenderContext renderContext, String key, String renderContent, Element cachedElement) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<div class=\"cacheDebugInfo\">");
        stringBuilder.append("<span class=\"cacheDebugInfoLabel\">Expiration: </span><span>");
        String key1 = this.replacePlaceholdersInCacheKey(renderContext, key);
        if (!notCacheableFragment.containsKey(key)) {
            stringBuilder.append(SimpleDateFormat.getDateTimeInstance().format(new Date(this.cacheProvider.getCache().get((Serializable)((Object)key1)).getExpirationTime())));
        } else {
            stringBuilder.append("Not cached fragment ").append(SimpleDateFormat.getDateTimeInstance().format(Calendar.getInstance().getTime()));
        }
        stringBuilder.append("</span><br/>");
        stringBuilder.append("</div>");
        stringBuilder.append(renderContent);
        return stringBuilder.toString();
    }

    protected static OutputDocument emptyEsiIncludeTagContainer(Iterable<StartTag> segments, Source source) {
        OutputDocument outputDocument = new OutputDocument(source);
        for (StartTag segment : segments) {
            outputDocument.replace(segment.getElement().getContent(), (CharSequence)"");
        }
        return outputDocument;
    }

    public static String removeEsiTags(String content) {
        return AggregateCacheFilter.removeCacheTags(content);
    }

    public static String removeCacheTags(String content) {
        if (StringUtils.isNotEmpty((String)content)) {
            String s = CLEANUP_REGEXP.matcher(content).replaceAll("");
            return s;
        }
        return content;
    }

    @Override
    public String getContentForError(RenderContext renderContext, Resource resource, RenderChain chain, Exception e) {
        super.getContentForError(renderContext, resource, chain, e);
        if (this.cascadeFragmentErrors || "page".equals(resource.getContextConfiguration())) {
            return null;
        }
        try {
            renderContext.getRequest().setAttribute("expiration", (Object)("" + this.errorCacheExpiration));
            logger.error(e.getMessage(), (Throwable)e);
            return this.execute("<!-- Module error : " + e.getMessage() + "-->", renderContext, resource, chain);
        }
        catch (Exception e1) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finalize(RenderContext renderContext, Resource resource, RenderChain chain) {
        LinkedList<String> userKeysLinkedList = userKeys.get();
        if (userKeysLinkedList != null && userKeysLinkedList.size() > 0) {
            String finalKey = userKeysLinkedList.remove(0);
            if (finalKey.equals(acquiredSemaphore.get())) {
                this.generatorQueue.getAvailableProcessings().release();
                acquiredSemaphore.set(null);
            }
            Set<CountDownLatch> latches = processingLatches.get();
            Map<String, CountDownLatch> countDownLatchMap = this.generatorQueue.getGeneratingModules();
            CountDownLatch latch = countDownLatchMap.get(finalKey);
            if (latches != null && latches.contains(latch)) {
                latch.countDown();
                Map<String, CountDownLatch> map = countDownLatchMap;
                synchronized (map) {
                    latches.remove(countDownLatchMap.remove(finalKey));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CountDownLatch avoidParallelProcessingOfSameModule(String key, HttpServletRequest request, Resource resource, Properties properties) throws Exception {
        CountDownLatch latch = null;
        boolean mustWait = true;
        Map<String, CountDownLatch> generatingModules = this.generatorQueue.getGeneratingModules();
        if (generatingModules.get(key) == null && acquiredSemaphore.get() == null) {
            if (!this.generatorQueue.getAvailableProcessings().tryAcquire(this.generatorQueue.getModuleGenerationWaitTime(), TimeUnit.MILLISECONDS)) {
                this.manageThreadDump();
                throw new Exception("Module generation takes too long due to maximum parallel processing reached (" + this.generatorQueue.getMaxModulesToGenerateInParallel() + ") - " + key + " - " + request.getRequestURI());
            }
            acquiredSemaphore.set(key);
        }
        if (this.shouldUseLatch(resource, properties)) {
            Map<String, CountDownLatch> map = generatingModules;
            synchronized (map) {
                latch = generatingModules.get(key);
                if (latch == null) {
                    latch = new CountDownLatch(1);
                    generatingModules.put(key, latch);
                    mustWait = false;
                }
            }
        } else {
            mustWait = false;
        }
        if (mustWait) {
            if (acquiredSemaphore.get() != null) {
                this.generatorQueue.getAvailableProcessings().release();
                acquiredSemaphore.set(null);
            }
            try {
                if (!latch.await(this.generatorQueue.getModuleGenerationWaitTime(), TimeUnit.MILLISECONDS)) {
                    this.manageThreadDump();
                    throw new Exception("Module generation takes too long due to module not generated fast enough (>" + this.generatorQueue.getModuleGenerationWaitTime() + " ms)- " + key + " - " + request.getRequestURI());
                }
                latch = null;
            }
            catch (InterruptedException ie) {
                if (logger.isDebugEnabled()) {
                    logger.debug("The waiting thread has been interrupted :", (Throwable)ie);
                }
                throw new Exception(ie);
            }
        }
        return latch;
    }

    private boolean shouldUseLatch(Resource resource, Properties properties) throws RepositoryException {
        if (!StringUtils.isEmpty((String)properties.getProperty("cache.latch"))) {
            return Boolean.valueOf(properties.getProperty("cache.latch"));
        }
        if (this.skipLatchForConfigurations != null && this.skipLatchForConfigurations.contains(resource.getContextConfiguration())) {
            return false;
        }
        if (this.skipLatchForPaths != null) {
            for (String skipLatchForPath : this.skipLatchForPaths) {
                if (skipLatchForPath.contains("$currentSite")) {
                    skipLatchForPath = skipLatchForPath.replace("$currentSite", resource.getNode().getResolveSite().getPath());
                }
                if (!resource.getNode().getPath().startsWith(skipLatchForPath)) continue;
                return false;
            }
        }
        if (this.skipLatchForNodeTypes != null) {
            for (String nodeType : this.skipLatchForNodeTypes) {
                if (!resource.getNode().isNodeType(nodeType)) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void manageThreadDump() {
        boolean createDump = false;
        long minInterval = this.generatorQueue.getMinimumIntervalAfterLastAutoThreadDump();
        if (minInterval > -1L && (this.generatorQueue.isThreadDumpToSystemOut() || this.generatorQueue.isThreadDumpToFile())) {
            long now = System.currentTimeMillis();
            Byte[] byteArray = this.threadDumpCheckLock;
            // MONITORENTER : this.threadDumpCheckLock
            if (now > lastThreadDumpTime + minInterval) {
                createDump = true;
                lastThreadDumpTime = now;
            }
            // MONITOREXIT : byteArray
        }
        if (!createDump) return;
        ThreadMonitor tm = ThreadMonitor.getInstance();
        tm.dumpThreadInfo(this.generatorQueue.isThreadDumpToSystemOut(), this.generatorQueue.isThreadDumpToFile());
    }

    public void onApplicationEvent(JahiaTemplateManagerService.TemplatePackageRedeployedEvent event) {
        AggregateCacheFilter.flushNotCacheableFragment();
    }

    public void removeNotCacheableFragment(String key) {
        CacheKeyGenerator keyGenerator = this.cacheProvider.getKeyGenerator();
        if (keyGenerator instanceof DefaultCacheKeyGenerator) {
            DefaultCacheKeyGenerator defaultCacheKeyGenerator = (DefaultCacheKeyGenerator)keyGenerator;
            Map<String, String> keyAttrbs = defaultCacheKeyGenerator.parse(key);
            String path = keyAttrbs.get("path");
            ArrayList<String> removableKeys = new ArrayList<String>();
            for (String notCacheableKey : notCacheableFragment.keySet()) {
                if (!notCacheableKey.contains(path)) continue;
                removableKeys.add(notCacheableKey);
            }
            for (String removableKey : removableKeys) {
                notCacheableFragment.remove(removableKey);
            }
        }
    }

    public static void flushNotCacheableFragment() {
        notCacheableFragment.clear();
    }
}

