/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render.filter.cache;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.core.observation.EventImpl;
import org.jahia.exceptions.JahiaException;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.DefaultEventListener;
import org.jahia.services.content.ExternalEventListener;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCREventIterator;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.QueryManagerWrapper;
import org.jahia.services.query.QueryResultWrapper;
import org.jahia.services.render.filter.cache.AclCacheKeyPartGenerator;
import org.jahia.services.render.filter.cache.AggregateCacheFilter;
import org.jahia.services.render.filter.cache.ModuleCacheProvider;
import org.jahia.services.sites.JahiaSite;
import org.jahia.services.sites.JahiaSitesService;
import org.jahia.services.usermanager.JahiaGroup;
import org.jahia.settings.SettingsBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlCacheEventListener
extends DefaultEventListener
implements ExternalEventListener {
    private static Logger logger = LoggerFactory.getLogger(HtmlCacheEventListener.class);
    private ModuleCacheProvider cacheProvider;
    private AggregateCacheFilter aggregateCacheFilter;

    @Override
    public int getEventTypes() {
        return 63;
    }

    @Override
    public boolean isDeep() {
        return false;
    }

    @Override
    public String getPath() {
        return "(?!/jcr:system).*";
    }

    public void onEvent(EventIterator events) {
        int operationType = ((JCREventIterator)events).getOperationType();
        if (logger.isDebugEnabled()) {
            logger.debug("{} events received. Operation type {}", (Object)events.getSize(), (Object)operationType);
        }
        Cache depCache = this.cacheProvider.getDependenciesCache();
        Cache regexpDepCache = this.cacheProvider.getRegexpDependenciesCache();
        HashSet<String> flushed = new HashSet<String>();
        AclCacheKeyPartGenerator cacheKeyGenerator = (AclCacheKeyPartGenerator)this.cacheProvider.getKeyGenerator().getPartGenerator("acls");
        final HashSet<String> userGroupsKeyToFlush = new HashSet<String>();
        while (events.hasNext()) {
            Event event = (Event)events.next();
            if (logger.isDebugEnabled()) {
                logger.debug("Event: {}", (Object)event);
            }
            boolean propagateToOtherClusterNodes = !this.isExternal(event);
            try {
                block40: {
                    boolean flushForVanityUrl;
                    boolean flushChilds;
                    boolean flushParent;
                    String path;
                    block38: {
                        path = event.getPath();
                        flushParent = false;
                        flushChilds = false;
                        flushForVanityUrl = false;
                        if (path.contains("j:view")) {
                            flushParent = true;
                        }
                        int type = event.getType();
                        if (path.contains("j:invalidLanguages")) {
                            flushParent = true;
                        }
                        if (type == 4 || type == 16 || type == 8) {
                            if (path.endsWith("/j:published")) {
                                flushParent = true;
                            }
                            path = path.substring(0, path.lastIndexOf("/"));
                        } else if (type == 1 || type == 32 || type == 2) {
                            flushParent = true;
                        }
                        if (path.contains("vanityUrlMapping")) {
                            flushForVanityUrl = true;
                        }
                        if (path.contains("j:acl") && !path.endsWith("j:acl")) {
                            if (cacheKeyGenerator != null) {
                                String nodeName = StringUtils.substringAfterLast((String)path, (String)"/");
                                String key = "";
                                if (nodeName.startsWith("GRANT_")) {
                                    key = StringUtils.substringAfter((String)path, (String)"GRANT_");
                                } else if (nodeName.startsWith("DENY_")) {
                                    key = StringUtils.substringAfter((String)path, (String)"DENY_");
                                } else if (nodeName.startsWith("REF")) {
                                    int g = nodeName.indexOf("_g_");
                                    int u = nodeName.indexOf("_u_");
                                    if (g == nodeName.lastIndexOf("_g_") && u == nodeName.lastIndexOf("_u_")) {
                                        key = nodeName.substring(Math.max(u + 1, g + 1));
                                    }
                                } else {
                                    logger.warn("Cannot parse ACL event for : " + nodeName);
                                }
                                if (key.startsWith("u_")) {
                                    key = "u:" + key.substring(2) + ":0";
                                } else if (key.startsWith("g_")) {
                                    int siteId = this.getSiteId(path);
                                    key = "g:" + key.substring(2) + ":" + siteId;
                                }
                                userGroupsKeyToFlush.add(key);
                            }
                            flushParent = true;
                            flushChilds = true;
                        }
                        if (type == 32) {
                            if (cacheKeyGenerator != null) {
                                final String fPath = path;
                                JCRTemplate.getInstance().doExecuteWithSystemSession(null, this.workspace, new JCRCallback<Object>(){

                                    @Override
                                    public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                                        QueryManagerWrapper queryManager = session.getWorkspace().getQueryManager();
                                        QueryResultWrapper result = queryManager.createQuery("select * from ['jnt:ace'] where isdescendantnode('" + fPath + "/')", "JCR-SQL2").execute();
                                        for (JCRNodeWrapper nodeWrapper : result.getNodes()) {
                                            String principal = nodeWrapper.getProperty("j:principal").getString();
                                            if (principal.startsWith("u:")) {
                                                principal = principal + ":0";
                                            } else {
                                                int siteId = HtmlCacheEventListener.this.getSiteId(fPath);
                                                JahiaGroup group = ServicesRegistry.getInstance().getJahiaGroupManagerService().lookupGroup(siteId, principal.substring(2));
                                                if (group != null) {
                                                    siteId = group.getSiteID();
                                                }
                                                principal = principal + ":" + siteId;
                                            }
                                            userGroupsKeyToFlush.add(principal);
                                        }
                                        return null;
                                    }
                                });
                            }
                            flushParent = true;
                            flushChilds = true;
                        }
                        if (path.endsWith("/j:requiredPermissionNames") && cacheKeyGenerator != null) {
                            cacheKeyGenerator.flushPermissionCacheEntry(StringUtils.substringBeforeLast((String)path, (String)"/j:requiredPermissionNames"), propagateToOtherClusterNodes);
                        }
                        path = StringUtils.substringBeforeLast((String)StringUtils.substringBeforeLast((String)path, (String)"/j:translation"), (String)"/j:acl");
                        this.flushDependenciesOfPath(depCache, flushed, path, propagateToOtherClusterNodes);
                        try {
                            this.flushDependenciesOfPath(depCache, flushed, ((JCREventIterator)events).getSession().getNode(path).getIdentifier(), propagateToOtherClusterNodes);
                        }
                        catch (PathNotFoundException e) {
                            if (!(event instanceof EventImpl) || ((EventImpl)event).getChildId() == null) break block38;
                            this.flushDependenciesOfPath(depCache, flushed, ((EventImpl)event).getChildId().toString(), propagateToOtherClusterNodes);
                        }
                    }
                    this.flushRegexpDependenciesOfPath(regexpDepCache, path, propagateToOtherClusterNodes);
                    if (flushChilds) {
                        this.flushChildsDependenciesOfPath(depCache, path, propagateToOtherClusterNodes);
                    }
                    if (flushParent) {
                        block39: {
                            path = StringUtils.substringBeforeLast((String)path, (String)"/");
                            this.flushDependenciesOfPath(depCache, flushed, path, propagateToOtherClusterNodes);
                            try {
                                this.flushDependenciesOfPath(depCache, flushed, ((JCREventIterator)events).getSession().getNode(path).getIdentifier(), propagateToOtherClusterNodes);
                            }
                            catch (PathNotFoundException e) {
                                if (!(event instanceof EventImpl) || ((EventImpl)event).getParentId() == null) break block39;
                                this.flushDependenciesOfPath(depCache, flushed, ((EventImpl)event).getParentId().toString(), propagateToOtherClusterNodes);
                            }
                        }
                        this.flushRegexpDependenciesOfPath(regexpDepCache, path, propagateToOtherClusterNodes);
                    }
                    if (flushForVanityUrl) {
                        path = StringUtils.substringBeforeLast((String)path, (String)"/vanityUrlMapping");
                        this.flushDependenciesOfPath(depCache, flushed, path, propagateToOtherClusterNodes);
                        try {
                            this.flushDependenciesOfPath(depCache, flushed, ((JCREventIterator)events).getSession().getNode(path).getIdentifier(), propagateToOtherClusterNodes);
                        }
                        catch (PathNotFoundException e) {
                            if (!(event instanceof EventImpl) || ((EventImpl)event).getChildId() == null) break block40;
                            this.flushDependenciesOfPath(depCache, flushed, ((EventImpl)event).getChildId().toString(), propagateToOtherClusterNodes);
                        }
                    }
                }
                if (cacheKeyGenerator == null) continue;
                if (userGroupsKeyToFlush.contains("")) {
                    cacheKeyGenerator.flushUsersGroupsKey(propagateToOtherClusterNodes);
                    continue;
                }
                for (String key : userGroupsKeyToFlush) {
                    cacheKeyGenerator.flushUsersGroupsKey(key, propagateToOtherClusterNodes);
                }
            }
            catch (RepositoryException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private int getSiteId(String path) {
        int siteId = 0;
        if (path.startsWith("/sites/")) {
            String siteKey = StringUtils.substringBetween((String)path, (String)"/sites/", (String)"/");
            try {
                JahiaSite site = JahiaSitesService.getInstance().getSiteByKey(siteKey);
                siteId = site != null ? site.getID() : 0;
            }
            catch (JahiaException e) {
                // empty catch block
            }
        }
        return siteId;
    }

    private void flushDependenciesOfPath(Cache depCache, Set<String> flushed, String path, boolean propagateToOtherClusterNodes) {
        Element element;
        Element element2 = element = !flushed.contains(path) ? depCache.get((Serializable)((Object)path)) : null;
        if (element != null) {
            Set deps;
            if (logger.isDebugEnabled()) {
                logger.debug("Flushing dependencies for path: {}", (Object)path);
            }
            flushed.add(path);
            if (logger.isDebugEnabled()) {
                logger.debug("Flushing path: {}", (Object)path);
            }
            if ((deps = (Set)element.getObjectValue()).contains("ALL")) {
                AggregateCacheFilter.flushNotCacheableFragment();
            } else {
                for (String dep : deps) {
                    this.aggregateCacheFilter.removeNotCacheableFragment(dep);
                }
            }
            this.cacheProvider.invalidate(path, propagateToOtherClusterNodes);
            depCache.remove(element.getObjectKey());
        }
        if (SettingsBean.getInstance().isClusterActivated()) {
            this.cacheProvider.propagatePathFlushToCluster(path, propagateToOtherClusterNodes);
        }
    }

    private void flushRegexpDependenciesOfPath(Cache depCache, String path, boolean propagateToOtherClusterNodes) {
        if (logger.isDebugEnabled()) {
            logger.debug("Flushing dependencies for path: {}", (Object)path);
        }
        List keys = depCache.getKeys();
        for (String key : keys) {
            if (!path.matches(key)) continue;
            this.cacheProvider.invalidateRegexp(key, propagateToOtherClusterNodes);
        }
        if (SettingsBean.getInstance().isClusterActivated()) {
            this.cacheProvider.propagateFlushRegexpDependenciesOfPath(path, propagateToOtherClusterNodes);
        }
    }

    private void flushChildsDependenciesOfPath(Cache depCache, String path, boolean propagateToOtherClusterNodes) {
        if (logger.isDebugEnabled()) {
            logger.debug("Flushing dependencies for path: {}", (Object)path);
        }
        List keys = depCache.getKeys();
        for (String key : keys) {
            if (!key.startsWith(path)) continue;
            this.cacheProvider.invalidate(key, propagateToOtherClusterNodes);
        }
        if (SettingsBean.getInstance().isClusterActivated()) {
            this.cacheProvider.propagateChildrenDependenciesFlushToCluster(path, propagateToOtherClusterNodes);
        }
    }

    public void setCacheProvider(ModuleCacheProvider cacheProvider) {
        this.cacheProvider = cacheProvider;
    }

    public void setAggregateCacheFilter(AggregateCacheFilter aggregateCacheFilter) {
        this.aggregateCacheFilter = aggregateCacheFilter;
    }
}

