/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render.filter.cache;

import java.io.Serializable;
import java.util.Set;
import java.util.UUID;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.jackrabbit.core.JahiaRepositoryImpl;
import org.apache.jackrabbit.core.cluster.ClusterNode;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.cache.ehcache.EhCacheProvider;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.impl.jackrabbit.SpringJackrabbitRepository;
import org.jahia.services.render.filter.cache.CacheClusterEvent;
import org.jahia.services.render.filter.cache.CacheKeyGenerator;
import org.jahia.settings.SettingsBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class ModuleCacheProvider
implements InitializingBean {
    private static final String CACHE_NAME = "HTMLCache";
    private static final String CACHE_SYNC_NAME = "HTMLCacheEventSync";
    private static final String DEPS_CACHE_NAME = "HTMLDependenciesCache";
    private static final String REGEXPDEPS_CACHE_NAME = "HTMLREGEXPDependenciesCache";
    private static Logger logger = LoggerFactory.getLogger(ModuleCacheProvider.class);
    private Cache regexpDependenciesCache;
    private Cache htmlCache;
    private EhCacheProvider cacheProvider;
    private Cache dependenciesCache;
    private Cache syncCache;
    private CacheKeyGenerator keyGenerator;
    private JCRSessionFactory jcrSessionFactory;

    public static ModuleCacheProvider getInstance() {
        return (ModuleCacheProvider)SpringContextSingleton.getBean("ModuleCacheProvider");
    }

    public void afterPropertiesSet() throws Exception {
        CacheManager cacheManager = this.cacheProvider.getCacheManager();
        this.htmlCache = cacheManager.getCache(CACHE_NAME);
        if (this.htmlCache == null) {
            cacheManager.addCache(CACHE_NAME);
            this.htmlCache = cacheManager.getCache(CACHE_NAME);
        }
        this.dependenciesCache = cacheManager.getCache(DEPS_CACHE_NAME);
        if (this.dependenciesCache == null) {
            cacheManager.addCache(DEPS_CACHE_NAME);
            this.dependenciesCache = cacheManager.getCache(DEPS_CACHE_NAME);
        }
        this.regexpDependenciesCache = cacheManager.getCache(REGEXPDEPS_CACHE_NAME);
        if (this.regexpDependenciesCache == null) {
            cacheManager.addCache(REGEXPDEPS_CACHE_NAME);
            this.regexpDependenciesCache = cacheManager.getCache(REGEXPDEPS_CACHE_NAME);
        }
        if (SettingsBean.getInstance().isClusterActivated()) {
            this.syncCache = cacheManager.getCache(CACHE_SYNC_NAME);
            if (this.syncCache == null) {
                cacheManager.addCache(CACHE_SYNC_NAME);
                this.syncCache = cacheManager.getCache(CACHE_SYNC_NAME);
            }
        }
    }

    public void invalidate(String nodePath) {
        this.invalidate(nodePath, true);
    }

    public void invalidate(String nodePath, boolean propagateToOtherClusterNodes) {
        Element element = this.dependenciesCache.get((Serializable)((Object)nodePath));
        if (element != null) {
            Set deps = (Set)element.getObjectValue();
            if (deps.contains("ALL")) {
                this.htmlCache.removeAll(true);
            } else {
                this.invalidateDependencies(deps);
            }
        }
        if (propagateToOtherClusterNodes) {
            this.propagatePathFlushToCluster(nodePath, true);
        }
    }

    private void invalidateDependencies(Set<String> deps) {
        for (String dep : deps) {
            boolean removed;
            if (dep == null || (removed = this.htmlCache.remove((Serializable)((Object)dep))) || !logger.isDebugEnabled()) continue;
            logger.debug("Failed to remove {} from cache", (Object)dep);
        }
    }

    public Cache getCache() {
        return this.htmlCache;
    }

    public Cache getDependenciesCache() {
        return this.dependenciesCache;
    }

    public CacheKeyGenerator getKeyGenerator() {
        return this.keyGenerator;
    }

    public void setCacheProvider(EhCacheProvider cacheProvider) {
        this.cacheProvider = cacheProvider;
    }

    public void setKeyGenerator(CacheKeyGenerator keyGenerator) {
        this.keyGenerator = keyGenerator;
    }

    public void flushCaches() {
        this.htmlCache.removeAll();
        this.htmlCache.flush();
        this.dependenciesCache.removeAll();
        this.dependenciesCache.flush();
        this.regexpDependenciesCache.removeAll();
        this.regexpDependenciesCache.flush();
    }

    public Cache getRegexpDependenciesCache() {
        return this.regexpDependenciesCache;
    }

    public void invalidateRegexp(String key) {
        this.invalidateRegexp(key, true);
    }

    public void invalidateRegexp(String key, boolean propagateToOtherClusterNodes) {
        Element element = this.regexpDependenciesCache.get((Serializable)((Object)key));
        if (element != null) {
            Set deps = (Set)element.getObjectValue();
            this.invalidateDependencies(deps);
        }
        if (propagateToOtherClusterNodes && this.syncCache != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Sending flush of regexp {} across cluster", (Object)key);
            }
            this.syncCache.put(new Element((Serializable)((Object)("FLUSH_REGEXP-" + UUID.randomUUID())), (Serializable)new CacheClusterEvent(key, this.getClusterRevision())));
        }
    }

    public void propagateFlushRegexpDependenciesOfPath(String key, boolean propagateToOtherClusterNodes) {
        if (propagateToOtherClusterNodes && this.syncCache != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Sending flush of regexp dependencies {} across cluster", (Object)key);
            }
            this.syncCache.put(new Element((Serializable)((Object)("FLUSH_REGEXPDEP-" + UUID.randomUUID())), (Serializable)new CacheClusterEvent(key, this.getClusterRevision())));
        }
    }

    public void propagateChildrenDependenciesFlushToCluster(String path, boolean propagateToOtherClusterNodes) {
        if (propagateToOtherClusterNodes && this.syncCache != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Sending flush of children of {} across cluster", (Object)path);
            }
            this.syncCache.put(new Element((Serializable)((Object)("FLUSH_CHILDS-" + UUID.randomUUID())), (Serializable)new CacheClusterEvent(path, this.getClusterRevision())));
        }
    }

    public void propagatePathFlushToCluster(String nodePath, boolean propagateToOtherClusterNodes) {
        if (propagateToOtherClusterNodes && this.syncCache != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Sending flush of {} across cluster", (Object)nodePath);
            }
            this.syncCache.put(new Element((Serializable)((Object)("FLUSH_PATH-" + UUID.randomUUID())), (Serializable)new CacheClusterEvent(nodePath, this.getClusterRevision())));
        }
    }

    private long getClusterRevision() {
        ClusterNode clusterNode = ((JahiaRepositoryImpl)((SpringJackrabbitRepository)this.jcrSessionFactory.getDefaultProvider().getRepository()).getRepository()).getContext().getClusterNode();
        return clusterNode.getRevision();
    }

    public void setJcrSessionFactory(JCRSessionFactory jcrSessionFactory) {
        this.jcrSessionFactory = jcrSessionFactory;
    }

    public Cache getSyncCache() {
        return this.syncCache;
    }
}

