/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render.filter.cache;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import org.springframework.beans.factory.InitializingBean;

public class ModuleGeneratorQueue
implements InitializingBean {
    private Map<String, String> notCacheableModule = new ConcurrentHashMap<String, String>(2503);
    private Map<String, CountDownLatch> generatingModules;
    private int maxModulesToGenerateInParallel = 50;
    private long moduleGenerationWaitTime = 5000L;
    private volatile Semaphore availableProcessings = null;
    private long minimumIntervalAfterLastAutoThreadDump = 60000L;
    private boolean useLatchOnlyForPages = false;
    private boolean threadDumpToSystemOut = true;
    private boolean threadDumpToFile = true;

    public Map<String, String> getNotCacheableModule() {
        return this.notCacheableModule;
    }

    public Map<String, CountDownLatch> getGeneratingModules() {
        return this.generatingModules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Semaphore getAvailableProcessings() {
        Semaphore result = this.availableProcessings;
        if (result == null) {
            ModuleGeneratorQueue moduleGeneratorQueue = this;
            synchronized (moduleGeneratorQueue) {
                result = this.availableProcessings;
                if (result == null) {
                    this.availableProcessings = result = new Semaphore(this.getMaxModulesToGenerateInParallel(), true);
                }
            }
        }
        return result;
    }

    public int getMaxModulesToGenerateInParallel() {
        return this.maxModulesToGenerateInParallel;
    }

    public long getModuleGenerationWaitTime() {
        return this.moduleGenerationWaitTime;
    }

    public void afterPropertiesSet() throws Exception {
        this.generatingModules = new HashMap<String, CountDownLatch>(this.maxModulesToGenerateInParallel);
    }

    public void setMaxModulesToGenerateInParallel(int maxModulesToGenerateInParallel) {
        this.maxModulesToGenerateInParallel = maxModulesToGenerateInParallel;
        this.availableProcessings = null;
    }

    public void setModuleGenerationWaitTime(long moduleGenerationWaitTime) {
        this.moduleGenerationWaitTime = moduleGenerationWaitTime;
    }

    public void setMinimumIntervalAfterLastAutoThreadDump(long minimumIntervalAfterLastAutoThreadDump) {
        this.minimumIntervalAfterLastAutoThreadDump = minimumIntervalAfterLastAutoThreadDump;
    }

    public long getMinimumIntervalAfterLastAutoThreadDump() {
        return this.minimumIntervalAfterLastAutoThreadDump;
    }

    public boolean isThreadDumpToSystemOut() {
        return this.threadDumpToSystemOut;
    }

    public void setThreadDumpToSystemOut(boolean threadDumpToSystemOut) {
        this.threadDumpToSystemOut = threadDumpToSystemOut;
    }

    public boolean isThreadDumpToFile() {
        return this.threadDumpToFile;
    }

    public void setThreadDumpToFile(boolean threadDumpToFile) {
        this.threadDumpToFile = threadDumpToFile;
    }
}

