/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render.scripting;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.RenderException;
import org.jahia.services.render.Resource;
import org.jahia.services.render.View;
import org.jahia.services.render.scripting.Script;
import org.jahia.utils.StringResponseWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestDispatcherScript
implements Script {
    private static final Logger logger = LoggerFactory.getLogger(RequestDispatcherScript.class);
    private View view;

    protected static void dumpRequestAttributes(HttpServletRequest request) {
        Enumeration attributeNamesEnum = request.getAttributeNames();
        while (attributeNamesEnum.hasMoreElements()) {
            String currentAttributeName = (String)attributeNamesEnum.nextElement();
            String currentAttributeValue = request.getAttribute(currentAttributeName).toString();
            if (currentAttributeValue.length() < 80) {
                logger.debug("Request attribute " + currentAttributeName + "=" + currentAttributeValue);
                continue;
            }
            logger.debug("Request attribute " + currentAttributeName + "=" + currentAttributeValue.substring(0, 80) + " (first 80 chars)");
        }
    }

    public RequestDispatcherScript(View view) {
        this.view = view;
    }

    @Override
    public String execute(Resource resource, RenderContext context) throws RenderException {
        if (this.view == null) {
            throw new RenderException("View not found for : " + resource);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("View '" + this.view + "' resolved for resource: " + resource);
        }
        HttpServletRequest request = context.getRequest();
        HttpServletResponse response = context.getResponse();
        RequestDispatcher rd = request.getRequestDispatcher(this.view.getPath());
        Object oldModule = request.getAttribute("currentModule");
        request.setAttribute("currentModule", (Object)this.view.getModule());
        if (logger.isDebugEnabled()) {
            RequestDispatcherScript.dumpRequestAttributes(request);
        }
        StringResponseWrapper wrapper = new StringResponseWrapper(response);
        try {
            rd.include((ServletRequest)request, (ServletResponse)wrapper);
        }
        catch (ServletException e) {
            while (e.getRootCause() instanceof ServletException) {
                e = (ServletException)e.getRootCause();
            }
            if (e.getRootCause() instanceof RenderException) {
                throw (RenderException)e.getRootCause();
            }
            throw new RenderException(e.getRootCause() != null ? e.getRootCause() : e);
        }
        catch (IOException e) {
            throw new RenderException(e);
        }
        finally {
            request.setAttribute("currentModule", oldModule);
        }
        try {
            return wrapper.getString();
        }
        catch (IOException e) {
            throw new RenderException(e);
        }
    }

    @Override
    public View getView() {
        return this.view;
    }
}

