/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render.webflow;

import java.util.HashMap;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.render.webflow.WebflowDispatcherScript;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.context.servlet.DefaultFlowUrlHandler;
import org.springframework.webflow.core.collection.AttributeMap;

public class JahiaFlowUrlHandler
extends DefaultFlowUrlHandler {
    private static final Logger logger = LoggerFactory.getLogger(JahiaFlowUrlHandler.class);

    public String getFlowExecutionKey(HttpServletRequest request) {
        JCRNodeWrapper n = (JCRNodeWrapper)request.getAttribute("currentNode");
        if (n != null) {
            try {
                return request.getParameter("webflowexecution" + StringUtils.remove((String)n.getIdentifier(), (char)'-'));
            }
            catch (RepositoryException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return super.getFlowExecutionKey(request);
            }
        }
        return super.getFlowExecutionKey(request);
    }

    public String getFlowId(HttpServletRequest request) {
        WebflowDispatcherScript script = (WebflowDispatcherScript)request.getAttribute("script");
        if (script != null) {
            String path = script.getFlowPath();
            return StringUtils.substringAfter((String)path, (String)"/flow/");
        }
        return super.getFlowId(request);
    }

    public String createFlowExecutionUrl(String flowId, String flowExecutionKey, HttpServletRequest request) {
        WebflowDispatcherScript script = (WebflowDispatcherScript)request.getAttribute("script");
        JCRNodeWrapper n = (JCRNodeWrapper)request.getAttribute("currentNode");
        if (script != null && n != null) {
            StringBuffer path = new StringBuffer(request.getRequestURI());
            path.append('?');
            HashMap<String, String> params = new HashMap<String, String>();
            try {
                params.put("webflowexecution" + StringUtils.remove((String)n.getIdentifier(), (char)'-'), flowExecutionKey);
                this.appendQueryParameters(path, params, this.getEncodingScheme(request));
            }
            catch (RepositoryException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return super.createFlowExecutionUrl(flowId, flowExecutionKey, request);
            }
            return path.toString();
        }
        return super.createFlowExecutionUrl(flowId, flowExecutionKey, request);
    }

    public String createFlowDefinitionUrl(String flowId, AttributeMap input, HttpServletRequest request) {
        return super.createFlowDefinitionUrl(flowId, input, request);
    }
}

