/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.search;

import java.util.HashMap;
import java.util.List;
import org.jahia.exceptions.JahiaException;
import org.jahia.exceptions.JahiaInitializationException;
import org.jahia.services.content.rules.RulesListener;
import org.jahia.services.render.RenderContext;
import org.jahia.services.search.Hit;
import org.jahia.services.search.JCRNodeHit;
import org.jahia.services.search.SearchCriteria;
import org.jahia.services.search.SearchProvider;
import org.jahia.services.search.SearchResponse;
import org.jahia.services.search.SearchService;
import org.jahia.services.search.SearchURLService;
import org.jahia.services.search.Suggestion;

public class SearchServiceImpl
extends SearchService {
    private SearchProvider searchProvider;

    public static SearchServiceImpl getInstance() {
        return Holder.INSTANCE;
    }

    private SearchServiceImpl() {
    }

    @Override
    public SearchResponse search(SearchCriteria criteria, RenderContext context) {
        return this.getProvider().search(criteria, context);
    }

    public static void executeURLModificationRules(List<JCRNodeHit> searchHits, RenderContext context) {
        HashMap<String, Object> globals = new HashMap<String, Object>();
        globals.put("renderContext", context);
        globals.put("urlService", SearchURLService.getInstance());
        RulesListener.getInstance(context.getMainResource().getWorkspace()).executeRules(searchHits, globals);
    }

    public static void executeURLModificationRules(Hit<?> searchHit, RenderContext context) {
        HashMap<String, Object> globals = new HashMap<String, Object>();
        globals.put("renderContext", context);
        globals.put("urlService", SearchURLService.getInstance());
        RulesListener.getInstance(context.getMainResource().getWorkspace()).executeRules(searchHit, globals);
    }

    @Override
    public void start() throws JahiaInitializationException {
    }

    @Override
    public void stop() throws JahiaException {
    }

    @Override
    public Suggestion suggest(String originalQuery, RenderContext context, int maxTermsToSuggest) {
        return this.getProvider().suggest(originalQuery, context, maxTermsToSuggest);
    }

    protected SearchProvider getProvider() {
        return this.searchProvider;
    }

    public void setSearchProvider(SearchProvider searchProvider) {
        this.searchProvider = searchProvider;
    }

    private static class Holder {
        static final SearchServiceImpl INSTANCE = new SearchServiceImpl();

        private Holder() {
        }
    }
}

