/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.search.jcr;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.jcr.ItemNotFoundException;
import javax.jcr.PathNotFoundException;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.math.util.MathUtils;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.jahia.exceptions.JahiaException;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.categories.Category;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.QueryManagerWrapper;
import org.jahia.services.query.QueryWrapper;
import org.jahia.services.render.RenderContext;
import org.jahia.services.search.FileHit;
import org.jahia.services.search.Hit;
import org.jahia.services.search.JCRNodeHit;
import org.jahia.services.search.SearchCriteria;
import org.jahia.services.search.SearchProvider;
import org.jahia.services.search.SearchResponse;
import org.jahia.services.search.SearchServiceImpl;
import org.jahia.services.search.Suggestion;
import org.jahia.services.tags.TaggingService;
import org.jahia.utils.DateUtils;
import org.jahia.utils.Patterns;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JahiaJCRSearchProvider
implements SearchProvider {
    private static final Pattern AND_PATTERN = Pattern.compile(" AND ");
    private static final Pattern MULTIPLE_SPACES_PATTERN = Pattern.compile("\\s{2,}");
    private static final Pattern NOT_PATTERN = Pattern.compile(" NOT ");
    private static final Pattern OR_PATTERN = Pattern.compile(" OR ");
    private static Logger logger = LoggerFactory.getLogger(JahiaJCRSearchProvider.class);
    private TaggingService taggingService = null;
    private Set<String> typesToHideFromSearchResults;

    @Override
    public SearchResponse search(SearchCriteria criteria, RenderContext context) {
        SearchResponse response = new SearchResponse();
        ArrayList results = new ArrayList();
        response.setResults(results);
        try {
            JCRSessionWrapper session = ServicesRegistry.getInstance().getJCRStoreService().getSessionFactory().getCurrentUserSession(context.getMainResource().getWorkspace(), context.getMainResource().getLocale(), context.getFallbackLocale());
            Query query = this.buildQuery(criteria, session);
            int offset = criteria.getOffset() < 0L ? 0 : (int)criteria.getOffset();
            int limit = criteria.getLimit() <= 0L ? Integer.MAX_VALUE : (int)criteria.getLimit();
            response.setOffset(offset);
            response.setLimit(limit);
            int count = 0;
            if (query != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Executing search query [{}]", (Object)query.getStatement());
                }
                QueryResult queryResult = query.execute();
                RowIterator it = queryResult.getRows();
                HashSet<String> languages = new HashSet<String>();
                if (it.hasNext()) {
                    if (!criteria.getLanguages().isEmpty()) {
                        for (String languageCode : criteria.getLanguages().getValues()) {
                            if (StringUtils.isEmpty((String)languageCode)) continue;
                            languages.add(languageCode);
                        }
                    } else if (session.getLocale() != null) {
                        languages.add(session.getLocale().toString());
                    }
                }
                HashSet usageFilterSites = !criteria.getSites().isEmpty() && !criteria.getSites().getValue().equals("-all-") && !criteria.getSitesForReferences().isEmpty() ? Sets.newHashSet((Object[])criteria.getSites().getValues()) : null;
                HashSet<String> addedNodes = new HashSet<String>();
                HashMap<String, JCRNodeHit> addedHits = new HashMap<String, JCRNodeHit>();
                ArrayList<JCRNodeHit> hitsToAdd = new ArrayList<JCRNodeHit>();
                int requiredHits = limit + offset;
                while (it.hasNext()) {
                    ++count;
                    Row row = it.nextRow();
                    try {
                        JCRNodeHit hit;
                        JCRNodeWrapper node = (JCRNodeWrapper)row.getNode();
                        if (node != null && (node.isNodeType("jnt:translation") || "jcr:content".equals(node.getName()))) {
                            node = node.getParent();
                        }
                        if (node == null || !addedNodes.add(node.getIdentifier())) continue;
                        boolean skipNode = this.isNodeToSkip(node, criteria, languages);
                        JCRNodeHit jCRNodeHit = hit = !skipNode ? this.buildHit(row, node, context, usageFilterSites) : null;
                        if (!skipNode && usageFilterSites != null && !usageFilterSites.contains(node.getResolveSite().getName())) {
                            skipNode = hit.getUsages().isEmpty();
                        }
                        if (skipNode) continue;
                        hitsToAdd.add(hit);
                        if (hitsToAdd.size() + addedHits.size() < requiredHits) continue;
                        SearchServiceImpl.executeURLModificationRules(hitsToAdd, context);
                        this.addHitsToResults(hitsToAdd, results, addedHits, offset);
                        hitsToAdd.clear();
                        if (addedHits.size() < requiredHits) continue;
                        response.setHasMore(true);
                        if (it.getSize() > 0L) {
                            int approxCount = (int)it.getSize() * addedHits.size() / count;
                            approxCount = (int)Math.ceil(MathUtils.round((float)approxCount, (int)(approxCount < 1000 ? -1 : (approxCount < 10000 ? -2 : -3)), (int)0));
                            response.setApproxCount(approxCount);
                        }
                        return response;
                    }
                    catch (ItemNotFoundException e) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("Found node is not visible or published: " + row.getPath(), (Throwable)e);
                    }
                    catch (PathNotFoundException e) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("Found node is not visible or published: " + row.getPath(), (Throwable)e);
                    }
                    catch (Exception e) {
                        logger.warn("Error resolving search hit", (Throwable)e);
                    }
                }
                if (hitsToAdd.size() > 0) {
                    SearchServiceImpl.executeURLModificationRules(hitsToAdd, context);
                    this.addHitsToResults(hitsToAdd, results, addedHits, offset);
                }
            }
        }
        catch (RepositoryException e) {
            if (e.getMessage() != null && e.getMessage().contains(ParseException.class.getName())) {
                logger.warn(e.getMessage());
                if (logger.isDebugEnabled()) {
                    logger.debug(e.getMessage(), (Throwable)e);
                }
            } else {
                logger.error("Error while trying to perform a search", (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error("Error while trying to perform a search", (Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Search query has {} results", (Object)results.size());
        }
        return response;
    }

    private void addHitsToResults(List<JCRNodeHit> collectedHits, List<Hit<?>> results, Map<String, JCRNodeHit> addedHits, int offset) {
        for (JCRNodeHit hit : collectedHits) {
            if (!addedHits.containsKey(hit.getLink())) {
                addedHits.put(hit.getLink(), hit);
                if (addedHits.size() < offset) continue;
                results.add(hit);
                continue;
            }
            JCRNodeHit previousHit = addedHits.get(hit.getLink());
            for (Row row : hit.getRows()) {
                previousHit.addRow(row);
            }
        }
    }

    private boolean isNodeToSkip(JCRNodeWrapper node, SearchCriteria criteria, Set<String> languages) {
        boolean skipNode;
        block6: {
            skipNode = false;
            try {
                if (this.typesToHideFromSearchResults.contains(node.getPrimaryNodeTypeName())) {
                    return true;
                }
                if (languages.isEmpty() || !this.isSiteSearch(criteria) || !node.isFile() && !node.isNodeType("nt:folder")) break block6;
                skipNode = !this.isFileSearch(criteria) ? true : skipNode;
                PropertyIterator it = node.getWeakReferences();
                while (it.hasNext()) {
                    skipNode = this.isFileSearch(criteria) ? true : skipNode;
                    try {
                        JCRNodeWrapper refNode = (JCRNodeWrapper)it.nextProperty().getParent();
                        if (!languages.contains(refNode.getLanguage())) continue;
                        skipNode = false;
                        break;
                    }
                    catch (Exception e) {
                        logger.debug("Error while trying to check for node language", (Throwable)e);
                    }
                }
            }
            catch (RepositoryException e) {
                logger.debug("Error while trying to check for node language", (Throwable)e);
            }
        }
        return skipNode;
    }

    private JCRNodeHit buildHit(Row row, JCRNodeWrapper node, RenderContext context, Set<String> usageFilterSites) throws RepositoryException {
        JCRNodeHit searchHit = null;
        searchHit = node.isFile() || node.isNodeType("nt:folder") ? new FileHit(node, context) : new JCRNodeHit(node, context);
        try {
            searchHit.setUsageFilterSites(usageFilterSites);
            searchHit.setScore((float)(row.getScore() / 1000.0));
            searchHit.addRow(row);
        }
        catch (Exception e) {
            logger.warn("Search details cannot be retrieved", (Throwable)e);
        }
        return searchHit;
    }

    private String buildSQLQuery(SearchCriteria params, JCRSessionWrapper session) {
        StringBuilder query = new StringBuilder("select * from ");
        query.append("[");
        query.append(this.getNodeType(params));
        query.append("] as n ");
        String path = null;
        boolean includeChildren = false;
        if (!params.getFilePath().isEmpty()) {
            path = params.getFilePath().getValue().trim();
            includeChildren = params.getFilePath().isIncludeChildren();
        } else if (!params.getPagePath().isEmpty()) {
            path = params.getPagePath().getValue().trim();
            includeChildren = params.getPagePath().isIncludeChildren();
        }
        if (path != null) {
            query.append("where (");
            if (includeChildren) {
                query.append("isdescendantnode(n,'");
            } else {
                query.append("ischildnode(n,'");
            }
            query.append(path).append("')");
            query.append(")");
        } else if (!params.getSites().isEmpty()) {
            query.append("where (");
            if (!"-all-".equals(params.getSites().getValue())) {
                LinkedHashSet<String> sites = new LinkedHashSet<String>();
                for (String site : params.getSites().getValues()) {
                    sites.add(site);
                }
                if (!params.getSitesForReferences().isEmpty()) {
                    for (String site : params.getSitesForReferences().getValues()) {
                        sites.add(site);
                    }
                }
                for (String site : sites) {
                    query.append("isdescendantnode(n,'/sites/").append(site).append("') or ");
                }
                query.delete(query.length() - 4, query.length());
            }
            if (this.isSiteSearch(params)) {
                // empty if block
            }
            query.append(")");
        }
        query = this.appendConstraints(params, query, false, session);
        query.append(" order by score() desc");
        return query.toString();
    }

    private String buildXpathQuery(SearchCriteria params, JCRSessionWrapper session) {
        String xpathQuery = null;
        StringBuilder query = new StringBuilder(256);
        String path = null;
        boolean includeChildren = false;
        if (!params.getFilePath().isEmpty()) {
            path = params.getFilePath().getValue().trim();
            includeChildren = params.getFilePath().isIncludeChildren();
        } else if (!params.getPagePath().isEmpty()) {
            path = params.getPagePath().getValue().trim();
            includeChildren = params.getPagePath().isIncludeChildren();
        }
        if (path != null) {
            String[] pathTokens = path != null ? Patterns.SLASH.split(StringEscapeUtils.unescapeHtml((String)path)) : ArrayUtils.EMPTY_STRING_ARRAY;
            String lastFolder = null;
            StringBuilder jcrPath = new StringBuilder(64);
            jcrPath.append("/jcr:root/");
            for (String folder : pathTokens) {
                if (folder.length() == 0) continue;
                if (!includeChildren) {
                    if (lastFolder != null) {
                        jcrPath.append(lastFolder).append("/");
                    }
                    lastFolder = folder;
                    continue;
                }
                jcrPath.append(folder).append("/");
            }
            if (includeChildren) {
                jcrPath.append("/");
                lastFolder = "*";
            }
            query.append(ISO9075.encodePath((String)jcrPath.toString())).append("element(").append(lastFolder).append(",").append(this.getNodeType(params)).append(")");
        } else if (!params.getSites().isEmpty()) {
            query.append("/jcr:root/sites/");
            if ("-all-".equals(params.getSites().getValue())) {
                query.append("*");
            } else {
                LinkedHashSet<String> sites = new LinkedHashSet<String>();
                for (String site : params.getSites().getValues()) {
                    sites.add(site);
                }
                if (!params.getSitesForReferences().isEmpty()) {
                    for (String site : params.getSitesForReferences().getValues()) {
                        sites.add(site);
                    }
                }
                if (sites.size() == 1) {
                    query.append((String)sites.iterator().next());
                } else {
                    query.append("*[");
                    int i = 0;
                    for (String site : sites) {
                        if (i > 0) {
                            query.append(" or ");
                        }
                        query.append("fn:name() = '");
                        query.append(site);
                        query.append("'");
                        ++i;
                    }
                    query.append("]");
                }
            }
            if (this.isSiteSearch(params)) {
                query.append("/*[@j:isHomePage='true' or fn:name() = 'files' or fn:name() = 'contents']");
            }
            query.append("//element(*,").append(this.getNodeType(params)).append(")");
        } else {
            query.append("//element(*,").append(this.getNodeType(params)).append(")");
        }
        query = this.appendConstraints(params, query, true, session);
        query.append(" order by jcr:score() descending");
        xpathQuery = query.toString();
        if (logger.isDebugEnabled()) {
            logger.debug("XPath query built: " + xpathQuery);
        }
        return xpathQuery;
    }

    private boolean isFileSearch(SearchCriteria params) {
        for (SearchCriteria.Term term : params.getTerms()) {
            if (term.getFields() == null || !term.getFields().isSiteContent() && (term.getFields().isDescription() || term.getFields().isFileContent() || term.getFields().isFilename() || term.getFields().isKeywords() || term.getFields().isTitle()) || term.getFields().isDescription() && term.getFields().isFileContent() && term.getFields().isFilename() && term.getFields().isKeywords() && term.getFields().isTitle()) continue;
            return false;
        }
        return true;
    }

    private boolean isSiteSearch(SearchCriteria params) {
        for (SearchCriteria.Term term : params.getTerms()) {
            if (term.getFields() == null || !term.getFields().isSiteContent()) continue;
            return true;
        }
        return false;
    }

    private String getNodeType(SearchCriteria params) {
        return StringUtils.isEmpty((String)params.getNodeType()) ? (this.isFileSearch(params) && !this.isSiteSearch(params) ? "nt:hierarchyNode" : "nt:base") : params.getNodeType();
    }

    private StringBuilder appendConstraints(SearchCriteria params, StringBuilder query, boolean xpath, JCRSessionWrapper session) {
        StringBuilder constraints = new StringBuilder(64);
        this.addTermConstraints(params, constraints, session, xpath);
        this.addDateAndAuthorConstraints(params, constraints, xpath);
        this.addFileTypeConstraints(params, constraints, xpath);
        this.addLanguageConstraints(params, constraints, xpath);
        List<SearchCriteria.NodeProperty> props = params.getPropertiesAll();
        if (!props.isEmpty()) {
            this.addPropertyConstraints(constraints, props, xpath);
        }
        if (constraints.length() > 0) {
            if (xpath) {
                query.append("[").append((CharSequence)constraints).append("]");
            } else {
                if (query.indexOf("where") > -1) {
                    query.append(" and ");
                } else {
                    query.append(" where ");
                }
                query.append("(").append((CharSequence)constraints).append(")");
            }
        }
        return query;
    }

    private StringBuilder addConstraint(StringBuilder constraints, String operand, String constraint) {
        if (constraints.length() > 0) {
            constraints.append(" ").append(operand).append(" ");
        }
        return constraints.append(constraint);
    }

    private void addDateAndAuthorConstraints(SearchCriteria params, StringBuilder constraints, boolean xpath) {
        if (params.getCreatedBy() != null && params.getCreatedBy().length() > 0) {
            this.addConstraint(constraints, "and", this.getContainsExpr("jcr:createdBy", JCRContentUtils.stringToJCRSearchExp(params.getCreatedBy().trim()), xpath));
        }
        if (params.getLastModifiedBy() != null && params.getLastModifiedBy().length() > 0) {
            this.addConstraint(constraints, "and", this.getContainsExpr("jcr:lastModifiedBy", JCRContentUtils.stringToJCRSearchExp(params.getLastModifiedBy().trim()), xpath));
        }
        if (!params.getCreated().isEmpty() && SearchCriteria.DateValue.Type.ANYTIME != params.getCreated().getType()) {
            this.addDateConstraint(constraints, params.getCreated(), "jcr:created", xpath);
        }
        if (!params.getLastModified().isEmpty() && SearchCriteria.DateValue.Type.ANYTIME != params.getLastModified().getType()) {
            this.addDateConstraint(constraints, params.getLastModified(), "jcr:lastModified", xpath);
        }
    }

    private void addDateConstraint(StringBuilder constraints, SearchCriteria.DateValue dateValue, String paramName, boolean xpath) {
        Calendar greaterThanDate = Calendar.getInstance();
        Calendar smallerThanDate = null;
        if (SearchCriteria.DateValue.Type.TODAY != dateValue.getType()) {
            if (SearchCriteria.DateValue.Type.LAST_WEEK == dateValue.getType()) {
                greaterThanDate.add(5, -7);
            } else if (SearchCriteria.DateValue.Type.LAST_MONTH == dateValue.getType()) {
                greaterThanDate.add(2, -1);
            } else if (SearchCriteria.DateValue.Type.LAST_THREE_MONTHS == dateValue.getType()) {
                greaterThanDate.add(2, -3);
            } else if (SearchCriteria.DateValue.Type.LAST_SIX_MONTHS == dateValue.getType()) {
                greaterThanDate.add(2, -6);
            } else if (SearchCriteria.DateValue.Type.RANGE == dateValue.getType()) {
                greaterThanDate = null;
                smallerThanDate = null;
                if (dateValue.getFromAsDate() != null) {
                    greaterThanDate = Calendar.getInstance();
                    greaterThanDate.setTime(dateValue.getFromAsDate());
                }
                if (dateValue.getToAsDate() != null) {
                    smallerThanDate = Calendar.getInstance();
                    smallerThanDate.setTime(dateValue.getToAsDate());
                }
            } else {
                throw new IllegalArgumentException("Unknown date value type '" + (Object)((Object)dateValue.getType()) + "'");
            }
        }
        try {
            if (greaterThanDate != null) {
                this.addConstraint(constraints, "and", this.getPropertyName(paramName, xpath) + " >= " + this.getDateLiteral(DateUtils.dayStart(greaterThanDate), xpath));
            }
            if (smallerThanDate != null) {
                this.addConstraint(constraints, "and", this.getPropertyName(paramName, xpath) + " <= " + this.getDateLiteral(DateUtils.dayEnd(smallerThanDate), xpath));
            }
        }
        catch (IllegalStateException e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
    }

    private void addFileTypeConstraints(SearchCriteria params, StringBuilder constraints, boolean xpath) {
        if (StringUtils.isNotEmpty((String)params.getFileType())) {
            List<String> mimeTypes = JCRContentUtils.getInstance().getMimeTypes().get(params.getFileType());
            if (mimeTypes != null && !mimeTypes.isEmpty()) {
                if (mimeTypes.size() > 1) {
                    StringBuilder fileTypeConstraints = new StringBuilder(128);
                    for (String mimeType : mimeTypes) {
                        this.addConstraint(fileTypeConstraints, "or", this.getMimeTypeConstraint(mimeType, xpath));
                    }
                    this.addConstraint(constraints, "and", fileTypeConstraints.insert(0, "(").append(")").toString());
                } else {
                    this.addConstraint(constraints, "and", this.getMimeTypeConstraint(mimeTypes.get(0), xpath));
                }
            } else {
                logger.warn("Unsupported file type '" + params.getFileType() + "'. See applicationcontext-basejahiaconfig.xml file" + " for configured file types.");
            }
        }
    }

    private void addPropertyConstraintCategory(StringBuilder categoryConstraints, String name, String value, boolean includeChildren, boolean xpath) {
        try {
            Category cat = Category.getCategoryByPath(value, JCRSessionFactory.getInstance().getCurrentUser());
            if (cat == null) {
                logger.warn("User " + JCRSessionFactory.getInstance().getCurrentUser().getUsername() + " has no right to read the category");
                return;
            }
            this.addConstraint(categoryConstraints, "or", this.getPropertyName(name, xpath) + "=" + JCRContentUtils.stringToJCRSearchExp(cat.getID()));
            if (includeChildren) {
                this.addSubCategoriesConstraints(categoryConstraints, cat, name, xpath);
            }
        }
        catch (JahiaException e) {
            logger.warn("Category: " + value + " could not be retrieved", (Throwable)e);
        }
    }

    private void addSubCategoriesConstraints(StringBuilder categoryConstraints, Category category, String name, boolean xpath) throws JahiaException {
        List<Category> childs = category.getChildCategories();
        if (childs != null && childs.size() > 0) {
            for (Category cat : childs) {
                this.addConstraint(categoryConstraints, "or", this.getPropertyName(name, xpath) + "=" + JCRContentUtils.stringToJCRSearchExp(cat.getID()));
                this.addSubCategoriesConstraints(categoryConstraints, cat, name, xpath);
            }
        }
    }

    private void addPropertyConstraints(StringBuilder constraints, List<SearchCriteria.NodeProperty> properties, boolean xpath) {
        for (SearchCriteria.NodeProperty property : properties) {
            if (property.isEmpty()) continue;
            if (SearchCriteria.NodeProperty.Type.CATEGORY == property.getType()) {
                StringBuilder categoryConstraints = new StringBuilder(64);
                for (String value : property.getCategoryValue().getValues()) {
                    this.addPropertyConstraintCategory(categoryConstraints, property.getName(), value, property.getCategoryValue().isIncludeChildren(), xpath);
                }
                if (categoryConstraints.length() <= 0) continue;
                this.addConstraint(constraints, "and", categoryConstraints.insert(0, "(").append(")").toString());
                continue;
            }
            if (SearchCriteria.NodeProperty.Type.DATE == property.getType()) {
                this.addDateConstraint(constraints, property.getDateValue(), property.getName(), xpath);
                continue;
            }
            if (SearchCriteria.NodeProperty.Type.TEXT == property.getType()) {
                StringBuilder propertyConstraints = new StringBuilder(64);
                for (String value : property.getValues()) {
                    if (property.isConstrained()) {
                        String matchType = "=";
                        if (property.getMatch() == SearchCriteria.Term.MatchType.WITHOUT_WORDS) {
                            matchType = "!=";
                        }
                        this.addConstraint(propertyConstraints, "or", this.getPropertyName(property.getName(), xpath) + matchType + JCRContentUtils.stringToJCRSearchExp(value));
                        continue;
                    }
                    this.addConstraint(propertyConstraints, "or", this.getContainsExpr(property.getName(), this.getSearchExpressionForMatchType(value, property.getMatch(), false), xpath));
                }
                if (propertyConstraints.length() <= 0) continue;
                if (property.getValues().length == 1) {
                    this.addConstraint(constraints, "and", propertyConstraints.toString());
                    continue;
                }
                this.addConstraint(constraints, "and", "(" + propertyConstraints.toString() + ")");
                continue;
            }
            if (SearchCriteria.NodeProperty.Type.BOOLEAN == property.getType()) {
                if (!Boolean.parseBoolean(property.getValue())) continue;
                this.addConstraint(constraints, "and", this.getPropertyName(property.getName(), xpath) + "='true'");
                continue;
            }
            throw new IllegalArgumentException("Unknown document property type '" + (Object)((Object)property.getType()) + "'");
        }
    }

    private void addTermConstraints(SearchCriteria params, StringBuilder constraints, JCRSessionWrapper session, boolean xpath) {
        for (SearchCriteria.Term textSearch : params.getTerms()) {
            if (textSearch.isEmpty()) continue;
            String searchExpression = this.getSearchExpressionForMatchType(textSearch.getTerm(), textSearch.getMatch(), textSearch.isApplyFilter());
            SearchCriteria.Term.SearchFields searchFields = textSearch.getFields();
            StringBuilder textSearchConstraints = new StringBuilder(256);
            if (!(!searchFields.isSiteContent() && (searchFields.isTags() || searchFields.isFileContent() || searchFields.isDescription() || searchFields.isTitle() || searchFields.isKeywords() || searchFields.isFilename()))) {
                this.addConstraint(textSearchConstraints, "or", xpath ? "jcr:contains(., " + searchExpression + ")" : "contains(n, " + searchExpression + ")");
            }
            if (searchFields.isFileContent()) {
                if (xpath) {
                    this.addConstraint(textSearchConstraints, "or", "jcr:contains(jcr:content," + searchExpression + ")");
                } else {
                    this.addConstraint(textSearchConstraints, "or", this.getContainsExpr("jcr:content", searchExpression, xpath));
                }
            }
            if (searchFields.isDescription()) {
                this.addConstraint(textSearchConstraints, "or", this.getContainsExpr("jcr:description", searchExpression, xpath));
            }
            if (searchFields.isTitle()) {
                this.addConstraint(textSearchConstraints, "or", this.getContainsExpr("jcr:title", searchExpression, xpath));
            }
            if (searchFields.isKeywords()) {
                this.addConstraint(textSearchConstraints, "or", this.getContainsExpr("jcr:keywords", searchExpression, xpath));
            }
            if (searchFields.isFilename()) {
                String[] terms = null;
                String constraint = "or";
                if (textSearch.getMatch() == SearchCriteria.Term.MatchType.ANY_WORD || textSearch.getMatch() == SearchCriteria.Term.MatchType.ALL_WORDS || textSearch.getMatch() == SearchCriteria.Term.MatchType.WITHOUT_WORDS) {
                    terms = Patterns.SPACE.split(this.cleanMultipleWhiteSpaces(textSearch.getTerm()));
                    if (textSearch.getMatch() == SearchCriteria.Term.MatchType.ALL_WORDS || textSearch.getMatch() == SearchCriteria.Term.MatchType.WITHOUT_WORDS) {
                        constraint = "and";
                    }
                } else {
                    terms = new String[]{textSearch.getTerm()};
                }
                StringBuilder nameSearchConstraints = new StringBuilder(256);
                for (String term : terms) {
                    String termConstraint;
                    String likeTerm = term.contains("*") ? JCRContentUtils.stringToQueryLiteral(StringUtils.replaceChars((String)term, (char)'*', (char)'%')) : JCRContentUtils.stringToQueryLiteral("%" + term + "%");
                    String string = termConstraint = xpath ? "jcr:like(fn:name(), " + likeTerm + ")" : "localname(n) like " + likeTerm;
                    if (textSearch.getMatch() == SearchCriteria.Term.MatchType.WITHOUT_WORDS) {
                        termConstraint = "not(" + termConstraint + ")";
                    }
                    this.addConstraint(nameSearchConstraints, constraint, termConstraint);
                }
                this.addConstraint(textSearchConstraints, "or", nameSearchConstraints.toString());
            }
            if (searchFields.isTags() && this.getTaggingService() != null && (params.getSites().getValue() != null || params.getOriginSiteKey() != null) && !StringUtils.containsAny((String)textSearch.getTerm(), (String)"?*")) {
                try {
                    JCRNodeWrapper tag = this.getTaggingService().getTag(textSearch.getTerm(), params.getSites().getValue() != null ? params.getSites().getValue() : params.getOriginSiteKey(), session);
                    if (tag != null) {
                        this.addConstraint(textSearchConstraints, "or", this.getPropertyName("j:tags", xpath) + "=" + JCRContentUtils.stringToJCRSearchExp(tag.getIdentifier()));
                    }
                }
                catch (RepositoryException e) {
                    logger.warn("Error resolving tag for search", (Throwable)e);
                }
            }
            if (textSearchConstraints.length() <= 0) continue;
            this.addConstraint(constraints, "and", "(" + textSearchConstraints.toString() + ")");
        }
    }

    /*
     * Unable to fully structure code
     */
    private void addLanguageConstraints(SearchCriteria params, StringBuilder constraints, boolean xpath) {
        languageSearchConstraints = new StringBuilder(256);
        if (!params.getLanguages().isEmpty()) {
            for (String languageCode : params.getLanguages().getValues()) {
                if (languageCode == null || languageCode.length() == 0) continue;
                this.addConstraint(languageSearchConstraints, "or", this.getPropertyName("jcr:language", xpath) + "=" + JCRContentUtils.stringToJCRSearchExp(languageCode.trim()));
            }
        } else {
            try {
                jcrService = ServicesRegistry.getInstance().getJCRStoreService();
                session = jcrService.getSessionFactory().getCurrentUserSession();
                if (session.getLocale() == null) ** GOTO lbl18
                this.addConstraint(languageSearchConstraints, "or", this.getPropertyName("jcr:language", xpath) + "=" + JCRContentUtils.stringToJCRSearchExp(session.getLocale().toString()));
            }
            catch (RepositoryException e) {
                // empty catch block
            }
        }
lbl18:
        // 4 sources

        if (languageSearchConstraints.length() > 0) {
            this.addConstraint(languageSearchConstraints, "or", xpath != false ? "not(@jcr:language)" : "[jcr:language] is null");
            this.addConstraint(constraints, "and", "(" + languageSearchConstraints.toString() + ")");
        }
    }

    private String getMimeTypeConstraint(String mimeType, boolean xpath) {
        if (xpath) {
            return mimeType.contains("*") ? "jcr:like(jcr:content/@jcr:mimeType," + JCRContentUtils.stringToQueryLiteral(StringUtils.replaceChars((String)mimeType, (char)'*', (char)'%')) + ")" : "jcr:content/@jcr:mimeType=" + JCRContentUtils.stringToQueryLiteral(mimeType);
        }
        return "n.[jcr:mimetype]=" + JCRContentUtils.stringToQueryLiteral(mimeType);
    }

    private String getDateLiteral(Calendar date, boolean xpath) {
        return xpath ? "xs:dateTime('" + ISO8601.format((Calendar)date) + "')" : "'" + ISO8601.format((Calendar)date) + "'";
    }

    private String getPropertyName(String paramName, boolean xpath) {
        return xpath ? "@" + paramName : "n.[" + paramName + "]";
    }

    private String getContainsExpr(String paramName, String expr, boolean xpath) {
        if (xpath) {
            return "jcr:contains(" + this.getPropertyName(paramName, xpath) + "," + expr + ")";
        }
        return "contains(" + this.getPropertyName(paramName, xpath) + "," + expr + ")";
    }

    private String getSearchExpressionForMatchType(String term, SearchCriteria.Term.MatchType matchType, boolean applyFilter) {
        return this.getSearchExpressionForMatchType(term, matchType, applyFilter, null);
    }

    private String getSearchExpressionForMatchType(String term, SearchCriteria.Term.MatchType matchType, boolean applyFilter, String postfix) {
        if (applyFilter && StringUtils.containsAny((String)term, (String)"?*")) {
            term = this.removeAccents(term);
        }
        if (SearchCriteria.Term.MatchType.AS_IS != matchType) {
            term = QueryParser.escape((String)NOT_PATTERN.matcher(OR_PATTERN.matcher(AND_PATTERN.matcher(term).replaceAll(" and ")).replaceAll(" or ")).replaceAll(" not "));
        }
        if (SearchCriteria.Term.MatchType.ANY_WORD == matchType) {
            term = StringUtils.replace((String)this.cleanMultipleWhiteSpaces(term), (String)" ", (String)" OR ");
        } else if (SearchCriteria.Term.MatchType.EXACT_PHRASE == matchType) {
            term = "\"" + term.trim() + "\"";
        } else if (SearchCriteria.Term.MatchType.WITHOUT_WORDS == matchType) {
            term = "* -" + StringUtils.replace((String)this.cleanMultipleWhiteSpaces(term), (String)" ", (String)" -");
        }
        return JCRContentUtils.stringToJCRSearchExp(postfix != null ? term + postfix : term);
    }

    private String removeAccents(String term) {
        int size;
        int length = term.length();
        char[] input = new char[length];
        term.getChars(0, length, input, 0);
        char[] output = new char[length];
        int maxSizeNeeded = 2 * length;
        for (size = output.length; size < maxSizeNeeded; size *= 2) {
        }
        if (size != output.length) {
            output = new char[size];
        }
        int outputPos = 0;
        int pos = 0;
        int i = 0;
        while (i < length) {
            char c = input[pos];
            if (c < '\u00c0' || c > '\ufb06') {
                output[outputPos++] = c;
            } else {
                switch (c) {
                    case '\u00c0': 
                    case '\u00c1': 
                    case '\u00c2': 
                    case '\u00c3': 
                    case '\u00c4': 
                    case '\u00c5': {
                        output[outputPos++] = 65;
                        break;
                    }
                    case '\u00c6': {
                        output[outputPos++] = 65;
                        output[outputPos++] = 69;
                        break;
                    }
                    case '\u00c7': {
                        output[outputPos++] = 67;
                        break;
                    }
                    case '\u00c8': 
                    case '\u00c9': 
                    case '\u00ca': 
                    case '\u00cb': {
                        output[outputPos++] = 69;
                        break;
                    }
                    case '\u00cc': 
                    case '\u00cd': 
                    case '\u00ce': 
                    case '\u00cf': {
                        output[outputPos++] = 73;
                        break;
                    }
                    case '\u0132': {
                        output[outputPos++] = 73;
                        output[outputPos++] = 74;
                        break;
                    }
                    case '\u00d0': {
                        output[outputPos++] = 68;
                        break;
                    }
                    case '\u00d1': {
                        output[outputPos++] = 78;
                        break;
                    }
                    case '\u00d2': 
                    case '\u00d3': 
                    case '\u00d4': 
                    case '\u00d5': 
                    case '\u00d6': 
                    case '\u00d8': {
                        output[outputPos++] = 79;
                        break;
                    }
                    case '\u0152': {
                        output[outputPos++] = 79;
                        output[outputPos++] = 69;
                        break;
                    }
                    case '\u00de': {
                        output[outputPos++] = 84;
                        output[outputPos++] = 72;
                        break;
                    }
                    case '\u00d9': 
                    case '\u00da': 
                    case '\u00db': 
                    case '\u00dc': {
                        output[outputPos++] = 85;
                        break;
                    }
                    case '\u00dd': 
                    case '\u0178': {
                        output[outputPos++] = 89;
                        break;
                    }
                    case '\u00e0': 
                    case '\u00e1': 
                    case '\u00e2': 
                    case '\u00e3': 
                    case '\u00e4': 
                    case '\u00e5': {
                        output[outputPos++] = 97;
                        break;
                    }
                    case '\u00e6': {
                        output[outputPos++] = 97;
                        output[outputPos++] = 101;
                        break;
                    }
                    case '\u00e7': {
                        output[outputPos++] = 99;
                        break;
                    }
                    case '\u00e8': 
                    case '\u00e9': 
                    case '\u00ea': 
                    case '\u00eb': {
                        output[outputPos++] = 101;
                        break;
                    }
                    case '\u00ec': 
                    case '\u00ed': 
                    case '\u00ee': 
                    case '\u00ef': {
                        output[outputPos++] = 105;
                        break;
                    }
                    case '\u0133': {
                        output[outputPos++] = 105;
                        output[outputPos++] = 106;
                        break;
                    }
                    case '\u00f0': {
                        output[outputPos++] = 100;
                        break;
                    }
                    case '\u00f1': {
                        output[outputPos++] = 110;
                        break;
                    }
                    case '\u00f2': 
                    case '\u00f3': 
                    case '\u00f4': 
                    case '\u00f5': 
                    case '\u00f6': 
                    case '\u00f8': {
                        output[outputPos++] = 111;
                        break;
                    }
                    case '\u0153': {
                        output[outputPos++] = 111;
                        output[outputPos++] = 101;
                        break;
                    }
                    case '\u00df': {
                        output[outputPos++] = 115;
                        output[outputPos++] = 115;
                        break;
                    }
                    case '\u00fe': {
                        output[outputPos++] = 116;
                        output[outputPos++] = 104;
                        break;
                    }
                    case '\u00f9': 
                    case '\u00fa': 
                    case '\u00fb': 
                    case '\u00fc': {
                        output[outputPos++] = 117;
                        break;
                    }
                    case '\u00fd': 
                    case '\u00ff': {
                        output[outputPos++] = 121;
                        break;
                    }
                    case '\ufb00': {
                        output[outputPos++] = 102;
                        output[outputPos++] = 102;
                        break;
                    }
                    case '\ufb01': {
                        output[outputPos++] = 102;
                        output[outputPos++] = 105;
                        break;
                    }
                    case '\ufb02': {
                        output[outputPos++] = 102;
                        output[outputPos++] = 108;
                        break;
                    }
                    case '\ufb05': {
                        output[outputPos++] = 102;
                        output[outputPos++] = 116;
                        break;
                    }
                    case '\ufb06': {
                        output[outputPos++] = 115;
                        output[outputPos++] = 116;
                        break;
                    }
                    default: {
                        output[outputPos++] = c;
                    }
                }
            }
            ++i;
            ++pos;
        }
        return new String(output).trim();
    }

    private String cleanMultipleWhiteSpaces(String term) {
        return MULTIPLE_SPACES_PATTERN.matcher(term).replaceAll(" ");
    }

    @Override
    public Suggestion suggest(String originalQuery, RenderContext context, int maxTerms) {
        if (StringUtils.isBlank((String)originalQuery)) {
            return null;
        }
        String siteKey = context.getSite().getSiteKey();
        Locale locale = context.getMainResourceLocale();
        Suggestion suggestion = null;
        try {
            JCRSessionWrapper session = ServicesRegistry.getInstance().getJCRStoreService().getSessionFactory().getCurrentUserSession(context.getWorkspace(), locale);
            QueryManagerWrapper qm = session.getWorkspace().getQueryManager();
            StringBuilder xpath = new StringBuilder(64);
            xpath.append("/jcr:root[rep:spellcheck(").append(JCRContentUtils.stringToJCRSearchExp(originalQuery + "#!#" + "maxTerms" + "=" + maxTerms)).append(")");
            if (locale != null) {
                xpath.append(" or @jcr:language='").append(locale).append("'");
            }
            xpath.append("]");
            if (siteKey != null) {
                xpath.append("/sites/").append(siteKey);
            }
            xpath.append("/(rep:spellcheck())");
            Query query = qm.createQuery(xpath.toString(), "xpath");
            RowIterator rows = query.execute().getRows();
            if (rows.hasNext()) {
                Row r = rows.nextRow();
                Value v = r.getValue("rep:spellcheck()");
                if (v != null) {
                    String[] suggestions = StringUtils.splitByWholeSeparator((String)v.getString(), (String)"#!#");
                    suggestion = new Suggestion(originalQuery, suggestions[0], Arrays.asList(suggestions));
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Making spell check suggestion for '" + originalQuery + "' site '" + siteKey + "' and locale '" + locale + "' using XPath query [" + xpath.toString() + "]. Result suggestion: " + suggestion);
                }
            }
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return suggestion;
    }

    public Query buildQuery(SearchCriteria criteria, JCRSessionWrapper session) throws InvalidQueryException, RepositoryException {
        QueryWrapper query = null;
        String xpathQuery = this.buildXpathQuery(criteria, session);
        String sql = this.buildSQLQuery(criteria, session);
        if (!StringUtils.isEmpty((String)xpathQuery)) {
            QueryManagerWrapper qm = session.getWorkspace().getQueryManager();
            query = qm.createDualQuery(xpathQuery, "xpath", sql);
        }
        return query;
    }

    public TaggingService getTaggingService() {
        return this.taggingService;
    }

    public void setTaggingService(TaggingService taggingService) {
        this.taggingService = taggingService;
    }

    public void setTypesToHideFromSearchResults(Set<String> typesToHideFromSearchResults) {
        this.typesToHideFromSearchResults = typesToHideFromSearchResults;
    }
}

