/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.seo.filter;

import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.URLResolver;
import org.jahia.services.render.URLResolverFactory;
import org.jahia.services.render.filter.HtmlTagAttributeTraverser;
import org.jahia.services.seo.VanityUrl;
import org.jahia.services.seo.jcr.VanityUrlService;
import org.jahia.utils.Url;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VanityUrlSetter
implements HtmlTagAttributeTraverser.HtmlTagAttributeVisitor {
    private static transient Logger logger = LoggerFactory.getLogger(VanityUrlSetter.class);
    private VanityUrlService vanityUrlService;
    private URLResolverFactory urlResolverFactory;

    @Override
    public String visit(String attrValue, RenderContext context, String tagName, String attrName, Resource resource) {
        URLResolver urlResolver;
        String value = attrValue;
        if (StringUtils.isNotEmpty((String)attrValue) && !Url.isLocalhost(context.getRequest().getServerName()) && attrValue.startsWith(context.getRequest().getContextPath().length() > 0 ? context.getRequest().getContextPath() + context.getServletPath() : context.getServletPath()) && (urlResolver = this.urlResolverFactory.createURLResolver(attrValue, context)).isMapped()) {
            try {
                VanityUrl vanityUrl = this.vanityUrlService.getVanityUrlForWorkspaceAndLocale(urlResolver.getNode(), urlResolver.getWorkspace(), urlResolver.getLocale(), context.getSite().getSiteKey());
                if (vanityUrl != null && vanityUrl.isActive()) {
                    value = attrValue.replace("/" + urlResolver.getLocale() + urlResolver.getPath(), vanityUrl.getUrl());
                }
            }
            catch (RepositoryException e) {
                logger.debug("Error when trying to obtain vanity url", (Throwable)e);
            }
        }
        return value;
    }

    public void setVanityUrlService(VanityUrlService vanityUrlService) {
        this.vanityUrlService = vanityUrlService;
    }

    public void setUrlResolverFactory(URLResolverFactory urlResolverFactory) {
        this.urlResolverFactory = urlResolverFactory;
    }
}

