/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.seo.urlrewrite;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URLDecoder;
import java.util.Arrays;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.jahia.bin.Render;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.URLResolver;
import org.jahia.services.render.URLResolverFactory;
import org.jahia.services.seo.VanityUrl;
import org.jahia.services.seo.jcr.VanityUrlService;
import org.jahia.services.seo.urlrewrite.Configuration;
import org.jahia.utils.Url;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.tuckey.web.filters.urlrewrite.Conf;
import org.tuckey.web.filters.urlrewrite.RewrittenOutboundUrl;
import org.tuckey.web.filters.urlrewrite.RewrittenUrl;
import org.tuckey.web.filters.urlrewrite.UrlRewriter;

class UrlRewriteEngine
extends UrlRewriter {
    private static final Logger logger = LoggerFactory.getLogger(UrlRewriteEngine.class);
    private URLResolverFactory urlResolverFactory;
    private VanityUrlService vanityUrlService;
    private boolean urlRewriteSeoRulesEnabled;

    public void setUrlResolverFactory(URLResolverFactory urlResolverFactory) {
        this.urlResolverFactory = urlResolverFactory;
    }

    public void setVanityUrlService(VanityUrlService vanityUrlService) {
        this.vanityUrlService = vanityUrlService;
    }

    private static Configuration getConfiguration(ServletContext context, Resource[] confLocations) {
        Configuration cfg = null;
        if (confLocations == null || confLocations.length == 0) {
            logger.warn("No configuration resource location specified for the URL rewrite engine. Using empty one.");
            return new Configuration();
        }
        try {
            cfg = new Configuration(context, confLocations);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        return cfg;
    }

    UrlRewriteEngine(InputStream is, String fileName) {
        super((Conf)new Configuration(is, fileName));
        logger.info("Loaded URL rewrite rules from {}", (Object)fileName);
    }

    public UrlRewriteEngine(ServletContext context, Resource[] confLocations) {
        super((Conf)UrlRewriteEngine.getConfiguration(context, confLocations));
        if (confLocations != null) {
            logger.info("Loaded URL rewrite rules from {}", confLocations != null ? Arrays.asList(confLocations) : null);
        }
    }

    public RewrittenUrl rewriteInbound(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException, InvocationTargetException {
        return this.processRequest(request, response);
    }

    public String rewriteOutbound(String url, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException, InvocationTargetException {
        RewrittenOutboundUrl rou = this.processEncodeURL(response, request, false, url);
        if (rou == null) {
            return response.encodeURL(url);
        }
        if (rou.isEncode()) {
            rou.setTarget(response.encodeURL(rou.getTarget()));
        }
        return this.processEncodeURL(response, request, true, rou.getTarget()).getTarget();
    }

    protected RewrittenOutboundUrl processEncodeURL(HttpServletResponse hsResponse, HttpServletRequest hsRequest, boolean encodeUrlHasBeenRun, String outboundUrl) {
        block9: {
            try {
                String ctx = StringUtils.defaultIfEmpty((String)hsRequest.getContextPath(), null);
                if (!outboundUrl.startsWith(ctx != null ? ctx + Render.getRenderServletPath() : Render.getRenderServletPath()) || !StringUtils.isNotEmpty((String)outboundUrl) || Url.isLocalhost(hsRequest.getServerName())) break block9;
                String url = StringUtils.substringAfter((String)outboundUrl, (String)(ctx != null ? ctx + "/cms" : "/cms"));
                url = StringUtils.substringBefore((String)url, (String)"?");
                url = StringUtils.substringBefore((String)url, (String)"#");
                url = StringUtils.substringBefore((String)url, (String)";");
                url = URLDecoder.decode(url, "UTF-8");
                URLResolver urlResolver = this.urlResolverFactory.createURLResolver(url, hsRequest.getServerName(), hsRequest);
                JCRNodeWrapper node = urlResolver.getNode();
                if (urlResolver.isMapped()) {
                    try {
                        RenderContext context = (RenderContext)hsRequest.getAttribute("renderContext");
                        VanityUrl vanityUrl = this.vanityUrlService.getVanityUrlForWorkspaceAndLocale(node, urlResolver.getWorkspace(), urlResolver.getLocale(), context != null ? context.getSite().getSiteKey() : null);
                        if (vanityUrl != null && vanityUrl.isActive()) {
                            outboundUrl = outboundUrl.replace("/" + urlResolver.getLocale() + urlResolver.getPath(), vanityUrl.getUrl());
                        }
                    }
                    catch (RepositoryException e) {
                        logger.debug("Error when trying to obtain vanity url", (Throwable)e);
                    }
                }
                if (!this.isUrlRewriteSeoRulesEnabled()) {
                    try {
                        outboundUrl = Url.appendServerNameIfNeeded(node, outboundUrl, hsRequest);
                    }
                    catch (PathNotFoundException e) {}
                }
            }
            catch (Exception e) {
                logger.debug("Cannot parse url for rewriting : " + outboundUrl, (Throwable)e);
            }
        }
        return super.processEncodeURL(hsResponse, hsRequest, encodeUrlHasBeenRun, outboundUrl);
    }

    public boolean isUrlRewriteSeoRulesEnabled() {
        return this.urlRewriteSeoRulesEnabled;
    }

    public void setUrlRewriteSeoRulesEnabled(boolean urlRewriteSeoRulesEnabled) {
        this.urlRewriteSeoRulesEnabled = urlRewriteSeoRulesEnabled;
    }
}

