/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.seo.urlrewrite;

import org.apache.commons.lang.StringUtils;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.filter.AbstractFilter;
import org.jahia.services.render.filter.HtmlTagAttributeTraverser;
import org.jahia.services.seo.urlrewrite.UrlRewriteService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlRewriteVisitor
implements HtmlTagAttributeTraverser.HtmlTagAttributeVisitor {
    private static Logger logger = LoggerFactory.getLogger(UrlRewriteVisitor.class);
    private String[] applyOnModes;
    private UrlRewriteService urlRewriteService;

    private boolean preconditionsMatch(String attrValue, RenderContext context, Resource resource) {
        if (StringUtils.isEmpty((String)attrValue)) {
            return false;
        }
        if (this.applyOnModes != null && this.applyOnModes.length > 0) {
            for (String mode : this.applyOnModes) {
                if (!AbstractFilter.ModeCondition.matches(context, mode)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public void setApplyOnModes(String[] applyOnModes) {
        this.applyOnModes = applyOnModes;
    }

    @Override
    public String visit(String attrValue, RenderContext context, String tagName, String attrName, Resource resource) {
        String value = attrValue;
        if (this.preconditionsMatch(attrValue, context, resource)) {
            long timer = System.currentTimeMillis();
            try {
                String rewritten;
                value = rewritten = this.urlRewriteService.rewriteOutbound(attrValue, context.getRequest(), context.getResponse());
            }
            catch (Exception e) {
                logger.error("Error rewriting URL value " + attrValue + " Skipped rewriting.", (Throwable)e);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Rewriting URL {} into {} took {} ms", new Object[]{attrValue, value, System.currentTimeMillis() - timer});
            }
        }
        return value;
    }

    public void setUrlRewriteService(UrlRewriteService urlRewriteService) {
        this.urlRewriteService = urlRewriteService;
    }
}

