/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.tags;

import java.util.ArrayList;
import java.util.Arrays;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.JCRValueWrapper;
import org.jahia.utils.Patterns;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaggingService {
    private static Logger logger = LoggerFactory.getLogger(TaggingService.class);

    private static String getTagsPath(String siteKey) {
        if (siteKey == null || siteKey.length() == 0) {
            throw new IllegalArgumentException("The site key cannot be null or empty.");
        }
        return "/sites/" + siteKey + "/tags";
    }

    public boolean createTag(final String tag, final String siteKey) throws RepositoryException {
        return JCRTemplate.getInstance().doExecuteWithSystemSession(new JCRCallback<Boolean>(){

            @Override
            public Boolean doInJCR(JCRSessionWrapper session) throws RepositoryException {
                JCRNodeWrapper existingNode = TaggingService.this.getTag(tag, siteKey, session);
                if (existingNode == null) {
                    TaggingService.this.createTag(tag, siteKey, session);
                    session.save();
                }
                return existingNode == null;
            }
        });
    }

    private JCRNodeWrapper createTag(String tag, String siteKey, JCRSessionWrapper session) throws RepositoryException {
        JCRNodeWrapper node = null;
        String tagsPath = TaggingService.getTagsPath(siteKey);
        JCRNodeWrapper tagTreeNode = session.getNode(tagsPath);
        if (tagTreeNode != null) {
            session.checkout(tagTreeNode);
            node = tagTreeNode.addNode(tag, "jnt:tag");
        } else {
            logger.error("No tags folder found for the path " + tagsPath + ". Skip creating new tag");
        }
        return node;
    }

    public boolean deleteTag(final String tag, final String siteKey) throws RepositoryException {
        return JCRTemplate.getInstance().doExecuteWithSystemSession(new JCRCallback<Boolean>(){

            @Override
            public Boolean doInJCR(JCRSessionWrapper session) throws RepositoryException {
                String tagsPath = TaggingService.getTagsPath(siteKey);
                JCRNodeWrapper tagNode = null;
                try {
                    tagNode = session.getNode(tagsPath + "/" + tag);
                }
                catch (PathNotFoundException ex) {
                    // empty catch block
                }
                if (tagNode != null) {
                    JCRNodeWrapper parent = tagNode.getParent();
                    session.checkout(parent);
                    session.checkout(tagNode);
                    tagNode.remove();
                    session.save();
                }
                return tagNode != null;
            }
        });
    }

    public boolean exists(final String tag, final String siteKey) throws RepositoryException {
        return JCRTemplate.getInstance().doExecuteWithSystemSession(new JCRCallback<Boolean>(){

            @Override
            public Boolean doInJCR(JCRSessionWrapper session) throws RepositoryException {
                JCRNodeWrapper tagNode = TaggingService.this.getTag(tag, siteKey, session);
                return tagNode != null;
            }
        });
    }

    public JCRNodeWrapper getTag(String tag, String siteKey, JCRSessionWrapper session) throws RepositoryException {
        JCRNodeWrapper node = null;
        try {
            node = session.getNode(TaggingService.getTagsPath(siteKey) + "/" + JCRContentUtils.escapeLocalNodeName(tag));
        }
        catch (PathNotFoundException ex) {
            // empty catch block
        }
        return node;
    }

    public long getTagCount(final String tag, final String siteKey) throws RepositoryException {
        return JCRTemplate.getInstance().doExecuteWithSystemSession(new JCRCallback<Long>(){

            @Override
            public Long doInJCR(JCRSessionWrapper session) throws RepositoryException {
                JCRNodeWrapper tagNode = TaggingService.this.getTag(tag, siteKey, session);
                return tagNode != null ? tagNode.getWeakReferences().getSize() : -1L;
            }
        });
    }

    public boolean tag(final JCRNodeWrapper node, final String tag, final String siteKey, final boolean createTagIfNotExists) throws RepositoryException {
        return JCRTemplate.getInstance().doExecuteWithSystemSession(node.getSession().getUser().getUsername(), node.getSession().getWorkspace().getName(), node.getSession().getLocale(), new JCRCallback<Boolean>(){

            @Override
            public Boolean doInJCR(JCRSessionWrapper session) throws RepositoryException {
                return TaggingService.this.tag(node.getPath(), tag, siteKey, createTagIfNotExists, session);
            }
        });
    }

    public boolean tag(String nodePath, String tag, String siteKey, boolean createTagIfNotExists, JCRSessionWrapper session) throws RepositoryException {
        boolean applied = false;
        boolean doSessionCommit = false;
        String[] tags = Patterns.COMMA.split(tag);
        JCRNodeWrapper node = session.getNode(nodePath);
        for (String t : tags) {
            if ("".equals(t = t.trim())) continue;
            JCRNodeWrapper tagNode = this.getTag(t, siteKey, session);
            if (tagNode == null && createTagIfNotExists) {
                tagNode = this.createTag(t, siteKey, session);
                doSessionCommit = true;
            }
            if (tagNode == null) continue;
            JCRValueWrapper[] values = null;
            boolean exists = false;
            if (node.hasProperty("j:tags")) {
                for (JCRValueWrapper existingValue : values = node.getProperty("j:tags").getValues()) {
                    if (!tagNode.getIdentifier().equals(existingValue.getString())) continue;
                    exists = true;
                    break;
                }
            }
            if (!exists) {
                ArrayList<Value> newValues = new ArrayList<Value>();
                if (values != null) {
                    newValues.addAll(Arrays.asList(values));
                }
                newValues.add(session.getValueFactory().createValue(tagNode.getIdentifier(), 10));
                session.checkout(node);
                if (!node.isNodeType("jmix:tagged")) {
                    node.addMixin("jmix:tagged");
                }
                node.setProperty("j:tags", newValues.toArray(new Value[newValues.size()]));
                applied = true;
                doSessionCommit = true;
            }
            if (!doSessionCommit) continue;
            session.save();
        }
        return applied;
    }

    public boolean tag(final String nodePath, final String tag, final String siteKey, final boolean createTagIfNotExists) throws RepositoryException {
        return JCRTemplate.getInstance().doExecuteWithSystemSession(new JCRCallback<Boolean>(){

            @Override
            public Boolean doInJCR(JCRSessionWrapper session) throws RepositoryException {
                return TaggingService.this.tag(nodePath, tag, siteKey, createTagIfNotExists, session);
            }
        });
    }
}

