/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.tasks;

import java.security.Principal;
import java.util.Calendar;
import java.util.Set;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.tasks.Task;
import org.jahia.services.usermanager.JahiaGroup;
import org.jahia.services.usermanager.JahiaGroupManagerService;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskService {
    private static Logger logger = LoggerFactory.getLogger(TaskService.class);
    private JahiaGroupManagerService groupManager;
    private JahiaUserManagerService userManagerService;

    private static String getTasksPath(String userPath) {
        if (userPath == null || userPath.length() == 0) {
            throw new IllegalArgumentException("The user name cannot be null or empty.");
        }
        return userPath + "/tasks";
    }

    public void createTask(final Task task, final String forUser) throws RepositoryException {
        JCRTemplate.getInstance().doExecuteWithSystemSessionInSameWorkspaceAndLocale(new JCRCallback<Boolean>(){

            @Override
            public Boolean doInJCR(JCRSessionWrapper session) throws RepositoryException {
                TaskService.this.createTask(task, forUser, session);
                session.save();
                return true;
            }
        });
    }

    private void createTask(Task task, String forUser, JCRSessionWrapper session) throws RepositoryException {
        JCRNodeWrapper tasksNode = this.getUserTasksNode(forUser, session);
        session.checkout(tasksNode);
        JCRNodeWrapper taskNode = tasksNode.addNode(JCRContentUtils.findAvailableNodeName(tasksNode, "task"), "jnt:task");
        if (task.getTitle() != null) {
            taskNode.setProperty("jcr:title", task.getTitle());
        }
        if (task.getDescription() != null) {
            taskNode.setProperty("description", task.getDescription());
        }
        taskNode.setProperty("priority", task.getPriority().toString().toLowerCase());
        if (task.getDueDate() != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(task.getDueDate());
            taskNode.setProperty("dueDate", calendar);
        }
        taskNode.setProperty("state", task.getState().toString().toLowerCase());
        try {
            taskNode.setProperty("assignee", session.getNode(this.userManagerService.getUserSplittingRule().getPathForUsername(forUser)).getIdentifier());
        }
        catch (Exception e) {
            logger.warn("Unable to find user '" + forUser + "' to assign a task", (Throwable)e);
        }
    }

    public void createTaskForGroup(final Task task, String forGroup, int siteId) throws RepositoryException {
        JahiaGroup group = this.groupManager.lookupGroup(siteId, forGroup);
        if (group == null) {
            logger.warn("Group with the name '" + forGroup + "' is not found in site with ID '" + siteId + "'. Skipping creating tasks.");
            return;
        }
        final Set<Principal> members = group.getRecursiveUserMembers();
        if (logger.isDebugEnabled()) {
            if (members.isEmpty()) {
                logger.warn("Group with the name '" + forGroup + "' in site with ID '" + siteId + "' has not members. Skipping creating tasks.");
            } else {
                logger.warn("Creating task for " + members.size() + " members of the group '" + forGroup + "' in site with ID '" + siteId + "'.");
            }
        }
        if (!members.isEmpty()) {
            JCRTemplate.getInstance().doExecuteWithSystemSession(new JCRCallback<Boolean>(){

                @Override
                public Boolean doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    for (Principal principal : members) {
                        TaskService.this.createTask(task, principal.getName(), session);
                    }
                    session.save();
                    return true;
                }
            });
        }
    }

    private JCRNodeWrapper getUserTasksNode(String username, JCRSessionWrapper session) throws RepositoryException {
        JCRNodeWrapper tasksNode = null;
        String pathForUsername = this.userManagerService.getUserSplittingRule().getPathForUsername(username);
        try {
            tasksNode = session.getNode(TaskService.getTasksPath(pathForUsername));
        }
        catch (PathNotFoundException ex) {
            // empty catch block
        }
        if (tasksNode == null) {
            JCRNodeWrapper userNode = session.getNode(pathForUsername);
            session.checkout(userNode);
            tasksNode = userNode.addNode("tasks", "jnt:tasks");
        }
        return tasksNode;
    }

    public void setGroupManager(JahiaGroupManagerService groupManager) {
        this.groupManager = groupManager;
    }

    public void setUserManagerService(JahiaUserManagerService userManagerService) {
        this.userManagerService = userManagerService;
    }
}

