/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.templates;

import java.io.File;
import java.io.IOException;
import java.util.List;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.Source;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.StatusLine;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Model;
import org.apache.xerces.impl.dv.util.Base64;
import org.jahia.data.templates.ModuleReleaseInfo;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ForgeHelper {
    private static Logger logger = LoggerFactory.getLogger(ForgeHelper.class);

    ForgeHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String createForgeModule(ModuleReleaseInfo releaseInfo, File jar) throws IOException {
        String moduleUrl = null;
        String url = releaseInfo.getForgeUrl();
        HttpClient client = new HttpClient();
        GetMethod getMethod = new GetMethod(url + "/home.html");
        getMethod.addRequestHeader("Authorization", "Basic " + Base64.encode((byte[])(releaseInfo.getUsername() + ":" + releaseInfo.getPassword()).getBytes()));
        client.executeMethod((HttpMethod)getMethod);
        Source source = new Source((CharSequence)getMethod.getResponseBodyAsString());
        String token = "";
        if (source.getFirstElementByClass("file_upload") != null) {
            List els = source.getFirstElementByClass("file_upload").getAllElements("input");
            for (Element el : els) {
                if (!StringUtils.equals((String)el.getAttributeValue("name"), (String)"form-token")) continue;
                token = el.getAttributeValue("value");
            }
        } else {
            throw new IOException("Unable to get Private App Store site information, please check your credentials");
        }
        Part[] parts = new Part[]{new StringPart("form-token", token), new FilePart("file", jar)};
        PostMethod postMethod = new PostMethod(url + "/contents/modules-repository.createModuleFromJar.do");
        postMethod.getParams().setSoTimeout(0);
        postMethod.addRequestHeader("Authorization", "Basic " + Base64.encode((byte[])(releaseInfo.getUsername() + ":" + releaseInfo.getPassword()).getBytes()));
        postMethod.addRequestHeader("accept", "application/json");
        postMethod.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, postMethod.getParams()));
        String result = null;
        try {
            client.executeMethod(null, (HttpMethod)postMethod);
            StatusLine statusLine = postMethod.getStatusLine();
            if (statusLine != null && statusLine.getStatusCode() == 200) {
                result = postMethod.getResponseBodyAsString();
            } else {
                logger.warn("Connection to URL: " + url + " failed with status " + statusLine);
            }
        }
        catch (HttpException e) {
            logger.error("Unable to get the content of the URL: " + url + ". Cause: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error("Unable to get the content of the URL: " + url + ". Cause: " + e.getMessage(), (Throwable)e);
        }
        finally {
            postMethod.releaseConnection();
        }
        if (StringUtils.isNotEmpty((String)result)) {
            try {
                JSONObject json = new JSONObject(result);
                if (json.isNull("moduleAbsoluteUrl")) {
                    if (!json.isNull("error")) {
                        throw new IOException(json.getString("error"));
                    }
                    logger.warn("Cannot find 'moduleAbsoluteUrl' entry in the create module actin response: {}", (Object)result);
                    throw new IOException("unknown");
                }
                moduleUrl = json.getString("moduleAbsoluteUrl");
            }
            catch (JSONException e) {
                logger.error("Unable to parse the response of the module creation action. Cause: " + e.getMessage(), (Throwable)e);
            }
        }
        return moduleUrl;
    }

    String computeModuleJarUrl(String releaseVersion, ModuleReleaseInfo releaseInfo, Model model) {
        String groupId;
        StringBuilder url = new StringBuilder(64);
        url.append(releaseInfo.getRepositoryUrl());
        if (!releaseInfo.getRepositoryUrl().endsWith("/")) {
            url.append("/");
        }
        if ((groupId = model.getGroupId()) == null && model.getParent() != null) {
            groupId = model.getParent().getGroupId();
        }
        url.append(StringUtils.replace((String)groupId, (String)".", (String)"/"));
        url.append("/");
        url.append(model.getArtifactId());
        url.append("/");
        url.append(releaseVersion);
        url.append("/");
        url.append(model.getArtifactId());
        url.append("-");
        url.append(releaseVersion);
        url.append(".");
        String packaging = model.getPackaging();
        url.append(packaging == null || packaging.equals("bundle") ? "jar" : packaging);
        return url.toString();
    }
}

