/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.templates;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.RepositoryException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Model;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.data.templates.ModuleReleaseInfo;
import org.jahia.data.templates.ModuleState;
import org.jahia.exceptions.JahiaRuntimeException;
import org.jahia.osgi.BundleUtils;
import org.jahia.osgi.FrameworkService;
import org.jahia.security.license.LicenseCheckException;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.notification.ToolbarWarningsService;
import org.jahia.services.templates.ModuleVersion;
import org.jahia.services.templates.SourceControlHelper;
import org.jahia.services.templates.TemplatePackageRegistry;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.PomUtils;
import org.jahia.utils.ProcessHelper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class ModuleBuildHelper
implements InitializingBean {
    private static Logger logger = LoggerFactory.getLogger(ModuleBuildHelper.class);
    private String mavenExecutable;
    private String ignoreSnapshots;
    private boolean ignoreSnapshotsFlag;
    private String mavenArchetypeCatalog;
    private String mavenMinRequiredVersion;
    private String mavenReleasePlugin;
    private SourceControlHelper scmHelper;
    private SettingsBean settingsBean;
    private TemplatePackageRegistry templatePackageRegistry;
    private ToolbarWarningsService toolbarWarningsService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JahiaTemplatesPackage compileAndDeploy(String moduleId, File sources, JCRSessionWrapper session) throws RepositoryException, IOException, BundleException {
        CompiledModuleInfo moduleInfo = this.compileModule(sources);
        Bundle bundle = BundleUtils.getBundle(moduleId, moduleInfo.getVersion());
        if (bundle != null) {
            FileInputStream is = new FileInputStream(moduleInfo.getFile());
            try {
                bundle.update((InputStream)is);
                bundle.start();
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
            if (BundleUtils.getContextStartException(bundle.getSymbolicName()) != null && BundleUtils.getContextStartException(bundle.getSymbolicName()) instanceof LicenseCheckException) {
                throw new IOException(BundleUtils.getContextStartException(bundle.getSymbolicName()).getLocalizedMessage());
            }
            return this.templatePackageRegistry.lookupByIdAndVersion(moduleInfo.getModuleName(), new ModuleVersion(moduleInfo.getVersion()));
        }
        FileInputStream is = new FileInputStream(moduleInfo.getFile());
        try {
            bundle = FrameworkService.getBundleContext().installBundle(moduleInfo.getFile().toURI().toString(), (InputStream)is);
            ((BundleStartLevel)bundle.adapt(BundleStartLevel.class)).setStartLevel(2);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        JahiaTemplatesPackage pkg = BundleUtils.getModule(bundle);
        if (pkg == null) {
            throw new IOException("Cannot deploy module");
        }
        if (pkg.getState().getState() == ModuleState.State.WAITING_TO_BE_PARSED) {
            throw new IOException("Missing dependency : " + pkg.getState().getDetails().toString());
        }
        bundle.start();
        if (BundleUtils.getContextStartException(bundle.getSymbolicName()) != null && BundleUtils.getContextStartException(bundle.getSymbolicName()) instanceof LicenseCheckException) {
            throw new IOException(BundleUtils.getContextStartException(bundle.getSymbolicName()).getLocalizedMessage());
        }
        return this.templatePackageRegistry.lookupByIdAndVersion(moduleInfo.getModuleName(), new ModuleVersion(moduleInfo.getVersion()));
    }

    public CompiledModuleInfo compileModule(File sources) throws IOException {
        File pom = new File(sources, "pom.xml");
        try {
            Model model = PomUtils.read(pom);
            String artifactId = model.getArtifactId();
            String version = PomUtils.getVersion(model);
            if (StringUtils.isEmpty((String)version)) {
                throw new IOException("No version found in pom.xml file " + pom);
            }
            StringBuilder out = new StringBuilder();
            int r = 0;
            try {
                r = ProcessHelper.execute(this.mavenExecutable, new String[]{"clean", "install"}, null, sources, out, null);
            }
            catch (JahiaRuntimeException e) {
                logger.error(e.getCause().getMessage(), e.getCause());
                throw e;
            }
            if (r > 0) {
                logger.error("Compilation error, returned status " + r);
                logger.error("Maven out : " + out);
                throw new IOException(out.toString());
            }
            File file = new File(sources.getPath() + "/target/" + artifactId + "-" + version + ".war");
            if (!file.exists()) {
                file = new File(sources.getPath() + "/target/" + artifactId + "-" + version + ".jar");
            }
            if (file.exists()) {
                return new CompiledModuleInfo(file, artifactId, version);
            }
            throw new IOException("Cannot find a module archive to deploy in folder " + file.getParentFile().getAbsolutePath());
        }
        catch (XmlPullParserException e) {
            logger.error("Error parsing pom.xml file at " + pom, (Throwable)e);
            throw new IOException("Cannot parse pom.xml file " + pom, e);
        }
    }

    public JCRNodeWrapper createModule(String moduleName, String artifactId, String groupId, String moduleType, File moduleSources, JCRSessionWrapper session) throws IOException, RepositoryException, BundleException {
        if (StringUtils.isBlank((String)moduleName)) {
            throw new RepositoryException("Cannot create module because no module name has been specified");
        }
        if (StringUtils.isBlank((String)artifactId)) {
            artifactId = JCRContentUtils.generateNodeName(moduleName);
        }
        if (this.templatePackageRegistry.containsId(artifactId)) {
            throw new RepositoryException("Cannot create module " + artifactId + " because another module with the same artifactId exists");
        }
        File sources = moduleSources;
        if (sources == null && !(sources = new File(SettingsBean.getInstance().getModulesSourcesDiskPath())).exists() && !sources.mkdirs()) {
            throw new IOException("Unable to create path for: " + sources);
        }
        String finalFolderName = null;
        if (!sources.exists()) {
            finalFolderName = sources.getName();
            if ((sources = sources.getParentFile()) == null) {
                sources = new File(SettingsBean.getInstance().getModulesSourcesDiskPath());
            }
            if (!sources.exists() && !sources.mkdirs()) {
                throw new IOException("Unable to create path for: " + sources);
            }
        }
        ArrayList<String> archetypeParams = new ArrayList<String>();
        archetypeParams.add("archetype:generate");
        archetypeParams.add("-DarchetypeCatalog=" + this.mavenArchetypeCatalog + ",local");
        archetypeParams.add("-DarchetypeGroupId=org.jahia.archetypes");
        archetypeParams.add("-DarchetypeArtifactId=jahia-" + (moduleType.equals("jahiapp") ? "app" : moduleType) + "-archetype");
        archetypeParams.add("-Dversion=1.0-SNAPSHOT");
        archetypeParams.add("\"-DmoduleName=" + moduleName + "\"");
        archetypeParams.add("-DartifactId=" + artifactId);
        if (StringUtils.isNotBlank((String)groupId)) {
            archetypeParams.add("-DgroupId=" + groupId);
        }
        archetypeParams.add("-DdigitalFactoryVersion=7.0.0.3");
        archetypeParams.add("-DinteractiveMode=false");
        StringBuilder out = new StringBuilder();
        int ret = ProcessHelper.execute(this.mavenExecutable, archetypeParams.toArray(new String[archetypeParams.size()]), null, sources, out, out);
        if (ret > 0) {
            logger.error("Maven archetype call returned " + ret);
            logger.error("Maven out : " + out);
            return null;
        }
        File path = new File(sources, artifactId);
        if (finalFolderName != null && !path.getName().equals(finalFolderName)) {
            try {
                File newPath = new File(sources, finalFolderName);
                FileUtils.moveDirectory((File)path, (File)newPath);
                path = newPath;
            }
            catch (IOException e) {
                logger.error("Cannot rename folder", (Throwable)e);
            }
        }
        JahiaTemplatesPackage pack = this.compileAndDeploy(artifactId, path, session);
        JCRNodeWrapper node = session.getNode("/modules/" + pack.getIdWithVersion());
        this.scmHelper.setSourcesFolderInPackageAndNode(pack, path, node);
        session.save();
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deployToMaven(String groupId, String artifactId, ModuleReleaseInfo releaseInfo, File generatedJar) throws IOException {
        File settings = null;
        File pomFile = null;
        try {
            Model pom;
            if (!StringUtils.isEmpty((String)releaseInfo.getUsername()) && !StringUtils.isEmpty((String)releaseInfo.getPassword())) {
                settings = File.createTempFile("settings", ".xml");
                BufferedWriter w = new BufferedWriter(new FileWriter(settings));
                w.write("<settings><servers><server><id>" + releaseInfo.getRepositoryId() + "</id><username>");
                w.write(releaseInfo.getUsername());
                w.write("</username><password>");
                w.write(releaseInfo.getPassword());
                w.write("</password></server></servers></settings>");
                w.close();
            }
            JarFile jar = new JarFile(generatedJar);
            pomFile = PomUtils.extractPomFromJar(jar, groupId, artifactId);
            jar.close();
            try {
                pom = PomUtils.read(pomFile);
            }
            catch (XmlPullParserException e) {
                throw new IOException(e);
            }
            String version = pom.getVersion();
            if (version == null) {
                version = pom.getParent().getVersion();
            }
            if (version == null) {
                throw new IOException("unable to read project version");
            }
            Object[] deployParams = new String[]{"deploy:deploy-file", "-Dfile=" + generatedJar, "-DrepositoryId=" + releaseInfo.getRepositoryId(), "-Durl=" + releaseInfo.getRepositoryUrl(), "-DpomFile=" + pomFile.getPath(), "-Dpackaging=" + StringUtils.substringAfterLast((String)generatedJar.getName(), (String)"."), "-DgroupId=" + PomUtils.getGroupId(pom), "-DartifactId=" + pom.getArtifactId(), "-Dversion=" + version};
            if (settings != null) {
                deployParams = (String[])ArrayUtils.addAll((Object[])deployParams, (Object[])new String[]{"--settings", settings.getPath()});
            }
            StringBuilder out = new StringBuilder();
            int ret = ProcessHelper.execute(this.mavenExecutable, (String[])deployParams, null, generatedJar.getParentFile(), out, out);
            if (ret > 0) {
                String s = this.getMavenError(out.toString());
                logger.error("Maven archetype call returned " + ret);
                logger.error("Maven out : " + out);
                throw new IOException("Maven invocation failed\n" + s);
            }
        }
        catch (Throwable throwable) {
            FileUtils.deleteQuietly(settings);
            FileUtils.deleteQuietly(pomFile);
            throw throwable;
        }
        FileUtils.deleteQuietly((File)settings);
        FileUtils.deleteQuietly((File)pomFile);
    }

    private String getMavenError(String out) {
        Matcher m = Pattern.compile("^\\[ERROR\\](.*)$", 8).matcher(out);
        StringBuilder s = new StringBuilder();
        while (m.find()) {
            s.append(m.group(1)).append("\n");
        }
        return s.toString();
    }

    private String getMavenHome() throws IOException {
        String home;
        String string = home = System.getenv().get("M2_HOME") != null ? System.getenv().get("M2_HOME") : "/usr/share/maven";
        if (!new File(home).exists()) {
            throw new IOException("Maven home not found, please set your M2_HOME environment variable");
        }
        return home;
    }

    protected File releaseModuleInternal(Model model, String lastVersion, String releaseVersion, ModuleReleaseInfo releaseInfo, File sources, String scmUrl) throws IOException, XmlPullParserException {
        File generatedWar;
        String nextVersion = releaseInfo.getNextVersion();
        String artifactId = model.getArtifactId();
        File pom = new File(sources, "pom.xml");
        if (scmUrl != null) {
            String tag = StringUtils.replace((String)releaseVersion, (String)".", (String)"_");
            File tmpRepo = new File(System.getProperty("java.io.tmpdir"), "repo");
            tmpRepo.mkdir();
            String[] installParams = new String[]{this.mavenReleasePlugin + ":prepare", this.mavenReleasePlugin + ":stage", this.mavenReleasePlugin + ":clean", "-Dmaven.home=" + this.getMavenHome(), "-Dtag=" + tag, "-DreleaseVersion=" + releaseVersion, "-DdevelopmentVersion=" + nextVersion, "-DignoreSnapshots=" + this.ignoreSnapshotsFlag, "-DstagingRepository=tmp::default::" + tmpRepo.toURI().toString(), "--batch-mode"};
            StringBuilder out = new StringBuilder();
            int ret = ProcessHelper.execute(this.mavenExecutable, installParams, null, sources, out, out);
            FileUtils.deleteDirectory((File)tmpRepo);
            if (ret > 0) {
                String s = this.getMavenError(out.toString());
                logger.error("Maven release call returnedError release, maven out : " + out);
                logger.error("Error when releasing, maven out : " + out);
                ProcessHelper.execute(this.mavenExecutable, new String[]{this.mavenReleasePlugin + ":rollback"}, null, sources, out, out);
                logger.error("Rollback release : " + out);
                throw new IOException("Maven invocation failed\n" + s);
            }
            File oldWar = new File(this.settingsBean.getJahiaModulesDiskPath(), artifactId + "-" + lastVersion + ".war");
            if (oldWar.exists()) {
                oldWar.delete();
            }
            if ((oldWar = new File(this.settingsBean.getJahiaModulesDiskPath(), artifactId + "-" + lastVersion + ".jar")).exists()) {
                oldWar.delete();
            }
            if (!(generatedWar = new File(sources.getPath() + "/target/checkout/target/" + artifactId + "-" + releaseVersion + ".war")).exists()) {
                generatedWar = new File(sources.getPath() + "/target/checkout/target/" + artifactId + "-" + releaseVersion + ".jar");
            }
        } else {
            PomUtils.updateVersion(pom, releaseVersion);
            generatedWar = this.compileModule(sources).getFile();
            PomUtils.updateVersion(pom, nextVersion);
        }
        return generatedWar;
    }

    public void setIgnoreSnapshots(String ignoreSnapshots) {
        this.ignoreSnapshots = ignoreSnapshots;
    }

    public void setMavenArchetypeCatalog(String mavenArchetypeCatalog) {
        this.mavenArchetypeCatalog = mavenArchetypeCatalog;
    }

    public void setSettingsBean(SettingsBean settingsBean) {
        this.settingsBean = settingsBean;
    }

    public void setSourceControlHelper(SourceControlHelper scmHelper) {
        this.scmHelper = scmHelper;
    }

    public void setTemplatePackageRegistry(TemplatePackageRegistry registry) {
        this.templatePackageRegistry = registry;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.mavenArchetypeCatalog == null || this.mavenArchetypeCatalog.length() == 0) {
            this.mavenArchetypeCatalog = "7.0.0.3".contains("-SNAPSHOT") ? "https://devtools.jahia.com/nexus/content/repositories/jahia-snapshots/archetype-catalog.xml" : "https://devtools.jahia.com/nexus/content/repositories/jahia-releases/archetype-catalog.xml";
        }
        this.ignoreSnapshotsFlag = this.ignoreSnapshots == null || this.ignoreSnapshots.length() == 0 ? "7.0.0.3".contains("-SNAPSHOT") : Boolean.valueOf(this.ignoreSnapshots.trim()).booleanValue();
        if (this.mavenReleasePlugin == null || this.mavenReleasePlugin.length() == 0) {
            this.mavenReleasePlugin = "release";
        }
    }

    public void setMavenReleasePlugin(String mavenReleasePlugin) {
        this.mavenReleasePlugin = mavenReleasePlugin;
    }

    public void setMavenMinRequiredVersion(String mavenRequiredVersion) {
        this.mavenMinRequiredVersion = mavenRequiredVersion;
    }

    public void setMavenExecutable(String mavenExecutable) {
        if (System.getProperty("os.name").toLowerCase().startsWith("windows") && !mavenExecutable.endsWith(".bat")) {
            mavenExecutable = mavenExecutable + ".bat";
        }
        if (this.settingsBean.isDevelopmentMode()) {
            StringBuilder resultOut = new StringBuilder();
            try {
                int res = ProcessHelper.execute(mavenExecutable, new String[]{"-version"}, null, null, resultOut, null);
                if (res > 0) {
                    this.toolbarWarningsService.addMessage("warning.maven.missing");
                    logger.error("Cannot set maven executable to " + mavenExecutable + ", please check your configuration");
                    return;
                }
                Object[] mvnVersion = StringUtils.split((String)StringUtils.substringBetween((String)resultOut.toString(), (String)"Apache Maven ", (String)"\n"), (String)".");
                String[] requiredVersion = StringUtils.split((String)this.mavenMinRequiredVersion, (String)".");
                boolean isValid = true;
                for (int i = 0; i < mvnVersion.length; ++i) {
                    boolean bl = isValid = Integer.parseInt(mvnVersion[i]) >= Integer.parseInt(requiredVersion[i]);
                    if (!isValid || i == requiredVersion.length - 1) break;
                }
                if (isValid) {
                    this.mavenExecutable = mavenExecutable;
                    this.settingsBean.setMavenExecutableSet(true);
                } else {
                    this.toolbarWarningsService.addMessage("warning.maven.wrong.version");
                    logger.error("Detected Maven Version: " + StringUtils.join((Object[])mvnVersion, (String)".") + " do not match the minimum required version " + this.mavenMinRequiredVersion);
                }
            }
            catch (Exception e) {
                this.toolbarWarningsService.addMessage("warning.maven.missing");
                logger.error("Cannot set maven executable to " + mavenExecutable + ", please check your configuration", (Throwable)e);
            }
            if (StringUtils.isEmpty((String)this.mavenExecutable)) {
                logger.error("Until maven executable is correctly set, the studio will not be available");
                this.settingsBean.setMavenExecutableSet(false);
            }
        }
    }

    public void setToolbarWarningsService(ToolbarWarningsService toolbarWarningsService) {
        this.toolbarWarningsService = toolbarWarningsService;
    }

    static class CompiledModuleInfo {
        private final File file;
        private final String moduleName;
        private final String version;

        public CompiledModuleInfo(File file, String moduleName, String version) {
            this.file = file;
            this.moduleName = moduleName;
            this.version = version;
        }

        public File getFile() {
            return this.file;
        }

        public String getModuleName() {
            return this.moduleName;
        }

        public String getVersion() {
            return this.version;
        }
    }
}

