/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.templates;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.PumpStreamHandler;
import org.jahia.services.templates.GitSourceControlManagement;
import org.jahia.services.templates.SourceControlManagement;
import org.jahia.services.templates.SvnSourceControlManagement;
import org.jahia.utils.StringOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceControlFactory {
    private static final Logger logger = LoggerFactory.getLogger(SourceControlFactory.class);
    private Map<String, String> sourceControlExecutables;

    public SourceControlManagement checkoutRepository(File workingDir, String scmURI, String branchOrTag, boolean initRepository) throws IOException {
        SourceControlManagement scm = null;
        if (scmURI.startsWith("scm:")) {
            String scmProvider = scmURI.substring(4, scmURI.indexOf(":", 4));
            String scmUrl = scmURI.substring(scmURI.indexOf(":", 4) + 1);
            if (scmProvider.equals("git") && this.sourceControlExecutables.containsKey("git")) {
                scm = new GitSourceControlManagement(this.sourceControlExecutables.get("git"));
            } else if (scmProvider.equals("svn") && this.sourceControlExecutables.containsKey("svn")) {
                scm = new SvnSourceControlManagement(this.sourceControlExecutables.get("svn"));
            } else {
                throw new IOException("Unknown repository type");
            }
            if (initRepository) {
                ((SourceControlManagement)scm).sendToSCM(workingDir, scmUrl);
            } else {
                ((SourceControlManagement)scm).getFromSCM(workingDir, scmUrl, branchOrTag);
            }
        }
        return scm;
    }

    public Map<String, String> getSourceControlExecutables() {
        return this.sourceControlExecutables;
    }

    public SourceControlManagement getSourceControlManagement(File workingDir) throws IOException {
        SourceControlManagement scm = null;
        File dir = workingDir;
        do {
            if (new File(dir, ".git").exists()) {
                if (!this.sourceControlExecutables.containsKey("git")) break;
                scm = new GitSourceControlManagement(this.sourceControlExecutables.get("git"));
                continue;
            }
            if (new File(dir, ".svn").exists()) {
                if (!this.sourceControlExecutables.containsKey("svn")) break;
                scm = new SvnSourceControlManagement(this.sourceControlExecutables.get("svn"));
                continue;
            }
            dir = dir.getParentFile();
        } while (scm == null && dir != null);
        if (scm != null) {
            scm.initWithWorkingDirectory(workingDir);
        }
        return scm;
    }

    public Set<String> getSupportedSourceControls() {
        return this.sourceControlExecutables.keySet();
    }

    public void setSourceControlExecutables(Map<String, String> sourceControlExecutables) {
        this.sourceControlExecutables = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : sourceControlExecutables.entrySet()) {
            try {
                DefaultExecutor executor = new DefaultExecutor();
                executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)new StringOutputStream(), (OutputStream)new StringOutputStream()));
                executor.execute(new CommandLine(entry.getValue()), System.getenv());
            }
            catch (ExecuteException e) {
            }
            catch (IOException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Unable to execute the " + entry.getKey() + " SCM executable: " + entry.getValue() + ". The SCM provider will be disabled. Cause: " + e.getMessage(), (Throwable)e);
                    continue;
                }
                logger.info("Cannot find a valid " + entry.getKey() + " SCM executable at: " + entry.getValue() + ". The SCM provider will be skipped.");
                continue;
            }
            this.sourceControlExecutables.put(entry.getKey(), entry.getValue());
        }
    }
}

