/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.uicomponents.bean.editmode;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jahia.ajax.gwt.client.widget.contentengine.EditEngineTabItem;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.uicomponents.bean.Visibility;
import org.jahia.services.uicomponents.bean.contentmanager.ManagerConfiguration;
import org.jahia.services.uicomponents.bean.editmode.EditConfiguration;
import org.jahia.services.uicomponents.bean.editmode.Engine;
import org.springframework.beans.factory.InitializingBean;

public class EngineTab
implements Serializable,
Comparable<EngineTab>,
InitializingBean {
    private static final long serialVersionUID = -5995531303789738603L;
    private String id;
    private String title;
    private String titleKey;
    private Visibility visibility;
    private EditEngineTabItem tabItem;
    private int order;
    private String requiredPermission;
    private Object parent;
    private int position = -1;
    private String positionAfter;
    private String positionBefore;

    protected static void removeTab(List<EngineTab> tabs, String tabId) {
        if (tabId != null && tabId.length() > 0) {
            Iterator<EngineTab> iterator = tabs.iterator();
            while (iterator.hasNext()) {
                EngineTab tab = iterator.next();
                if (tab.getId() == null || !tab.getId().equals(tabId)) continue;
                iterator.remove();
            }
        }
    }

    public EngineTab() {
    }

    public EngineTab(String id) {
        this();
        this.setId(id);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitleKey() {
        return this.titleKey;
    }

    public void setTitleKey(String titleKey) {
        this.titleKey = titleKey;
    }

    public EditEngineTabItem getTabItem() {
        return this.tabItem;
    }

    public void setTabItem(EditEngineTabItem item) {
        this.tabItem = item;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public void setParentEditConfiguration(EditConfiguration config) {
        List<EngineTab> engineTabs = config.getDefaultEditConfiguration().getEngineTabs();
        EngineTab oldTab = null;
        for (EngineTab tab : engineTabs) {
            if (!this.getId().equals(tab.getId())) continue;
            oldTab = tab;
            break;
        }
        if (oldTab != null) {
            engineTabs.remove(oldTab);
        }
        engineTabs.add(this);
    }

    public void setParentManagerConfiguration(ManagerConfiguration config) {
        List<EngineTab> engineTabs = config.getEngineTabs();
        EngineTab oldTab = null;
        for (EngineTab tab : engineTabs) {
            if (!this.getId().equals(tab.getId())) continue;
            oldTab = tab;
            break;
        }
        if (oldTab != null) {
            engineTabs.remove(oldTab);
        }
        engineTabs.add(this);
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public String getRequiredPermission() {
        return this.requiredPermission;
    }

    public void setRequiredPermission(String requiredPermission) {
        this.requiredPermission = requiredPermission;
    }

    @Override
    public int compareTo(EngineTab o) {
        return this.getOrder() - o.getOrder();
    }

    public void afterPropertiesSet() throws Exception {
        if (this.parent == null) {
            return;
        }
        if (this.parent instanceof String) {
            this.parent = SpringContextSingleton.getBean((String)this.parent);
        }
        List<EngineTab> tabs = null;
        if (this.parent instanceof EditConfiguration) {
            tabs = ((EditConfiguration)this.parent).getDefaultEditConfiguration().getEngineTabs();
            if (tabs == null) {
                tabs = new LinkedList<EngineTab>();
                ((EditConfiguration)this.parent).getDefaultEditConfiguration().setEngineTabs(tabs);
            }
        } else if (this.parent instanceof ManagerConfiguration) {
            tabs = ((ManagerConfiguration)this.parent).getEngineTabs();
            if (tabs == null) {
                tabs = new LinkedList<EngineTab>();
                ((ManagerConfiguration)this.parent).setEngineTabs(tabs);
            }
        } else if (this.parent instanceof Engine && (tabs = ((Engine)this.parent).getTabs()) == null) {
            tabs = new LinkedList<EngineTab>();
            ((Engine)this.parent).setTabs(tabs);
        }
        if (tabs != null) {
            EngineTab.removeTab(tabs, this.getId());
            int index = -1;
            if (this.position >= 0) {
                index = this.position;
            } else if (this.positionBefore != null) {
                index = tabs.indexOf(new EngineTab(this.positionBefore));
            } else if (this.positionAfter != null) {
                index = tabs.indexOf(new EngineTab(this.positionAfter));
                if (index != -1) {
                    ++index;
                }
                if (index >= tabs.size()) {
                    index = -1;
                }
            }
            if (index != -1) {
                tabs.add(index, this);
            } else {
                tabs.add(this);
            }
        } else {
            throw new IllegalArgumentException("Unknown parent type '" + this.parent.getClass().getName() + "'. Can accept EditConfiguration, ManagerConfiguration, Engine or" + " a String value with a beanId of the those beans");
        }
        this.parent = null;
    }

    public void setParent(Object parent) {
        this.parent = parent;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public void setPositionAfter(String positionAfter) {
        this.positionAfter = positionAfter;
    }

    public void setPositionBefore(String positionBefore) {
        this.positionBefore = positionBefore;
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (obj instanceof EngineTab) {
            EngineTab other = (EngineTab)obj;
            return this.getId() != null ? other.getId() != null && this.getId().equals(other.getId()) : other.getId() == null;
        }
        return false;
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }
}

