/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.uicomponents.bean.toolbar;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.jahia.ajax.gwt.client.widget.toolbar.action.ActionItem;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.uicomponents.bean.Visibility;
import org.jahia.services.uicomponents.bean.toolbar.Menu;
import org.jahia.services.uicomponents.bean.toolbar.Property;
import org.jahia.services.uicomponents.bean.toolbar.Selected;
import org.jahia.services.uicomponents.bean.toolbar.Toolbar;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;

public class Item
implements Serializable,
BeanNameAware,
InitializingBean {
    private static final long serialVersionUID = -5120594370234680709L;
    private String id;
    private String icon;
    private String title;
    private String titleKey;
    private boolean displayTitle = true;
    private String descriptionKey;
    private Visibility visibility;
    private Selected selected;
    private String layout;
    private String requiredPermission;
    private boolean hideWhenDisabled;
    private List<Property> properties = new ArrayList<Property>();
    private ActionItem actionItem;
    private Object parent;
    private int position = -1;
    private String positionAfter;
    private String positionBefore;

    public Item() {
    }

    private Item(String id) {
        this();
        this.setId(id);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitleKey() {
        return this.titleKey;
    }

    public void setTitleKey(String titleKey) {
        this.titleKey = titleKey;
    }

    public boolean isDisplayTitle() {
        return this.displayTitle;
    }

    public void setDisplayTitle(boolean displayTitle) {
        this.displayTitle = displayTitle;
    }

    public String getDescriptionKey() {
        return this.descriptionKey;
    }

    public void setDescriptionKey(String descriptionKey) {
        this.descriptionKey = descriptionKey;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public Selected getSelected() {
        return this.selected;
    }

    public void setSelected(Selected selected) {
        this.selected = selected;
    }

    public void setProperties(List<Property> properties) {
        this.properties = properties;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public void addProperty(Property property) {
        this.properties.add(property);
    }

    public void setBeanName(String name) {
        this.id = name;
    }

    public ActionItem getActionItem() {
        return this.actionItem;
    }

    public void setActionItem(ActionItem actionItem) {
        this.actionItem = actionItem;
    }

    public String getLayout() {
        return this.layout;
    }

    public void setLayout(String layout) {
        this.layout = layout;
    }

    public String getRequiredPermission() {
        return this.requiredPermission;
    }

    public void setRequiredPermission(String requiredPermission) {
        this.requiredPermission = requiredPermission;
    }

    public boolean isHideWhenDisabled() {
        return this.hideWhenDisabled;
    }

    public void setHideWhenDisabled(boolean hideWhenDisabled) {
        this.hideWhenDisabled = hideWhenDisabled;
    }

    public void setParent(Object parent) {
        this.parent = parent;
    }

    public void setParentMenu(Menu menu) {
        this.setParent(menu);
    }

    public void setParentToolbar(Toolbar toolbar) {
        this.setParent(toolbar);
    }

    public void afterPropertiesSet() throws Exception {
        if (this.parent != null) {
            if (this.parent instanceof String) {
                String parentPath = (String)this.parent;
                String beanId = StringUtils.substringBefore((String)parentPath, (String)".");
                Object bean = SpringContextSingleton.getBean(beanId);
                String propertyPath = StringUtils.substringAfter((String)parentPath, (String)".");
                if (propertyPath.length() > 0) {
                    bean = PropertyUtils.getNestedProperty((Object)bean, (String)propertyPath);
                }
                if (bean == null) {
                    throw new IllegalArgumentException("Unable to find target for parent path: " + parentPath);
                }
                if (!(bean instanceof Menu) && !(bean instanceof Toolbar)) {
                    throw new IllegalArgumentException("Target bean for path '" + parentPath + "' is not of type Menu or Toolbar. Unable to handle beans of type '" + bean.getClass().getName() + "'");
                }
                this.parent = bean;
            }
            if (this.parent instanceof Menu) {
                Menu parentMenu = (Menu)this.parent;
                parentMenu.removeItem(this.getId());
                int index = -1;
                if (this.position >= 0) {
                    index = this.position;
                } else if (this.positionBefore != null) {
                    index = parentMenu.getItems().indexOf(new Item(this.positionBefore));
                } else if (this.positionAfter != null) {
                    index = parentMenu.getItems().indexOf(new Item(this.positionAfter));
                    if (index != -1) {
                        ++index;
                    }
                    if (index >= parentMenu.getItems().size()) {
                        index = -1;
                    }
                }
                if (index != -1) {
                    parentMenu.addItem(index, this);
                } else {
                    parentMenu.addItem(this);
                }
            } else if (this.parent instanceof Toolbar) {
                Toolbar parentToolbar = (Toolbar)this.parent;
                parentToolbar.removeItem(this.getId());
                int index = -1;
                if (this.position >= 0) {
                    index = this.position;
                } else if (this.positionBefore != null) {
                    index = parentToolbar.getItems().indexOf(new Item(this.positionBefore));
                } else if (this.positionAfter != null) {
                    index = parentToolbar.getItems().indexOf(new Item(this.positionAfter));
                    if (index != -1) {
                        ++index;
                    }
                    if (index >= parentToolbar.getItems().size()) {
                        index = -1;
                    }
                }
                if (index != -1) {
                    parentToolbar.addItem(index, this);
                } else {
                    parentToolbar.addItem(this);
                }
            } else {
                throw new IllegalArgumentException("Unknown parent type '" + this.parent.getClass().getName() + "'. Can accept Menu, Toolbar or" + " a String value with a bean-compliant path to the corresponding menu/toobar bean");
            }
            this.parent = null;
        }
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (obj instanceof Item && obj != null) {
            Item other = (Item)obj;
            return this.getId() != null ? other.getId() != null && this.getId().equals(other.getId()) : other.getId() == null;
        }
        return false;
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public void setPositionAfter(String positionAfter) {
        this.positionAfter = positionAfter;
    }

    public void setPositionBefore(String positionBefore) {
        this.positionBefore = positionBefore;
    }
}

