/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.usermanager;

import java.util.Properties;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.content.JCRStoreService;
import org.jahia.services.usermanager.JahiaExternalUser;
import org.jahia.services.usermanager.JahiaGroup;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.services.usermanager.JahiaUserManagerProvider;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.services.usermanager.UserProperties;
import org.jahia.services.usermanager.UserProperty;
import org.jahia.services.usermanager.UserPropertyReadOnlyException;
import org.jahia.services.usermanager.jcr.JCRUser;
import org.jahia.services.usermanager.jcr.JCRUserManagerProvider;

public abstract class BaseJahiaExternalUser
implements JahiaExternalUser {
    private static final long serialVersionUID = 1431128187514460913L;
    protected UserProperties externalProperties = new UserProperties();
    protected String password;
    protected String path;
    protected UserProperties properties;
    protected String providerKey;
    protected String userKey;
    protected String username;

    public BaseJahiaExternalUser(String providerKey, String username, String userKey) {
        this.providerKey = providerKey;
        this.username = username;
        this.userKey = userKey;
    }

    public BaseJahiaExternalUser(String providerKey, String username, String userKey, UserProperties externalProperties) {
        this(providerKey, username, userKey);
        if (externalProperties != null) {
            this.externalProperties = externalProperties;
        }
    }

    @Override
    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        if (another != null && this.getClass() == another.getClass()) {
            return this.getUserKey().equals(((JahiaUser)another).getUserKey());
        }
        return false;
    }

    @Override
    public UserProperties getExternalProperties() {
        return this.externalProperties;
    }

    @Override
    public String getLocalPath() {
        if (this.path == null) {
            this.path = ServicesRegistry.getInstance().getJahiaUserManagerService().getUserSplittingRule().getPathForUsername(this.getUsername());
        }
        return this.path;
    }

    @Override
    public String getName() {
        return this.username;
    }

    @Override
    public Properties getProperties() {
        return this.getUserProperties().getProperties();
    }

    @Override
    public String getProperty(String key) {
        if (null == key) {
            return null;
        }
        return this.externalProperties.hasProperty(key) ? this.externalProperties.getProperty(key) : this.getUserProperties().getProperty(key);
    }

    protected JahiaUserManagerProvider getProvider() {
        return ServicesRegistry.getInstance().getJahiaUserManagerService().getProvider(this.providerKey);
    }

    @Override
    public String getProviderName() {
        return this.providerKey;
    }

    @Override
    public String getUserKey() {
        return this.userKey;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public UserProperties getUserProperties() {
        if (this.properties == null) {
            UserProperties props = this.initializeMergedProperties();
            this.properties = props != null ? props : new UserProperties(this.externalProperties);
        }
        return this.properties;
    }

    @Override
    public UserProperty getUserProperty(String key) {
        if (null == key) {
            return null;
        }
        return this.externalProperties.hasProperty(key) ? this.externalProperties.getUserProperty(key) : this.getUserProperties().getUserProperty(key);
    }

    @Override
    public int hashCode() {
        return this.getUserKey().hashCode();
    }

    protected UserProperties initializeMergedProperties() {
        JCRUser jcrUser = this.lookupExternalUser();
        return jcrUser != null ? jcrUser.getUserProperties() : null;
    }

    @Override
    public boolean isAdminMember(int siteID) {
        return this.isMemberOfGroup(siteID, "administrators");
    }

    @Override
    public boolean isMemberOfGroup(int siteID, String name) {
        JahiaGroup group;
        ServicesRegistry servicesRegistry = ServicesRegistry.getInstance();
        if (servicesRegistry != null && (group = servicesRegistry.getJahiaGroupManagerService().lookupGroup(siteID, name)) != null) {
            return group.isMember(this);
        }
        return false;
    }

    @Override
    public final boolean isRoot() {
        return false;
    }

    protected JCRUser lookupExternalUser() {
        return ((JCRUserManagerProvider)SpringContextSingleton.getBean("JCRUserManagerProvider")).lookupExternalUser(this);
    }

    @Override
    public boolean removeProperty(String key) {
        if (null == key) {
            return false;
        }
        boolean success = false;
        UserProperty external = this.externalProperties.getUserProperty(key);
        if (external != null) {
            if (!external.isReadOnly() && (success = this.removePropertyExternal(key))) {
                this.externalProperties.removeUserProperty(key);
                this.properties.removeUserProperty(key);
            }
        } else {
            success = this.removePropertyInternal(key);
        }
        return success;
    }

    protected abstract boolean removePropertyExternal(String var1);

    protected boolean removePropertyInternal(String key) {
        JCRUser jcrUser = this.lookupExternalUser();
        return jcrUser != null && jcrUser.removeProperty(key);
    }

    @Override
    public boolean setProperty(String key, String value) {
        if (null == key) {
            return false;
        }
        boolean success = false;
        UserProperty external = this.externalProperties.getUserProperty(key);
        if (external != null) {
            if (!external.isReadOnly() && (success = this.setPropertyExternal(key, value))) {
                try {
                    this.externalProperties.setProperty(key, value);
                    this.properties.setProperty(key, value);
                }
                catch (UserPropertyReadOnlyException e) {
                    JahiaUserManagerService.LOGGER.warn("Cannot set read-only property {} for user {}", (Object)key, (Object)this.userKey);
                }
            }
        } else {
            success = this.setPropertyInternal(key, value);
            try {
                this.properties.setProperty(key, value);
            }
            catch (UserPropertyReadOnlyException e) {
                JahiaUserManagerService.LOGGER.warn("Cannot set read-only property {} for user {}", (Object)key, (Object)this.userKey);
            }
        }
        return success;
    }

    protected abstract boolean setPropertyExternal(String var1, String var2);

    protected boolean setPropertyInternal(String key, String value) {
        JCRUser jcrUser = this.lookupExternalUser();
        if (jcrUser == null) {
            try {
                long timer = System.currentTimeMillis();
                JCRStoreService.getInstance().deployExternalUser(this);
                JahiaUserManagerService.LOGGER.info("Created internal user node for user {} in {} ms", (Object)this.userKey, (Object)(System.currentTimeMillis() - timer));
                jcrUser = this.lookupExternalUser();
            }
            catch (RepositoryException e) {
                JahiaUserManagerService.LOGGER.error("Error deploying external user '" + this.getName() + "' for provider '" + this.getProviderName() + "' into JCR repository. Cause: " + e.getMessage(), (Throwable)e);
            }
        }
        return jcrUser != null && jcrUser.setProperty(key, value);
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).append("username", (Object)this.username).append("userKey", (Object)this.userKey).append("provider", (Object)this.providerKey).append("localPath", (Object)this.getLocalPath()).append("externalProperties", (Object)this.externalProperties).toString();
    }

    @Override
    public boolean verifyPassword(String passwordToVerify) {
        if (passwordToVerify == null) {
            return false;
        }
        String encrypted = JahiaUserManagerService.encryptPassword(passwordToVerify);
        if (StringUtils.isNotEmpty((String)this.password) && this.password.equals(encrypted)) {
            return true;
        }
        boolean granted = this.verifyPasswordExternal(passwordToVerify);
        if (granted) {
            this.password = encrypted;
        }
        return granted;
    }

    protected boolean verifyPasswordExternal(String password) {
        return this.getProvider().login(this.getUserKey(), password);
    }

    @Override
    public boolean isAccountLocked() {
        return !this.isRoot() && Boolean.valueOf(this.getProperty("j:accountLocked")) != false;
    }
}

