/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.usermanager;

import java.util.List;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.usermanager.JahiaUserSplittingRule;

public class DefaultJahiaUserSplittingRuleImpl
implements JahiaUserSplittingRule {
    private String usersRootNode;
    private List<String> nonSplittedUsers;

    private static int round(float a) {
        return (int)Math.floor(a + 0.5f);
    }

    public void setUsersRootNode(String usersRootNode) {
        this.usersRootNode = usersRootNode;
    }

    @Override
    public String getPathForUsername(String username) {
        StringBuilder builder = new StringBuilder();
        if (this.nonSplittedUsers.contains(username)) {
            return builder.append(this.usersRootNode).append("/").append(username).toString();
        }
        int userNameHashcode = Math.abs(username.hashCode());
        String firstFolder = this.getFolderName(userNameHashcode).toLowerCase();
        userNameHashcode = DefaultJahiaUserSplittingRuleImpl.round(userNameHashcode / 100);
        String secondFolder = this.getFolderName(userNameHashcode).toLowerCase();
        userNameHashcode = DefaultJahiaUserSplittingRuleImpl.round(userNameHashcode / 100);
        String thirdFolder = this.getFolderName(userNameHashcode).toLowerCase();
        return builder.append(this.usersRootNode).append("/").append(firstFolder).append("/").append(secondFolder).append("/").append(thirdFolder).append("/").append(JCRContentUtils.escapeLocalNodeName(username)).toString();
    }

    private String getFolderName(int userNameHashcode) {
        int i = Math.abs(userNameHashcode % 100);
        return Character.toString((char)(97 + DefaultJahiaUserSplittingRuleImpl.round(i / 10))) + Character.toString((char)(97 + i % 10));
    }

    public void setNonSplittedUsers(List<String> nonSplittedUsers) {
        this.nonSplittedUsers = nonSplittedUsers;
    }
}

