/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.usermanager;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.usermanager.JahiaPrincipal;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.services.usermanager.jcr.JCRUser;

public abstract class JahiaGroup
implements JahiaPrincipal,
Group {
    private static final long serialVersionUID = 3192050315335252786L;
    protected String mGroupname;
    protected String mGroupKey;
    protected boolean hidden = false;
    protected int mSiteID;
    protected boolean preloadedGroups;
    protected Map<String, Boolean> membership = new ConcurrentHashMap<String, Boolean>();
    protected Set<Principal> mMembers;

    public abstract Properties getProperties();

    public abstract String getProperty(String var1);

    public abstract boolean removeProperty(String var1);

    public abstract boolean setProperty(String var1, String var2);

    public abstract boolean addMember(Principal var1);

    public abstract void addMembers(Collection<Principal> var1);

    @Override
    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        if (another != null && this.getClass() == another.getClass()) {
            return this.mGroupKey.equals(((JahiaGroup)another).getGroupKey());
        }
        return false;
    }

    public String getGroupKey() {
        return this.mGroupKey;
    }

    @Override
    public String getName() {
        return this.mGroupname;
    }

    public String getGroupname() {
        return this.mGroupname;
    }

    public int getSiteID() {
        return this.mSiteID;
    }

    @Override
    public abstract int hashCode();

    public boolean isMember(Principal principal) {
        JahiaUser extUser;
        Boolean isMember;
        if (principal == null) {
            return false;
        }
        String principalKey = JahiaUserManagerService.getKey(principal);
        Boolean bl = isMember = !this.membership.isEmpty() ? this.membership.get(principalKey) : null;
        if (isMember != null) {
            return isMember;
        }
        boolean result = false;
        if (this.mMembers != null) {
            boolean principalIsGuest = principalKey.startsWith("guest:");
            for (Principal member : this.mMembers) {
                if (member == null) continue;
                String mname = JahiaUserManagerService.getKey(member);
                if (mname.equals(principalKey) || principalIsGuest && mname.startsWith("guest:")) {
                    result = true;
                } else if (member instanceof Group) {
                    result = ((Group)member).isMember(principal);
                }
                if (!result) continue;
                break;
            }
        }
        if (!result && ("guest".equals(this.mGroupname) || "users".equals(this.mGroupname)) && (extUser = ServicesRegistry.getInstance().getJahiaUserManagerService().lookupUser(principal.getName())) != null && !(extUser instanceof JCRUser)) {
            result = true;
        }
        return result;
    }

    public Enumeration<Principal> members() {
        return new Vector<Principal>(this.getMembersMap()).elements();
    }

    public Collection<Principal> getMembers() {
        return this.getMembersMap();
    }

    protected abstract Set<Principal> getMembersMap();

    public Set<Principal> getRecursiveUserMembers() {
        HashSet<Principal> users = new HashSet<Principal>();
        if ("guest".equals(this.mGroupname) || "users".equals(this.mGroupname)) {
            List<String> userKeyList;
            LinkedList<JahiaUser> userList = new LinkedList<JahiaUser>();
            JahiaUserManagerService jahiaUserManagerService = ServicesRegistry.getInstance().getJahiaUserManagerService();
            List<String> l = jahiaUserManagerService.getUserList();
            for (String s : l) {
                userList.add(jahiaUserManagerService.lookupUserByKey(s));
            }
            if (userList != null) {
                users.addAll(userList);
            }
            if ((userKeyList = ServicesRegistry.getInstance().getJahiaUserManagerService().getUserList()) != null) {
                for (String curUserKey : userKeyList) {
                    JahiaUser curUser = ServicesRegistry.getInstance().getJahiaUserManagerService().lookupUserByKey(curUserKey);
                    if (curUser instanceof JCRUser || users.contains(curUser)) continue;
                    users.add(curUser);
                }
                return users;
            }
        }
        for (Principal curMember : this.getMembersMap()) {
            if (curMember instanceof JahiaGroup) {
                JahiaGroup groupMember = (JahiaGroup)curMember;
                users.addAll(groupMember.getRecursiveUserMembers());
                continue;
            }
            users.add(curMember);
        }
        return users;
    }

    public abstract boolean removeMember(Principal var1);

    public boolean removeMembers() {
        for (Principal aMember : this.getMembersMap()) {
            this.removeMember(aMember);
        }
        return true;
    }

    @Override
    public abstract String toString();

    public abstract String getProviderName();

    public boolean isPreloadedGroups() {
        return this.preloadedGroups;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }
}

