/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.usermanager;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.jcr.RepositoryException;
import net.sf.ehcache.constructs.blocking.CacheEntryFactory;
import net.sf.ehcache.constructs.blocking.SelfPopulatingCache;
import org.apache.commons.collections.list.UnmodifiableList;
import org.apache.commons.lang.StringUtils;
import org.jahia.bin.listeners.JahiaContextLoaderListener;
import org.jahia.exceptions.JahiaException;
import org.jahia.exceptions.JahiaInitializationException;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.cache.ehcache.EhCacheProvider;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.sites.JahiaSite;
import org.jahia.services.usermanager.JahiaGroup;
import org.jahia.services.usermanager.JahiaGroupManagerProvider;
import org.jahia.services.usermanager.JahiaGroupManagerService;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.services.usermanager.ProviderEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;

public class JahiaGroupManagerRoutingService
extends JahiaGroupManagerService
implements ApplicationEventPublisherAware {
    private static final Logger logger = LoggerFactory.getLogger(JahiaGroupManagerRoutingService.class);
    private static JahiaGroupManagerRoutingService mInstance = new JahiaGroupManagerRoutingService();
    private static final Comparator<JahiaGroupManagerProvider> PROVIDER_COMPARATOR = new Comparator<JahiaGroupManagerProvider>(){

        @Override
        public int compare(JahiaGroupManagerProvider o1, JahiaGroupManagerProvider o2) {
            return o1.getPriority() - o2.getPriority() != 0 ? o1.getPriority() - o2.getPriority() : o1.getKey().compareTo(o2.getKey());
        }
    };
    private SelfPopulatingCache siteKeyIdMap;
    private Map<String, JahiaGroupManagerProvider> providerMap = new HashMap<String, JahiaGroupManagerProvider>();
    private List<JahiaGroupManagerProvider> providers = Collections.emptyList();
    private JahiaGroupManagerProvider defaultProvider = null;
    private List<String> jahiaJcrEnforcedGroups;
    private String jahiaJcrEnforcedGroupsProviderKey;
    private ApplicationEventPublisher applicationEventPublisher;
    private EhCacheProvider ehCacheProvider;

    public static JahiaGroupManagerRoutingService getInstance() {
        return mInstance;
    }

    @Override
    public void start() throws JahiaInitializationException {
    }

    @Override
    public void stop() throws JahiaException {
    }

    @Override
    public JahiaGroup createGroup(int siteID, String name, Properties properties, boolean hidden) {
        return this.defaultProvider != null ? this.defaultProvider.createGroup(siteID, name, properties, hidden) : null;
    }

    @Override
    public boolean deleteGroup(JahiaGroup group) {
        return group != null && this.defaultProvider != null && this.defaultProvider.deleteGroup(group);
    }

    @Override
    public List<JahiaSite> getAdminGrantedSites(JahiaUser user) throws JahiaException {
        if (this.isSingleProvider()) {
            return this.defaultProvider.getAdminGrantedSites(user);
        }
        LinkedHashSet<JahiaSite> sitesList = new LinkedHashSet<JahiaSite>();
        for (JahiaGroupManagerProvider p : this.providers) {
            List<JahiaSite> adminGrantedSites = p.getAdminGrantedSites(user);
            if (adminGrantedSites == null) continue;
            sitesList.addAll(adminGrantedSites);
        }
        return new LinkedList<JahiaSite>(sitesList);
    }

    private boolean isSingleProvider() {
        return this.providers.size() == 1;
    }

    @Override
    public JahiaGroup getAdministratorGroup(int siteID) {
        JahiaGroupManagerProvider p;
        if (this.isSingleProvider()) {
            return this.defaultProvider.getAdministratorGroup(siteID);
        }
        JahiaGroup group = null;
        Iterator<JahiaGroupManagerProvider> i$ = this.providers.iterator();
        while (i$.hasNext() && (group = (p = i$.next()).getAdministratorGroup(siteID)) == null) {
        }
        return group;
    }

    @Override
    public List<String> getGroupList() {
        if (this.isSingleProvider()) {
            return this.defaultProvider.getGroupList();
        }
        ArrayList<String> groupList = new ArrayList<String>();
        for (JahiaGroupManagerProvider p : this.providers) {
            groupList.addAll(p.getGroupList());
        }
        return groupList;
    }

    @Override
    public List<String> getGroupList(int siteID) {
        if (this.isSingleProvider()) {
            return this.defaultProvider.getGroupList(siteID);
        }
        ArrayList<String> groupList = new ArrayList<String>();
        for (JahiaGroupManagerProvider p : this.providers) {
            List<String> curResult = p.getGroupList(siteID);
            if (curResult == null) continue;
            groupList.addAll(curResult);
        }
        return groupList;
    }

    @Override
    public List<String> getGroupnameList() {
        if (this.isSingleProvider()) {
            return this.defaultProvider.getGroupnameList();
        }
        ArrayList<String> groupNameList = new ArrayList<String>();
        for (JahiaGroupManagerProvider p : this.providers) {
            groupNameList.addAll(p.getGroupnameList());
        }
        return groupNameList;
    }

    @Override
    public List<String> getGroupnameList(int siteID) {
        if (this.isSingleProvider()) {
            return this.defaultProvider.getGroupnameList(siteID);
        }
        ArrayList<String> groupNameList = new ArrayList<String>();
        for (JahiaGroupManagerProvider p : this.providers) {
            groupNameList.addAll(p.getGroupnameList(siteID));
        }
        return groupNameList;
    }

    @Override
    public List<? extends JahiaGroupManagerProvider> getProviderList() {
        return this.providers;
    }

    @Override
    public List<String> getUserMembership(JahiaUser user) {
        if (this.isSingleProvider()) {
            return this.defaultProvider.getUserMembership(user);
        }
        ArrayList<String> userMembership = new ArrayList<String>();
        for (JahiaGroupManagerProvider p : this.providers) {
            List<String> curResult = p.getUserMembership(user);
            if (curResult == null) continue;
            userMembership.addAll(curResult);
        }
        return userMembership;
    }

    @Override
    public boolean groupExists(int siteID, String name) {
        JahiaGroupManagerProvider p;
        if (this.isSingleProvider()) {
            return this.defaultProvider.groupExists(siteID, name);
        }
        if (this.getJahiaJcrEnforcedGroups().contains(name)) {
            return this.getProvider(this.jahiaJcrEnforcedGroupsProviderKey).groupExists(siteID, name) ? Boolean.TRUE : Boolean.FALSE;
        }
        boolean result = false;
        Iterator<JahiaGroupManagerProvider> i$ = this.providers.iterator();
        while (i$.hasNext() && !(result = (p = i$.next()).groupExists(siteID, name))) {
        }
        return result;
    }

    @Override
    public JahiaGroup lookupGroup(String groupKey) {
        JahiaGroupManagerProvider p;
        if (this.isSingleProvider()) {
            return this.defaultProvider.lookupGroup(groupKey);
        }
        if (this.getJahiaJcrEnforcedGroups().contains(StringUtils.substringBefore((String)groupKey, (String)":"))) {
            return this.getProvider(this.jahiaJcrEnforcedGroupsProviderKey).lookupGroup(groupKey);
        }
        JahiaGroup group = null;
        Iterator<JahiaGroupManagerProvider> i$ = this.providers.iterator();
        while (i$.hasNext() && (group = (p = i$.next()).lookupGroup(groupKey)) == null) {
        }
        return group;
    }

    @Override
    public JahiaGroup lookupGroup(int siteID, String name) {
        JahiaGroupManagerProvider p;
        if (this.isSingleProvider()) {
            return this.defaultProvider.lookupGroup(siteID, name);
        }
        if (this.getJahiaJcrEnforcedGroups().contains(name)) {
            return this.getProvider(this.jahiaJcrEnforcedGroupsProviderKey).lookupGroup(siteID, name);
        }
        JahiaGroup group = null;
        Iterator<JahiaGroupManagerProvider> i$ = this.providers.iterator();
        while (i$.hasNext() && (group = (p = i$.next()).lookupGroup(siteID, name)) == null) {
        }
        return group;
    }

    @Override
    public boolean removeUserFromAllGroups(JahiaUser user) {
        if (this.isSingleProvider()) {
            return this.defaultProvider.removeUserFromAllGroups(user);
        }
        boolean success = true;
        for (JahiaGroupManagerProvider p : this.providers) {
            success = p.removeUserFromAllGroups(user) && success;
        }
        return success;
    }

    @Override
    public Set<JahiaGroup> searchGroups(int siteID, Properties searchCriterias) {
        if (this.isSingleProvider()) {
            return this.defaultProvider.searchGroups(siteID, searchCriterias);
        }
        HashSet<JahiaGroup> groupList = new HashSet<JahiaGroup>();
        for (JahiaGroupManagerProvider p : this.providers) {
            groupList.addAll(p.searchGroups(siteID, searchCriterias));
        }
        return groupList;
    }

    @Override
    public Set<JahiaGroup> searchGroups(String providerKey, int siteID, Properties searchCriterias) {
        JahiaGroupManagerProvider p;
        if (this.defaultProvider == null) {
            return Collections.emptySet();
        }
        if (this.isSingleProvider() || providerKey == null || (p = this.providerMap.get(providerKey)) == null) {
            return this.defaultProvider.searchGroups(siteID, searchCriterias);
        }
        return p.searchGroups(siteID, searchCriterias);
    }

    @Override
    public void updateCache(JahiaGroup jahiaGroup) {
        for (JahiaGroupManagerProvider p : this.providers) {
            if (!p.isDefaultProvider() && !p.getKey().equals(jahiaGroup.getProviderName())) continue;
            p.updateCache(jahiaGroup);
        }
    }

    @Override
    public boolean isGroupNameSyntaxCorrect(String name) {
        return this.defaultProvider != null && this.defaultProvider.isGroupNameSyntaxCorrect(name);
    }

    public void setJahiaJcrEnforcedGroups(List<String> jahiaJcrEnforcedGroups) {
        this.jahiaJcrEnforcedGroups = jahiaJcrEnforcedGroups;
    }

    public List<String> getJahiaJcrEnforcedGroups() {
        return this.jahiaJcrEnforcedGroups;
    }

    public void setJahiaJcrEnforcedGroupsProviderKey(String jahiaJcrEnforcedGroupsProviderKey) {
        this.jahiaJcrEnforcedGroupsProviderKey = jahiaJcrEnforcedGroupsProviderKey;
    }

    public String getJahiaJcrEnforcedGroupsProviderKey() {
        return this.jahiaJcrEnforcedGroupsProviderKey;
    }

    @Override
    public synchronized void registerProvider(JahiaGroupManagerProvider provider) {
        logger.info("Registered group provider {}", (Object)provider.getKey());
        LinkedList<JahiaGroupManagerProvider> newProviderList = null;
        if (!this.providers.isEmpty()) {
            TreeSet<JahiaGroupManagerProvider> newProviderSet = new TreeSet<JahiaGroupManagerProvider>(PROVIDER_COMPARATOR);
            newProviderSet.addAll(this.providers);
            newProviderSet.add(provider);
            newProviderList = new LinkedList<JahiaGroupManagerProvider>(newProviderSet);
        } else {
            newProviderList = new LinkedList<JahiaGroupManagerProvider>();
            newProviderList.add(provider);
        }
        this.providers = UnmodifiableList.decorate(newProviderList);
        this.providerMap.put(provider.getKey(), provider);
        if (this.defaultProvider == null || provider.isDefaultProvider()) {
            this.defaultProvider = provider;
        }
        if (this.applicationEventPublisher != null) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new ProviderEvent(provider.getKey()));
        }
    }

    @Override
    public synchronized void unregisterProvider(JahiaGroupManagerProvider provider) {
        if (!JahiaContextLoaderListener.isRunning()) {
            return;
        }
        logger.info("Unregistering group provider {}", (Object)provider.getKey());
        if (this.providerMap.remove(provider.getKey()) != null) {
            if (this.isSingleProvider()) {
                this.providers = Collections.emptyList();
            } else {
                TreeSet<JahiaGroupManagerProvider> newProviderSet = new TreeSet<JahiaGroupManagerProvider>(PROVIDER_COMPARATOR);
                newProviderSet.addAll(this.providers);
                newProviderSet.remove(provider);
                this.providers = UnmodifiableList.decorate(new LinkedList<JahiaGroupManagerProvider>(newProviderSet));
            }
        }
        if (provider.isDefaultProvider() && this.defaultProvider == provider) {
            for (JahiaGroupManagerProvider p : this.providers) {
                if (!p.isDefaultProvider()) continue;
                this.defaultProvider = p;
                break;
            }
            if (this.defaultProvider == null && !this.providers.isEmpty()) {
                this.defaultProvider = this.providers.iterator().next();
            }
        }
    }

    @Override
    public void flushCache() {
        if (this.isSingleProvider()) {
            this.defaultProvider.flushCache();
            return;
        }
        for (JahiaGroupManagerProvider p : this.providers) {
            p.flushCache();
        }
    }

    public void setDefaultProvider(JahiaGroupManagerProvider defaultProvider) {
        defaultProvider.setDefaultProvider(true);
        defaultProvider.setGroupManagerService(this);
        this.registerProvider(defaultProvider);
    }

    @Override
    public JahiaGroupManagerProvider getProvider(String name) {
        return this.providerMap.get(name);
    }

    private int getSiteId(String siteKey) {
        if (StringUtils.isNotEmpty((String)siteKey)) {
            if (this.siteKeyIdMap == null) {
                this.siteKeyIdMap = this.ehCacheProvider.registerSelfPopulatingCache("org.jahia.groups.siteKeyIDCache", new CacheEntryFactory(){

                    public Object createEntry(Object key) throws Exception {
                        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentSystemSession(null, null, null);
                        try {
                            return ServicesRegistry.getInstance().getJahiaSitesService().getSiteByKey((String)key, session).getID();
                        }
                        catch (RepositoryException e) {
                            return 0;
                        }
                    }
                });
            }
            return (Integer)this.siteKeyIdMap.get((Serializable)((Object)siteKey)).getObjectValue();
        }
        return 0;
    }

    public void flushSiteKeyIdMap() {
        if (this.siteKeyIdMap != null) {
            this.siteKeyIdMap.refresh(false);
        }
    }

    @Override
    public JahiaGroup createGroup(String siteKey, String name, Properties properties, boolean hidden) {
        return this.createGroup(this.getSiteId(siteKey), name, properties, hidden);
    }

    @Override
    public JahiaGroup getAdministratorGroup(String siteKey) {
        return this.getAdministratorGroup(this.getSiteId(siteKey));
    }

    @Override
    public List<String> getGroupList(String siteKey) {
        return this.getGroupList(this.getSiteId(siteKey));
    }

    @Override
    public List<String> getGroupnameList(String siteKey) {
        return this.getGroupnameList(this.getSiteId(siteKey));
    }

    @Override
    public boolean groupExists(String siteKey, String name) {
        return this.groupExists(this.getSiteId(siteKey), name);
    }

    @Override
    public JahiaGroup lookupGroup(String siteKey, String name) {
        return this.lookupGroup(this.getSiteId(siteKey), name);
    }

    @Override
    public Set<JahiaGroup> searchGroups(String siteKey, Properties searchCriterias) {
        return this.searchGroups(this.getSiteId(siteKey), searchCriterias);
    }

    @Override
    public Set<JahiaGroup> searchGroups(String providerKey, String siteKey, Properties searchCriterias) {
        return this.searchGroups(providerKey, this.getSiteId(siteKey), searchCriterias);
    }

    public synchronized void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public void setEhCacheProvider(EhCacheProvider ehCacheProvider) {
        this.ehCacheProvider = ehCacheProvider;
    }
}

