/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.usermanager;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.collections.list.UnmodifiableList;
import org.drools.core.util.StringUtils;
import org.jahia.bin.listeners.JahiaContextLoaderListener;
import org.jahia.exceptions.JahiaException;
import org.jahia.exceptions.JahiaInitializationException;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.services.usermanager.JahiaUserManagerProvider;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.services.usermanager.ProviderEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;

public class JahiaUserManagerRoutingService
extends JahiaUserManagerService
implements ApplicationEventPublisherAware {
    private static final Comparator<JahiaUserManagerProvider> PROVIDER_COMPARATOR = new Comparator<JahiaUserManagerProvider>(){

        @Override
        public int compare(JahiaUserManagerProvider o1, JahiaUserManagerProvider o2) {
            return o1.getPriority() - o2.getPriority() != 0 ? o1.getPriority() - o2.getPriority() : o1.getKey().compareTo(o2.getKey());
        }
    };
    private static transient Logger logger = LoggerFactory.getLogger(JahiaUserManagerRoutingService.class);
    private static JahiaUserManagerRoutingService mInstance = new JahiaUserManagerRoutingService();
    private Map<String, JahiaUserManagerProvider> providerMap = new HashMap<String, JahiaUserManagerProvider>(2);
    private List<JahiaUserManagerProvider> providers = Collections.emptyList();
    private JahiaUserManagerProvider defaultProvider;
    private ApplicationEventPublisher applicationEventPublisher;

    public static JahiaUserManagerRoutingService getInstance() {
        return mInstance;
    }

    @Override
    public void start() throws JahiaInitializationException {
    }

    @Override
    public void stop() throws JahiaException {
    }

    @Override
    public JahiaUser createUser(String name, String password, Properties properties) {
        return this.defaultProvider != null ? this.defaultProvider.createUser(name, password, properties) : null;
    }

    @Override
    public boolean deleteUser(JahiaUser user) {
        if (user == null || this.defaultProvider == null) {
            return false;
        }
        return this.defaultProvider.deleteUser(user);
    }

    @Override
    public int getNbUsers() throws JahiaException {
        if (this.isSingleProvider()) {
            return this.defaultProvider.getNbUsers();
        }
        int nbUsers = 0;
        for (JahiaUserManagerProvider p : this.providers) {
            nbUsers += p.getNbUsers();
        }
        return nbUsers;
    }

    @Override
    public List<String> getUserList() {
        if (this.isSingleProvider()) {
            return this.defaultProvider.getUserList();
        }
        ArrayList<String> userList = new ArrayList<String>();
        for (JahiaUserManagerProvider p : this.providers) {
            userList.addAll(p.getUserList());
        }
        return userList;
    }

    @Override
    public List<String> getUserList(String provider) {
        return this.providerMap.get(provider).getUserList();
    }

    public List<JahiaUserManagerProvider> getProviderList() {
        return this.providers;
    }

    @Override
    public List<String> getUsernameList() {
        if (this.isSingleProvider()) {
            return this.defaultProvider.getUsernameList();
        }
        ArrayList<String> userNameList = new ArrayList<String>();
        for (JahiaUserManagerProvider p : this.providers) {
            userNameList.addAll(p.getUsernameList());
        }
        return userNameList;
    }

    @Override
    public JahiaUser lookupUserByKey(String userKey) {
        JahiaUserManagerProvider p;
        if (StringUtils.isEmpty((CharSequence)userKey)) {
            return null;
        }
        if (this.isSingleProvider()) {
            return this.defaultProvider.lookupUserByKey(userKey);
        }
        JahiaUser user = null;
        Iterator<JahiaUserManagerProvider> i$ = this.providers.iterator();
        while (i$.hasNext() && (user = (p = i$.next()).lookupUserByKey(userKey)) == null) {
        }
        return user;
    }

    @Override
    public JahiaUser lookupUser(String name) {
        JahiaUserManagerProvider p;
        if (StringUtils.isEmpty((CharSequence)name)) {
            return null;
        }
        if (this.isSingleProvider()) {
            return this.defaultProvider.lookupUser(name);
        }
        JahiaUser user = null;
        Iterator<JahiaUserManagerProvider> i$ = this.providers.iterator();
        while (i$.hasNext() && (user = (p = i$.next()).lookupUser(name)) == null) {
        }
        return user;
    }

    @Override
    public Set<Principal> searchUsers(Properties searchcriteria) {
        if (this.isSingleProvider()) {
            return new LinkedHashSet<Principal>(this.defaultProvider.searchUsers(searchcriteria));
        }
        LinkedHashSet<Principal> userList = new LinkedHashSet<Principal>();
        for (JahiaUserManagerProvider p : this.providers) {
            userList.addAll(p.searchUsers(searchcriteria));
        }
        return userList;
    }

    public Set searchUsers(String providerKey, Properties searchcriteria) {
        JahiaUserManagerProvider p;
        if (this.defaultProvider == null) {
            return Collections.emptySet();
        }
        if (this.isSingleProvider() || providerKey == null || (p = this.providerMap.get(providerKey)) == null) {
            return this.defaultProvider.searchUsers(searchcriteria);
        }
        return p.searchUsers(searchcriteria);
    }

    @Override
    public void updateCache(JahiaUser jahiaUser) {
        for (JahiaUserManagerProvider p : this.providers) {
            if (!p.isDefaultProvider() && !p.getKey().equals(jahiaUser.getProviderName())) continue;
            p.updateCache(jahiaUser);
        }
    }

    @Override
    public boolean userExists(String name) {
        JahiaUserManagerProvider p;
        if (this.isSingleProvider()) {
            return this.defaultProvider.userExists(name);
        }
        boolean result = false;
        Iterator<JahiaUserManagerProvider> i$ = this.providers.iterator();
        while (i$.hasNext() && !(result = (p = i$.next()).userExists(name))) {
        }
        return result;
    }

    @Override
    public boolean isUsernameSyntaxCorrect(String name) {
        return this.defaultProvider != null && this.defaultProvider.isUsernameSyntaxCorrect(name);
    }

    @Override
    public synchronized void registerProvider(JahiaUserManagerProvider provider) {
        logger.info("Registering user provider {}", (Object)provider.getKey());
        LinkedList<JahiaUserManagerProvider> newProviderList = null;
        if (!this.providers.isEmpty()) {
            TreeSet<JahiaUserManagerProvider> newProviderSet = new TreeSet<JahiaUserManagerProvider>(PROVIDER_COMPARATOR);
            newProviderSet.addAll(this.providers);
            newProviderSet.add(provider);
            newProviderList = new LinkedList<JahiaUserManagerProvider>(newProviderSet);
        } else {
            newProviderList = new LinkedList<JahiaUserManagerProvider>();
            newProviderList.add(provider);
        }
        this.providers = UnmodifiableList.decorate(newProviderList);
        this.providerMap.put(provider.getKey(), provider);
        if (this.defaultProvider == null || provider.isDefaultProvider()) {
            this.defaultProvider = provider;
        }
        if (this.applicationEventPublisher != null) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new ProviderEvent(provider.getKey()));
        }
    }

    @Override
    public synchronized void unregisterProvider(JahiaUserManagerProvider provider) {
        if (!JahiaContextLoaderListener.isRunning()) {
            return;
        }
        logger.info("Unregistering user provider {}", (Object)provider.getKey());
        if (this.providerMap.remove(provider.getKey()) != null) {
            if (this.isSingleProvider()) {
                this.providers = Collections.emptyList();
            } else {
                TreeSet<JahiaUserManagerProvider> newProviderSet = new TreeSet<JahiaUserManagerProvider>(PROVIDER_COMPARATOR);
                newProviderSet.addAll(this.providers);
                newProviderSet.remove(provider);
                this.providers = UnmodifiableList.decorate(new LinkedList<JahiaUserManagerProvider>(newProviderSet));
            }
        }
        if (provider.isDefaultProvider() && this.defaultProvider == provider) {
            for (JahiaUserManagerProvider p : this.providers) {
                if (!p.isDefaultProvider()) continue;
                this.defaultProvider = p;
                break;
            }
            if (this.defaultProvider == null && !this.providers.isEmpty()) {
                this.defaultProvider = this.providers.iterator().next();
            }
        }
    }

    public void setDefaultProvider(JahiaUserManagerProvider defaultProvider) {
        defaultProvider.setDefaultProvider(true);
        defaultProvider.setUserManagerService(this);
        this.registerProvider(defaultProvider);
    }

    private boolean isSingleProvider() {
        return this.providers.size() == 1;
    }

    @Override
    public JahiaUserManagerProvider getProvider(String name) {
        return this.providerMap.get(name);
    }

    public synchronized void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }
}

