/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.usermanager;

import java.security.Principal;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jahia.exceptions.JahiaException;
import org.jahia.services.JahiaService;
import org.jahia.services.usermanager.JahiaGroup;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.services.usermanager.JahiaUserManagerProvider;
import org.jahia.services.usermanager.JahiaUserSplittingRule;
import org.jahia.utils.EncryptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JahiaUserManagerService
extends JahiaService {
    public static Logger LOGGER = LoggerFactory.getLogger(JahiaUserManagerService.class);
    public static final String GUEST_USERNAME = "guest";
    public static final String MULTI_CRITERIA_SEARCH_OPERATION = "multi_criteria_search_op";
    public static final String COUNT_LIMIT = "countLimit";
    private JahiaUserSplittingRule userSplittingRule;

    public static String encryptPassword(String password) {
        if (StringUtils.isEmpty((String)password)) {
            return null;
        }
        return EncryptionUtils.sha1DigestLegacy(password);
    }

    public static String getKey(Principal p) {
        if (p instanceof JahiaUser) {
            return ((JahiaUser)p).getUserKey();
        }
        if (p instanceof JahiaGroup) {
            return ((JahiaGroup)p).getGroupKey();
        }
        return p.getName();
    }

    public static boolean isGuest(JahiaUser user) {
        return user == null || GUEST_USERNAME.equals(user.getUsername());
    }

    public static boolean isNotGuest(JahiaUser user) {
        return user != null && !GUEST_USERNAME.equals(user.getUsername());
    }

    public abstract JahiaUser createUser(String var1, String var2, Properties var3);

    public abstract boolean deleteUser(JahiaUser var1);

    public abstract int getNbUsers() throws JahiaException;

    public abstract List<? extends JahiaUserManagerProvider> getProviderList();

    public abstract JahiaUserManagerProvider getProvider(String var1);

    public abstract List<String> getUserList();

    public abstract List<String> getUserList(String var1);

    public abstract List<String> getUsernameList();

    public abstract JahiaUser lookupUserByKey(String var1);

    public abstract JahiaUser lookupUser(String var1);

    public abstract Set<Principal> searchUsers(Properties var1);

    public abstract Set<Principal> searchUsers(String var1, Properties var2);

    public abstract void updateCache(JahiaUser var1);

    public abstract boolean userExists(String var1);

    public abstract boolean isUsernameSyntaxCorrect(String var1);

    public abstract void registerProvider(JahiaUserManagerProvider var1);

    public abstract void unregisterProvider(JahiaUserManagerProvider var1);

    public void setUserSplittingRule(JahiaUserSplittingRule userSplittingRule) {
        this.userSplittingRule = userSplittingRule;
    }

    public JahiaUserSplittingRule getUserSplittingRule() {
        return this.userSplittingRule;
    }
}

