/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.usermanager;

import java.security.Principal;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.jcr.Node;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.services.usermanager.jcr.JCRGroup;

public class UsersGroup
extends JCRGroup {
    private static final long serialVersionUID = 8220270074777283565L;

    public UsersGroup(Node nodeWrapper, JCRTemplate jcrTemplate, int siteID) {
        super(nodeWrapper, siteID);
    }

    @Override
    public Enumeration<Principal> members() {
        return new Vector<Principal>(this.getRecursiveUserMembers()).elements();
    }

    @Override
    public Set<Principal> getRecursiveUserMembers() {
        HashSet<Principal> users = new HashSet<Principal>();
        LinkedList<JahiaUser> userList = new LinkedList<JahiaUser>();
        JahiaUserManagerService jahiaUserManagerService = ServicesRegistry.getInstance().getJahiaUserManagerService();
        List<String> l = jahiaUserManagerService.getUserList();
        for (String s : l) {
            userList.add(jahiaUserManagerService.lookupUserByKey(s));
        }
        JahiaUser guest = jahiaUserManagerService.lookupUser("guest");
        userList.remove(guest);
        if (userList != null) {
            users.addAll(userList);
        }
        return users;
    }

    @Override
    public boolean addMember(Principal principal) {
        return false;
    }

    @Override
    public boolean removeMember(Principal principal) {
        return false;
    }

    @Override
    public boolean isMember(Principal principal) {
        return principal != null && !principal.getName().equals("guest");
    }

    @Override
    public void addMembers(Collection<Principal> principals) {
    }
}

